/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.dao.AttachmentTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=attachmentType]")
public class AttachmentTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageAttachmentType(), MESSAGES.pageAttachmentTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('AttachmentTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.attachmentFlagIsImage(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.attachmentTypeFlagRoomPicture(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.attachmentTypeFlagShowRoomsTable(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.attachmentTypeFlagShowRoomTooltip(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSortBy(1);
        for (AttachmentType atype : AttachmentTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(atype.getUniqueId());
            r.setField(0, atype.getReference());
            r.setField(1, atype.getAbbreviation());
            r.setField(2, atype.getLabel());
            r.setField(3, AttachmentType.VisibilityFlag.IS_IMAGE.in(atype.getVisibility()) ? "true" : "false");
            r.setField(4, AttachmentType.VisibilityFlag.ROOM_PICTURE_TYPE.in(atype.getVisibility()) ? "true" : "false");
            r.setField(5, AttachmentType.VisibilityFlag.SHOW_ROOMS_TABLE.in(atype.getVisibility()) ? "true" : "false");
            r.setField(6, AttachmentType.VisibilityFlag.SHOW_ROOM_TOOLTIP.in(atype.getVisibility()) ? "true" : "false");
            int used = ((Number)hibSession.createQuery("select count(p) from LocationPicture p where p.type.uniqueId = :uniqueId", Number.class).setParameter("uniqueId", (Object)atype.getUniqueId()).uniqueResult()).intValue();
            r.setDeletable(used == 0);
        }
        data.setEditable(context.hasPermission(Right.AttachmentTypeEdit));
        return data;
    }

    protected int getVisibility(SimpleEditInterface.Record record) {
        int flags = 0;
        if ("true".equals(record.getField(3))) {
            flags = AttachmentType.VisibilityFlag.IS_IMAGE.set(flags);
        }
        if ("true".equals(record.getField(4))) {
            flags = AttachmentType.VisibilityFlag.ROOM_PICTURE_TYPE.set(flags);
        }
        if ("true".equals(record.getField(5))) {
            flags = AttachmentType.VisibilityFlag.SHOW_ROOMS_TABLE.set(flags);
        }
        if ("true".equals(record.getField(6))) {
            flags = AttachmentType.VisibilityFlag.SHOW_ROOM_TOOLTIP.set(flags);
        }
        return flags;
    }

    @Override
    @PreAuthorize(value="checkPermission('AttachmentTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (AttachmentType type : AttachmentTypeDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('AttachmentTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        AttachmentType type = new AttachmentType();
        type.setReference(record.getField(0));
        type.setAbbreviation(record.getField(1));
        type.setLabel(record.getField(2));
        type.setVisibility(this.getVisibility(record));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(AttachmentType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getAbbreviation(), (Object)record.getField(1)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(2)) && type.getVisibility().intValue() == this.getVisibility(record)) {
            return;
        }
        type.setReference(record.getField(0));
        type.setAbbreviation(record.getField(1));
        type.setLabel(record.getField(2));
        type.setVisibility(this.getVisibility(record));
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('AttachmentTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((AttachmentType)AttachmentTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(AttachmentType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('AttachmentTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((AttachmentType)AttachmentTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

