/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import java.util.Date;
import org.joda.time.DateTimeZone;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=ServerDateTimeFormat.ServerTimeZoneRequest.class)
@GwtRpcLogging(value=GwtRpcLogging.Level.ON_EXCEPTION)
public class ServerTimeZoneBackend
implements GwtRpcImplementation<ServerDateTimeFormat.ServerTimeZoneRequest, ServerDateTimeFormat.ServerTimeZoneResponse> {
    @Override
    public ServerDateTimeFormat.ServerTimeZoneResponse execute(ServerDateTimeFormat.ServerTimeZoneRequest request, SessionContext context) {
        long transition;
        Date first = null;
        Date last = null;
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (first == null || first.after(session.getEventBeginDate())) {
                first = session.getEventBeginDate();
            }
            if (last != null && !last.before(session.getEventEndDate())) continue;
            last = session.getEventEndDate();
        }
        DateTimeZone zone = DateTimeZone.getDefault();
        int offsetInMinutes = zone.getOffset(first.getTime()) / 60000;
        ServerDateTimeFormat.ServerTimeZoneResponse ret = new ServerDateTimeFormat.ServerTimeZoneResponse();
        ret.setId(zone.getID());
        ret.addName(zone.getName(new Date().getTime()));
        ret.setTimeZoneOffsetInMinutes(offsetInMinutes);
        long time = first.getTime();
        while (time != (transition = zone.nextTransition(time)) && time < last.getTime()) {
            int adjustment = zone.getOffset(transition) / 60000 - offsetInMinutes;
            ret.addTransition((int)(transition / 3600000L), adjustment);
            time = transition;
        }
        return ret;
    }
}

