/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.permissions.PermissionForRight;
import org.unitime.timetable.security.permissions.SimpleExaminationPermission;
import org.unitime.timetable.security.rights.Right;

public class ExaminationPermissions {

    @PermissionForRight(value=Right.ExaminationDistributionPreferenceDetail)
    public static class ExaminationDistributionPreferenceDetail
    implements Permission<DistributionPref> {
        @Autowired
        Permission<Exam> permissionExaminationDetail;

        @Override
        public boolean check(UserContext user, DistributionPref source) {
            for (DistributionObject distrObj : source.getDistributionObjects()) {
                if (!(distrObj.getPrefGroup() instanceof Exam) || !this.permissionExaminationDetail.check(user, (Exam)distrObj.getPrefGroup())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<DistributionPref> type() {
            return DistributionPref.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationDistributionPreferenceDelete)
    public static class ExaminationDistributionPreferenceDelete
    extends ExaminationDistributionPreferenceEdit {
    }

    @PermissionForRight(value=Right.ExaminationDistributionPreferenceEdit)
    public static class ExaminationDistributionPreferenceEdit
    implements Permission<DistributionPref> {
        @Autowired
        Permission<Exam> permissionExaminationEdit;

        @Override
        public boolean check(UserContext user, DistributionPref source) {
            for (DistributionObject distrObj : source.getDistributionObjects()) {
                if (distrObj.getPrefGroup() instanceof Exam) {
                    if (this.permissionExaminationEdit.check(user, (Exam)distrObj.getPrefGroup())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        @Override
        public Class<DistributionPref> type() {
            return DistributionPref.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationDistributionPreferenceAdd)
    public static class ExaminationDistributionPreferenceAdd
    extends AddExamination {
    }

    @PermissionForRight(value=Right.ExaminationDistributionPreferences)
    public static class ExaminationDistributionPreferences
    extends Examinations {
    }

    @PermissionForRight(value=Right.ExaminationSchedule)
    public static class ExaminationSchedule
    implements Permission<Session> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Session source) {
            return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ReportExamsFinal, DepartmentStatusType.Status.ReportExamsMidterm);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationAssignment)
    public static class ExaminationAssignment
    implements Permission<Exam> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Exam source) {
            return user.getCurrentAuthority().hasRight(Right.DepartmentIndependent) && this.permissionExaminationStatus.check(user, source.getSession(), source.getExamType(), DepartmentStatusType.Status.ExamTimetable);
        }

        @Override
        public Class<Exam> type() {
            return Exam.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationEditClearPreferences)
    public static class ExaminationEditClearPreferences
    extends EditExamination {
    }

    @PermissionForRight(value=Right.DistributionPreferenceExam)
    public static class DistributionPreferenceExam
    extends EditExamination {
    }

    @PermissionForRight(value=Right.ExaminationClone)
    public static class ExaminationClone
    extends EditExamination {
    }

    @PermissionForRight(value=Right.ExaminationDelete)
    public static class ExaminationDelete
    extends EditExamination {
    }

    @PermissionForRight(value=Right.ExaminationEdit)
    public static class EditExamination
    implements Permission<Exam> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Exam source) {
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                return this.permissionExaminationStatus.check(user, source.getSession(), source.getExamType(), DepartmentStatusType.Status.ExamTimetable);
            }
            for (ExamOwner owner : source.getOwners()) {
                if (!this.permissionExaminationStatus.check(user, owner.getCourse().getDepartment(), source.getExamType(), DepartmentStatusType.Status.ExamEdit)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Exam> type() {
            return Exam.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationAdd)
    public static class AddExamination
    implements Permission<Session> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Session source) {
            if (ExamType.findAllUsed(source.getUniqueId()).isEmpty()) {
                return false;
            }
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamTimetable);
            }
            return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamEdit);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationDetail)
    public static class ExaminationDetail
    implements Permission<Exam> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Exam source) {
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                return this.permissionExaminationStatus.check(user, source.getSession(), source.getExamType(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
            }
            for (ExamOwner owner : source.getOwners()) {
                if (!this.permissionExaminationStatus.check(user, owner.getCourse().getSubjectArea().getDepartment(), source.getExamType(), DepartmentStatusType.Status.ExamView)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Exam> type() {
            return Exam.class;
        }
    }

    @PermissionForRight(value=Right.ExaminationView)
    public static class ExaminationView
    implements Permission<Exam> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Exam source) {
            SimpleExaminationPermission p = new SimpleExaminationPermission(){

                @Override
                public boolean checkManager(UserAuthority authority, ExamStatus examStatus, DepartmentStatusType.Status ... status) {
                    return true;
                }
            };
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                return p.check(user, source.getSession(), source.getExamType(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
            }
            for (ExamOwner owner : source.getOwners()) {
                if (!p.check(user, owner.getCourse().getSubjectArea().getDepartment(), source.getExamType(), DepartmentStatusType.Status.ExamView)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Class<Exam> type() {
            return Exam.class;
        }
    }

    @PermissionForRight(value=Right.Examinations)
    public static class Examinations
    implements Permission<Session> {
        @Autowired
        Permission.PermissionExamination permissionExaminationStatus;

        @Override
        public boolean check(UserContext user, Session source) {
            if (SubjectArea.getUserSubjectAreas(user, false).isEmpty()) {
                return false;
            }
            if (ExamType.findAllUsed(source.getUniqueId()).isEmpty()) {
                return false;
            }
            if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
            }
            return this.permissionExaminationStatus.check(user, source, null, DepartmentStatusType.Status.ExamView);
        }

        @Override
        public Class<Session> type() {
            return Session.class;
        }
    }
}

