/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.reports.pointintimedata.WSCHByDepartment;

public class AllWSCHByDepartment
extends WSCHByDepartment {
    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnOrganizedWeeklyClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyClassHours());
        hdr.add(MSG.columnWeeklyClassHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    @Override
    public String reportName() {
        return MSG.deptWSCHReportAllHours();
    }

    @Override
    public String reportDescription() {
        return MSG.deptWSCHReportAllHoursNote();
    }

    @Override
    protected float weeklyClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    protected float weeklyStudentClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    public void createWeeklyStudentContactHoursByDepartmentReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (Department d : pointInTimeData.getSession().getDepartments()) {
            if (d.getSubjectAreas().isEmpty()) continue;
            float deptTotalWsch = 0.0f;
            float deptTotalWch = 0.0f;
            float deptTotalOrgWsch = 0.0f;
            float deptTotalOrgWch = 0.0f;
            float deptTotalNotOrgWsch = 0.0f;
            float deptTotalNotOrgWch = 0.0f;
            for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, d.getUniqueId(), hibSession)) {
                for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                    if (processedClasses.contains(pc.getUniqueId())) continue;
                    processedClasses.add(pc.getUniqueId());
                    deptTotalWch += this.weeklyClassHours(pc);
                    deptTotalWsch += this.weeklyStudentClassHours(pc);
                    deptTotalOrgWsch += pc.getOrganizedWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                    deptTotalOrgWch += pc.getOrganizedWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                    deptTotalNotOrgWsch += pc.getNotOrganizedWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                    deptTotalNotOrgWch += pc.getNotOrganizedWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                }
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(d.getDeptCode());
            row.add(d.getAbbreviation());
            row.add(d.getName());
            row.add(Float.toString(deptTotalOrgWch));
            row.add(Float.toString(deptTotalNotOrgWch));
            row.add(Float.toString(deptTotalWch));
            row.add(Float.toString(deptTotalOrgWsch));
            row.add(Float.toString(deptTotalNotOrgWsch));
            row.add(Float.toString(deptTotalWsch));
            this.addDataRow(row);
        }
    }
}

