/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.StudentSchedulingPreferencesInterface;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.util.Formats;

public class ChangeStudentPreferences
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Collection<Long> iStudentIds = null;
    private StudentSchedulingPreferencesInterface iPreferences = null;

    public ChangeStudentPreferences forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public ChangeStudentPreferences forStudent(Long studentId) {
        if (this.iStudentIds == null) {
            this.iStudentIds = new ArrayList<Long>();
        }
        this.iStudentIds.add(studentId);
        return this;
    }

    public ChangeStudentPreferences withPreferences(StudentSchedulingPreferencesInterface preferences) {
        this.iPreferences = preferences;
        return this;
    }

    public Collection<Long> getStudentIds() {
        return this.iStudentIds;
    }

    public StudentSchedulingPreferencesInterface getPreference() {
        return this.iPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        for (Long studentId : this.getStudentIds()) {
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                XStudent student = server.getStudent(studentId);
                helper.beginTransaction();
                Date ts = new Date();
                try {
                    Student dbStudent = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null && dbStudent != null) {
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
                        dbStudent.setPreferredClassModality(this.iPreferences.getClassModality());
                        dbStudent.setPreferredScheduleGaps(this.iPreferences.getScheduleGaps());
                        dbStudent.setClassStartDate(this.iPreferences.getClassDateFrom());
                        dbStudent.setClassEndDate(this.iPreferences.getClassDateTo());
                        if (this.iPreferences.getClassDateFrom() != null) {
                            action.addOptionBuilder().setKey("class-first").setValue(Formats.getDateFormat(CONST.requestDateFormat()).format(this.iPreferences.getClassDateFrom()));
                        }
                        if (this.iPreferences.getClassDateTo() != null) {
                            action.addOptionBuilder().setKey("class-last").setValue(Formats.getDateFormat(CONST.requestDateFormat()).format(this.iPreferences.getClassDateTo()));
                        }
                        if (this.iPreferences.getClassModality() != null) {
                            action.addOptionBuilder().setKey("modality").setValue(this.iPreferences.getClassModality().name());
                        }
                        if (this.iPreferences.getScheduleGaps() != null) {
                            action.addOptionBuilder().setKey("gaps").setValue(this.iPreferences.getScheduleGaps().name());
                        }
                        helper.getHibSession().merge((Object)dbStudent);
                        student.updatePreferences(dbStudent, server.getAcademicSession().getDatePatternFirstDate());
                        server.update(student, false);
                        String pref = FindStudentInfoAction.getStudentSchedulingPreference(student, server, helper);
                        if (pref != null) {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setText(pref).setTimeStamp(ts.getTime()).setLevel(OnlineSectioningLog.Message.Level.INFO));
                        }
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            finally {
                lock.release();
            }
        }
        return true;
    }

    @Override
    public String name() {
        return "schedule-prefs";
    }
}

