/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class SpecialRegistrationRetrieveAll
implements OnlineSectioningAction<List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private SpecialRegistrationInterface.RetrieveAllSpecialRegistrationsRequest iRequest;

    public SpecialRegistrationRetrieveAll withRequest(SpecialRegistrationInterface.RetrieveAllSpecialRegistrationsRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.RetrieveAllSpecialRegistrationsRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !CustomSpecialRegistrationHolder.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> response;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> list = response = CustomSpecialRegistrationHolder.getProvider().retrieveAllRegistrations(server, helper, student);
            return list;
        }
        finally {
            lock.release();
        }
    }

    @Override
    public String name() {
        return "specreg-getall";
    }
}

