/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomSpecialRegistrationHolder;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.util.DateUtils;

public class SpecialRegistrationRequestVariableTitleCourse
implements OnlineSectioningAction<SpecialRegistrationInterface.VariableTitleCourseResponse> {
    private static final long serialVersionUID = 1L;
    private SpecialRegistrationInterface.VariableTitleCourseRequest iRequest;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public SpecialRegistrationRequestVariableTitleCourse withRequest(SpecialRegistrationInterface.VariableTitleCourseRequest request) {
        this.iRequest = request;
        return this;
    }

    public SpecialRegistrationInterface.VariableTitleCourseRequest getRequest() {
        return this.iRequest;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpecialRegistrationInterface.VariableTitleCourseResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            SpecialRegistrationProvider specReg;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            Session session = (Session)SessionDAO.getInstance().get(server.getAcademicSession().getUniqueId(), helper.getHibSession());
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            helper.getAction().addOptionBuilder().setKey("course").setValue(this.getRequest().getCourse().getCourseName());
            action.addMessageBuilder().setText(this.getRequest().getCourse().getCourseName() + ": " + this.getRequest().getTitle()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            if (this.getRequest().hasTitle()) {
                helper.getAction().addOptionBuilder().setKey("title").setValue(this.getRequest().getTitle());
            }
            if (this.getRequest().getInstructor() != null) {
                helper.getAction().addOptionBuilder().setKey("instructor").setValue(this.getRequest().getInstructor().getName());
                action.addMessageBuilder().setText("Instructor: " + this.getRequest().getInstructor().getName()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            }
            if (this.getRequest().hasNote()) {
                helper.getAction().addOptionBuilder().setKey("note").setValue(this.getRequest().getNote());
            }
            if (this.getRequest().getCredit() != null) {
                helper.getAction().addOptionBuilder().setKey("credit").setValue(this.getRequest().getCredit().toString());
                if (this.getRequest().getCredit().floatValue() > this.getRequest().getCourse().getAvailableCredits().iterator().next().floatValue()) {
                    action.addMessageBuilder().setText("Credit: " + this.getRequest().getCredit()).setLevel(OnlineSectioningLog.Message.Level.INFO);
                }
            }
            if (this.getRequest().hasGradeMode()) {
                helper.getAction().addOptionBuilder().setKey("gradeMode").setValue(this.getRequest().getGradeModeCode());
                if (!this.getRequest().getGradeModeCode().equals(this.getRequest().getCourse().getDefaultGradeModeCode())) {
                    action.addMessageBuilder().setText("Grade Mode: " + this.getRequest().getGradeModeLabel()).setLevel(OnlineSectioningLog.Message.Level.INFO);
                }
            }
            if (this.getRequest().getStartDate() != null && this.getRequest().getEndDate() != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                helper.getAction().addOptionBuilder().setKey("dates").setValue(df.format(this.getRequest().getStartDate()) + " - " + df.format(this.getRequest().getEndDate()));
            }
            if (this.getRequest().getInstructor() != null && this.getRequest().isCheckIfExists()) {
                for (XCourseId variableTitleCourseResponse : server.findCourses(this.getRequest().getCourse().getCourseName(), null, new AnyCourseMatcher())) {
                    XCourse course;
                    XCourse xCourse = course = variableTitleCourseResponse instanceof XCourse ? (XCourse)variableTitleCourseResponse : server.getCourse(variableTitleCourseResponse.getCourseId());
                    if (course.getTitle() == null || !course.getTitle().equalsIgnoreCase(this.getRequest().getTitle())) continue;
                    XOffering offering = server.getOffering(variableTitleCourseResponse.getOfferingId());
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse(variableTitleCourseResponse.getCourseId(), variableTitleCourseResponse.getCourseName());
                    rc.setCourseTitle(course.getTitle());
                    for (XConfig config : offering.getConfigs()) {
                        for (XSubpart subpart : config.getSubparts()) {
                            block7: for (XSection section : subpart.getSections()) {
                                for (XInstructor ins : section.getAllInstructors()) {
                                    if (!ins.getIntructorId().equals(this.getRequest().getInstructor().getId()) || !this.getRequest().getStartDate().equals(this.getFirstDate(section, session)) || !this.getRequest().getEndDate().equals(this.getLastDate(section, session))) continue;
                                    rc.setSelectedClass(section.getSectionId(), section.getName(course.getCourseId()), true, true);
                                    continue block7;
                                }
                            }
                        }
                    }
                    if (!rc.hasSelectedClasses()) continue;
                    SpecialRegistrationInterface.VariableTitleCourseResponse variableTitleCourseResponse2 = new SpecialRegistrationInterface.VariableTitleCourseResponse(rc);
                    return variableTitleCourseResponse2;
                }
            }
            if ((specReg = CustomSpecialRegistrationHolder.getProvider()) == null) {
                throw new SectioningException(MSG.exceptionNotSupportedFeature());
            }
            SpecialRegistrationInterface.VariableTitleCourseResponse variableTitleCourseResponse = specReg.requestVariableTitleCourse(server, helper, student, this.getRequest());
            return variableTitleCourseResponse;
        }
        finally {
            lock.release();
        }
    }

    protected Date getFirstDate(XSection section, Session session) {
        if (section.getTime() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date start = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
        cal.setTime(start);
        int idx = section.getTime().getWeeks().nextSetBit(0);
        cal.add(6, idx);
        return cal.getTime();
    }

    protected Date getLastDate(XSection section, Session session) {
        if (section.getTime() == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date last = DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear());
        cal.setTime(last);
        int idx = section.getTime().getWeeks().length() - 1;
        cal.add(6, idx);
        return cal.getTime();
    }

    @Override
    public String name() {
        return "req-var-course";
    }
}

