/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.cpsolver.studentsct.model.Course;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.timetable.model.CourseOffering;

public class XCourseId
implements Serializable,
Comparable<XCourseId>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iOfferingId;
    private Long iCourseId;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private String iTitle = null;
    private boolean iHasUniqueName = true;
    private String iType = null;

    public XCourseId() {
    }

    public XCourseId(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseId(CourseOffering course) {
        this.iOfferingId = course.getInstructionalOffering().getUniqueId();
        this.iCourseId = course.getUniqueId();
        this.iSubjectArea = course.getSubjectAreaAbbv().trim();
        this.iCourseNumber = course.getCourseNbr().trim();
        this.iTitle = course.getTitle() == null ? null : course.getTitle().trim();
        this.iType = course.getCourseType() == null ? null : course.getCourseType().getReference();
    }

    public XCourseId(Long offeringId, Long courseId, String subjectArea, String courseNumber) {
        this.iOfferingId = offeringId;
        this.iCourseId = courseId;
        this.iSubjectArea = subjectArea;
        this.iCourseNumber = courseNumber;
    }

    public XCourseId(XCourseId course) {
        this.iOfferingId = course.getOfferingId();
        this.iCourseId = course.getCourseId();
        this.iSubjectArea = course.getSubjectArea();
        this.iCourseNumber = course.getCourseNumber();
        this.iTitle = course.getTitle();
        this.iType = course.getType();
    }

    public XCourseId(Course course) {
        this.iOfferingId = course.getOffering().getId();
        this.iCourseId = course.getId();
        this.iSubjectArea = course.getSubjectArea();
        this.iCourseNumber = course.getCourseNumber();
        this.iTitle = course.getTitle();
        this.iType = course.getType();
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Long getCourseId() {
        return this.iCourseId;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public String getCourseName() {
        return this.getSubjectArea() + " " + this.getCourseNumber();
    }

    public String getTitle() {
        return this.iTitle;
    }

    public boolean hasType() {
        return this.iType != null && !this.iType.isEmpty();
    }

    public String getType() {
        return this.iType;
    }

    public String getCourseNameInLowerCase() {
        return this.getCourseName().toLowerCase();
    }

    public boolean hasUniqueName() {
        return this.iHasUniqueName;
    }

    public void setHasUniqueName(boolean hasUniqueName) {
        this.iHasUniqueName = hasUniqueName;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XCourseId)) {
            return false;
        }
        return this.getCourseId().equals(((XCourseId)o).getCourseId());
    }

    public int hashCode() {
        return (int)(this.getCourseId() ^ this.getCourseId() >>> 32);
    }

    public String toString() {
        return this.getCourseName();
    }

    @Override
    public int compareTo(XCourseId c) {
        int cmp = NaturalOrderComparator.getInstance().compare(this.getCourseName(), c.getCourseName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = (this.getTitle() == null ? "" : this.getTitle()).compareToIgnoreCase(c.getTitle() == null ? "" : c.getTitle());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getCourseId() == null ? Long.valueOf(-1L) : this.getCourseId()).compareTo(c.getCourseId() == null ? -1L : c.getCourseId());
    }

    public boolean matchCourseName(String queryInLowerCase) {
        if (this.getCourseName().toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        if (this.getCourseNumber().toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        if (this.getCourseName().indexOf(45) >= 0 && this.getCourseName().substring(this.getCourseName().lastIndexOf(45) + 1).trim().toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        if (this.getTitle() == null) {
            return false;
        }
        if ((this.getCourseName() + " " + this.getTitle()).toLowerCase().startsWith(queryInLowerCase)) {
            return true;
        }
        return (this.getCourseName() + " - " + this.getTitle()).toLowerCase().startsWith(queryInLowerCase);
    }

    public boolean matchCourse(String queryInLowerCase) {
        if (this.getCourseName().equalsIgnoreCase(queryInLowerCase)) {
            return true;
        }
        if (this.getTitle() == null) {
            return false;
        }
        if ((this.getCourseName() + " " + this.getTitle()).equalsIgnoreCase(queryInLowerCase)) {
            return true;
        }
        return (this.getCourseName() + " - " + this.getTitle()).equalsIgnoreCase(queryInLowerCase);
    }

    public boolean matchTitle(String queryInLowerCase) {
        if (this.getTitle() == null) {
            return false;
        }
        return !this.matchCourseName(queryInLowerCase) && (this.getTitle().toLowerCase().startsWith(queryInLowerCase) || this.getTitle().toLowerCase().contains(" " + queryInLowerCase));
    }

    public boolean matchType(boolean allCourseTypes, boolean noCourseType, Set<String> allowedCourseTypes) {
        if (allCourseTypes) {
            return true;
        }
        if (this.hasType()) {
            return allowedCourseTypes != null && allowedCourseTypes.contains(this.getType());
        }
        return noCourseType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iOfferingId = in.readLong();
        this.iCourseId = in.readLong();
        this.iSubjectArea = (String)in.readObject();
        this.iCourseNumber = (String)in.readObject();
        this.iTitle = (String)in.readObject();
        this.iHasUniqueName = in.readBoolean();
        this.iType = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iOfferingId);
        out.writeLong(this.iCourseId);
        out.writeObject(this.iSubjectArea);
        out.writeObject(this.iCourseNumber);
        out.writeObject(this.iTitle);
        out.writeBoolean(this.iHasUniqueName);
        out.writeObject(this.iType);
    }
}

