/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.util.Formats;

public class XEStudentEnrollment
implements StudentEnrollmentProvider {
    private static Log sLog = LogFactory.getLog(XEStudentEnrollment.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public XEStudentEnrollment() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getBannerReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getBannerReadTimeout() {
        return ApplicationProperties.getProperty("banner.xe.readTimeout", "60000");
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean manager) {
        String user;
        if (manager && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean manager) {
        String pwd;
        if (manager && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getBannerUser(OnlineSectioningHelper helper) {
        String user;
        if (helper.isAdmin() && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(OnlineSectioningHelper helper) {
        String pwd;
        if (helper.isAdmin() && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getBannerRecheck() {
        return ApplicationProperties.getProperty("banner.xe.recheck");
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isBannerAdmin(OnlineSectioningHelper helper) {
        if (helper.isAdmin() && this.isBannerAdmin()) {
            if (helper.hasAdminPermission()) {
                return true;
            }
            if (helper.hasAvisorPermission()) {
                return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.advisorIsAdmin", "false"));
            }
        }
        return false;
    }

    protected boolean isBannerWaitlist() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.waitlist", "false"));
    }

    protected float getMaxCredit(boolean admin) {
        String maxCredit;
        if (admin && (maxCredit = ApplicationProperties.getProperty("banner.xe.admin.maxCredit")) != null) {
            return Float.parseFloat(maxCredit);
        }
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxCredit", "-1"));
    }

    protected boolean isCheckMaxHours(boolean admin) {
        String checkMaxHours;
        if (admin && (checkMaxHours = ApplicationProperties.getProperty("banner.xe.admin.checkMaxHours")) != null) {
            return "true".equalsIgnoreCase(checkMaxHours);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.checkMaxHours", "false"));
    }

    protected ConditionalDropType getConditionalAddDrop(boolean admin) {
        String conditionalAddDrop;
        if (admin && (conditionalAddDrop = ApplicationProperties.getProperty("banner.xe.admin.conditionalAddDrop")) != null) {
            return ConditionalDropType.parseType(conditionalAddDrop);
        }
        return ConditionalDropType.parseType(ApplicationProperties.getProperty("banner.xe.conditionalAddDrop"));
    }

    protected boolean throwExceptionWhenNoChange(boolean admin) {
        String errorWhenNoChange;
        if (admin && (errorWhenNoChange = ApplicationProperties.getProperty("banner.xe.admin.errorWhenNoChange")) != null) {
            return "true".equalsIgnoreCase(errorWhenNoChange);
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.errorWhenNoChange", "false"));
    }

    protected float getMaxHoursDefault() {
        return Float.parseFloat(ApplicationProperties.getProperty("banner.xe.maxHoursDefault", "18"));
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "systemIn");
    }

    protected String fixErrorMessage(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String translate = ApplicationProperties.getProperty("banner.xe.translateMessages");
        if (translate != null && !translate.isEmpty()) {
            for (String rule : translate.split("[\n\r]+")) {
                if (rule == null || rule.indexOf(124) < 0) continue;
                String regexp = rule.substring(0, rule.indexOf(124));
                String replace = rule.substring(rule.indexOf(124) + 1);
                message = message.replaceAll(regexp, replace);
            }
        }
        return message;
    }

    protected String getBannerId(XStudent student) {
        Object id = student.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected boolean isPreserveGradeMode() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.keepGradeMode", "false"));
    }

    protected String getResetGradeModesRegExp() {
        return ApplicationProperties.getProperty("banner.xe.resetGradeModes", "H|Q|R");
    }

    protected boolean isCheckDropLastActiveClass(OnlineSectioningHelper helper) {
        if (this.isBannerAdmin(helper)) {
            return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.dropLastActiveClassAdminCheck", ApplicationProperties.getProperty("banner.xe.dropLastActiveClassCheck", "false")));
        }
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.dropLastActiveClassCheck", "false"));
    }

    protected String getDropLastActiveClassMessage() {
        return ApplicationProperties.getProperty("banner.xe.dropLastActiveClassMessage", "Dropping last active class is not allowed.");
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && student.getStudentId() != null) {
            return;
        }
        ClientResource resource = null;
        try {
            String pin = helper.getPin();
            if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                pin = student.getPin();
            }
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            boolean admin = this.isBannerAdmin(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
            }
            resource = new ClientResource(this.getBannerSite());
            resource.setNext((Uniform)this.iClient);
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(helper), this.getBannerPassword(helper));
            Gson gson = this.getGson(helper);
            XEInterface.RegisterResponse original = null;
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("bannerId", this.getBannerId(student));
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
            if (admin) {
                String param = this.getAdminParameter();
                resource.addQueryParameter(param, "SB");
                helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
            } else if (pin != null && !pin.isEmpty()) {
                resource.addQueryParameter("altPin", pin);
                helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
            }
            long t0 = System.currentTimeMillis();
            try {
                resource.get(MediaType.APPLICATION_JSON);
            }
            catch (ResourceException exception) {
                helper.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(this.fixErrorMessage(error.message));
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(this.fixErrorMessage(error.description));
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(this.fixErrorMessage(error.errorMessage));
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
            if (current != null && !current.isEmpty()) {
                original = (XEInterface.RegisterResponse)current.get(0);
            }
            if (original != null && helper.isDebugEnabled()) {
                helper.debug("Current registration: " + gson.toJson((Object)original));
            }
            if (original != null && original.maxHours != null) {
                check.setMaxCredit(original.maxHours);
            }
            if (original == null || !original.validStudent.booleanValue()) {
                String bannerRecheck = this.getBannerRecheck();
                Object reason = null;
                boolean noreason = true;
                boolean recheck = true;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerRecheck == null || !m.matches(bannerRecheck)) {
                            recheck = false;
                        }
                        noreason = false;
                        if ("Your PIN is invalid.".equals(m)) {
                            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED, true);
                            if (pin == null || pin.isEmpty()) continue;
                        }
                        if (reason == null) {
                            reason = this.fixErrorMessage(m);
                            continue;
                        }
                        reason = (String)reason + "<br>" + this.fixErrorMessage(m);
                    }
                }
                if (noreason) {
                    reason = "Failed to check student registration eligility.";
                    if (bannerRecheck == null || !((String)reason).matches(bannerRecheck)) {
                        recheck = false;
                    }
                }
                if (recheck) {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT, true);
                } else {
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                }
                check.setMessage((String)reason);
            } else if (student.getStudentId() == null) {
                boolean keepMessage;
                boolean bl = keepMessage = check.hasMessage() && ((Number)helper.getHibSession().createQuery("select count(s) from Student s where s.externalUniqueId = :id and s.session.academicYear = :year and s.session.academicTerm = :term and s.session.academicInitiative != :campus", Number.class).setParameter("id", (Object)student.getExternalId()).setParameter("term", (Object)server.getAcademicSession().getTerm()).setParameter("year", (Object)server.getAcademicSession().getYear()).setParameter("campus", (Object)server.getAcademicSession().getCampus()).uniqueResult()).intValue() > 0;
                if (!keepMessage) {
                    check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later.");
                }
                check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                if (this.isCanRequestUpdates()) {
                    ArrayList<XStudent> students = new ArrayList<XStudent>(1);
                    students.add(student);
                    this.requestUpdate(server, helper, students);
                }
            } else {
                OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                HashSet<String> sectionExternalIds = new HashSet<String>();
                for (XRequest request : student.getRequests()) {
                    XCourseRequest r;
                    XEnrollment e;
                    helper.getAction().addRequest(OnlineSectioningHelper.toProto(request));
                    if (!(request instanceof XCourseRequest) || (e = (r = (XCourseRequest)request).getEnrollment()) == null) continue;
                    XOffering offering = server.getOffering(e.getOfferingId());
                    for (XSection xSection : offering.getSections(e)) {
                        stored.addSection(OnlineSectioningHelper.toProto(xSection, e));
                        String extId = xSection.getExternalId(e.getCourseId());
                        if (extId == null) continue;
                        sectionExternalIds.add(extId);
                    }
                }
                helper.getAction().addEnrollment(stored);
                OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                Object added = "";
                String resetGradeModes = this.getResetGradeModesRegExp();
                float currentCredit = 0.0f;
                if (original.registrations != null) {
                    for (XEInterface.Registration registration : original.registrations) {
                        if (registration.isRegistered()) {
                            if (!sectionExternalIds.remove(registration.courseReferenceNumber) && !this.eligibilityIgnoreBannerRegistration(server, helper, student, registration)) {
                                added = (String)added + (((String)added).isEmpty() ? "" : ", ") + registration.courseReferenceNumber;
                            }
                            OnlineSectioningLog.Section.Builder builder = external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                            if (registration.registrationStatusDate != null) {
                                builder.setTimeStamp(registration.registrationStatusDate.getMillis());
                            }
                            if (registration.gradingMode != null && !registration.gradingMode.isEmpty()) {
                                check.addGradeMode(registration.courseReferenceNumber, registration.gradingMode, registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes));
                            }
                            if (registration.creditHour != null) {
                                check.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                            }
                        }
                        if (!registration.hasCredit()) continue;
                        currentCredit += registration.creditHour.floatValue();
                    }
                }
                check.setCurrentCredit(Float.valueOf(currentCredit));
                helper.getAction().addEnrollment(external);
                Object removed = "";
                for (String string : sectionExternalIds) {
                    removed = (String)removed + (((String)removed).isEmpty() ? "" : ", ") + string;
                }
                if (!((String)added).isEmpty() || !((String)removed).isEmpty()) {
                    if (this.updateStudentRegistration(server, helper, student, original.registrations)) {
                        return;
                    }
                    check.setMessage("UniTime enrollment data are not synchronized with Banner enrollment data, please try again later (" + (((String)removed).isEmpty() ? "added " + (String)added : (((String)added).isEmpty() ? "dropped " + (String)removed : "added " + (String)added + ", dropped " + (String)removed)) + ")");
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL, false);
                    if (this.isCanRequestUpdates()) {
                        ArrayList<XStudent> arrayList = new ArrayList<XStudent>(1);
                        arrayList.add(student);
                        this.requestUpdate(server, helper, arrayList);
                    }
                }
            }
        }
        catch (JsonParseException e) {
            helper.warn("Failed to read Banner response: " + e.getMessage(), e);
            throw new SectioningException("Invalid response received from Banner, likely due to a timeout. Please try again. If the problem persists, please contact the admins.");
        }
        catch (SectioningException e) {
            helper.info("Banner eligibility failed: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.warn("Banner eligibility failed: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean eligibilityIgnoreBannerRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, XEInterface.Registration reg) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<StudentEnrollmentProvider.EnrollmentFailure> enroll(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<StudentEnrollmentProvider.EnrollmentRequest> enrollments, Set<Long> lockedCourses, OnlineSectioningInterface.GradeModes gradeModes, boolean hasWaitListedCourses) throws SectioningException {
        int currentDateIndex;
        if (this.isCheckDropLastActiveClass(helper) && (currentDateIndex = Days.daysBetween((ReadablePartial)new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()), (ReadablePartial)new LocalDate()).getDays()) >= 0) {
            boolean hasActiveClass = false;
            boolean dropEverything = true;
            if (enrollments != null) {
                block39: for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                    XCourse course = enrollmentRequest.getCourse();
                    if (course == null || enrollmentRequest.getSections() == null) continue;
                    for (XSection xSection : enrollmentRequest.getSections()) {
                        dropEverything = false;
                        if (!xSection.getTime().isActive(currentDateIndex) || xSection.isCancelled()) continue;
                        hasActiveClass = true;
                        break block39;
                    }
                }
            }
            if (!hasActiveClass) {
                boolean hadActiveClass = false;
                block41: for (XRequest request : student.getRequests()) {
                    if (!(request instanceof XCourseRequest) || ((XCourseRequest)request).getEnrollment() == null) continue;
                    XEnrollment enrollment = ((XCourseRequest)request).getEnrollment();
                    for (XSection xSection : server.getOffering(enrollment.getOfferingId()).getSections(enrollment)) {
                        if (!xSection.getTime().isActive(currentDateIndex) || xSection.isCancelled()) continue;
                        hadActiveClass = true;
                        break block41;
                    }
                }
                if (hadActiveClass) {
                    Long otherActive;
                    Long otherEnrolled;
                    Calendar calendar = Calendar.getInstance(Locale.US);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    Date today = calendar.getTime();
                    if (dropEverything && (otherEnrolled = (Long)helper.getHibSession().createQuery("select count(e) from   StudentClassEnrollment e inner join e.student st inner join st.session s,   Session z where   st.externalUniqueId = :studentId and e.clazz.cancelled = false and   z.uniqueId = :sessionId and s != z and s.academicTerm = z.academicTerm and s.academicYear = z.academicYear ", Long.class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setParameter("studentId", (Object)student.getExternalId()).uniqueResult()) > 0L) {
                        dropEverything = false;
                    }
                    if (!dropEverything && (otherActive = (Long)helper.getHibSession().createQuery("select count(c) from   StudentClassEnrollment e inner join e.student st inner join st.session s   inner join e.clazz c inner join c.schedulingSubpart ss,   DatePattern dp, Session z where   (c.datePattern = dp or (c.datePattern is null and ss.datePattern = dp) or (c.datePattern is null and ss.datePattern is null and dp = s.defaultDatePattern)) and   adddate(dp.session.sessionBeginDateTime, -dp.offset + length(dp.pattern) - 1) >= :today and   st.externalUniqueId = :studentId and c.cancelled = false and   z.uniqueId = :sessionId and s != z and s.academicTerm = z.academicTerm and s.academicYear = z.academicYear ", Long.class).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setParameter("today", (Object)today).setParameter("studentId", (Object)student.getExternalId()).uniqueResult()) > 0L) {
                        hasActiveClass = true;
                    }
                    if (!hasActiveClass && hadActiveClass && !dropEverything) {
                        throw new SectioningException(this.getDropLastActiveClassMessage());
                    }
                }
            }
        }
        ClientResource resource = null;
        try {
            ArrayList<StudentEnrollmentProvider.EnrollmentFailure> fails;
            block184: {
                Object course;
                void var16_38;
                float maxCredit;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                    pin = student.getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                String string = this.getBannerCampus(session);
                boolean admin = this.isBannerAdmin(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Enrolling " + student.getName() + " to " + String.valueOf(enrollments) + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                if ((maxCredit = this.getMaxCredit(admin)) > 0.0f) {
                    float f = 0.0f;
                    for (XRequest xRequest : student.getRequests()) {
                        XCourseRequest cr;
                        if (!(xRequest instanceof XCourseRequest) || (cr = (XCourseRequest)xRequest).getEnrollment() == null) continue;
                        f += cr.getEnrollment().getCredit(server);
                    }
                    float f2 = 0.0f;
                    for (StudentEnrollmentProvider.EnrollmentRequest req : enrollments) {
                        f2 += req.getCredit();
                    }
                    if (f2 > maxCredit && f2 > f) {
                        throw new SectioningException(ApplicationProperties.getProperty("banner.xe.messages.maxCredit", "Maximum of {max} hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(maxCredit > f ? maxCredit : f))).replace("{credit}", sCreditFormat.format(Float.valueOf(f2)))).setCanRequestOverride(true);
                    }
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(helper), this.getBannerPassword(helper));
                Gson gson = this.getGson(helper);
                Object var16_36 = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin) {
                    String string2 = this.getAdminParameter();
                    resource.addQueryParameter(string2, "SB");
                    helper.getAction().addOptionBuilder().setKey(string2).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long l = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error2 = response.getError();
                        if (error2 != null && error2.message != null) {
                            throw new SectioningException(this.fixErrorMessage(error2.message));
                        }
                        if (error2 != null && error2.description != null) {
                            throw new SectioningException(this.fixErrorMessage(error2.description));
                        }
                        if (error2 != null && error2.errorMessage != null) {
                            throw new SectioningException(this.fixErrorMessage(error2.errorMessage));
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - l);
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("original").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    XEInterface.RegisterResponse registerResponse = (XEInterface.RegisterResponse)current.get(0);
                }
                if (var16_38 == null || !var16_38.validStudent.booleanValue()) {
                    Object reason = null;
                    if (var16_38 != null && var16_38.failureReasons != null) {
                        for (String m : var16_38.failureReasons) {
                            if (reason == null) {
                                reason = this.fixErrorMessage(m);
                                continue;
                            }
                            reason = (String)reason + "\n" + this.fixErrorMessage(m);
                        }
                    }
                    throw new SectioningException((String)(reason == null ? "Failed to check student registration status." : reason));
                }
                HashMap<String, XEInterface.Registration> registered = new HashMap<String, XEInterface.Registration>();
                HashSet<String> noadd = new HashSet<String>();
                HashSet<String> nodrop = new HashSet<String>();
                HashMap<String, String> actions = new HashMap<String, String>();
                HashSet<String> notregistered = new HashSet<String>();
                if (helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)var16_38));
                }
                HashMap<String, String> code2desc = new HashMap<String, String>();
                if (var16_38.registrations != null) {
                    for (XEInterface.Registration reg : var16_38.registrations) {
                        if (reg.isRegistered()) {
                            registered.put(reg.courseReferenceNumber, reg);
                            if (!reg.canDrop(admin, actions)) {
                                nodrop.add(reg.courseReferenceNumber);
                            }
                            if (reg.gradingMode == null) continue;
                            code2desc.put(reg.gradingMode, reg.gradingModeDescription);
                            continue;
                        }
                        notregistered.add(reg.courseReferenceNumber);
                        if (reg.canAdd(admin)) continue;
                        noadd.add(reg.courseReferenceNumber);
                    }
                }
                if (this.isCheckMaxHours(admin)) {
                    Float maxHours = var16_38.maxHours;
                    if (maxHours == null || maxHours.floatValue() <= 0.0f) {
                        maxHours = Float.valueOf(this.getMaxHoursDefault());
                    }
                    float credit = 0.0f;
                    for (StudentEnrollmentProvider.EnrollmentRequest req : enrollments) {
                        credit += req.getCredit();
                    }
                    if (credit > maxHours.floatValue()) {
                        throw new SectioningException(ApplicationProperties.getProperty("banner.xe.messages.maxHours", "Maximum of {max} hours exceeded.").replace("{max}", sCreditFormat.format(maxHours)).replace("{credit}", sCreditFormat.format(Float.valueOf(credit)))).setCanRequestOverride(true);
                    }
                }
                boolean changed = false;
                boolean hasDrop = false;
                HashMap id2section = new HashMap();
                HashMap<Object, XCourse> id2course = new HashMap<Object, XCourse>();
                HashSet<Object> added = new HashSet<Object>();
                XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(term, this.getBannerId(student), pin, admin);
                fails = new ArrayList<StudentEnrollmentProvider.EnrollmentFailure>();
                HashSet<Object> failed = new HashSet<Object>();
                HashSet<Object> checked = new HashSet<Object>();
                HashSet<Long> lockedCoursesWithChanges = new HashSet<Long>();
                for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                    Iterator<XEInterface.FailedRegistration> sections;
                    XCourse course2 = enrollmentRequest.getCourse();
                    if (lockedCourses.contains(course2.getCourseId()) && !enrollmentRequest.getSections().isEmpty()) {
                        for (XSection section : enrollmentRequest.getSections()) {
                            String id = section.getExternalId(course2.getCourseId());
                            XEInterface.Registration registration = (XEInterface.Registration)registered.get(id);
                            if (registration != null) {
                                if (added.add(id)) {
                                    req.keep(id);
                                }
                                if ((sections = (List)id2section.get(id)) == null) {
                                    sections = new ArrayList<XSection>();
                                    id2section.put(id, sections);
                                }
                                sections.add((XEInterface.FailedRegistration)((Object)section));
                                id2course.put(id, course2);
                                enrollmentRequest.setGradeMode(registration.gradingMode);
                                enrollmentRequest.setCreditHour(id, registration.creditHour);
                                continue;
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course2, section, MESSAGES.courseLocked(course2.getCourseName()), false, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_LOCKED.name(), MESSAGES.courseLocked(course2.getCourseName()))));
                            checked.add(id);
                            failed.add(id);
                            sections = (List)id2section.get(id);
                            if (sections == null) {
                                sections = new ArrayList();
                                id2section.put(id, sections);
                            }
                            sections.add((XEInterface.FailedRegistration)((Object)section));
                            id2course.put(id, course2);
                            lockedCoursesWithChanges.add(course2.getCourseId());
                        }
                        continue;
                    }
                    for (XSection section : enrollmentRequest.getSections()) {
                        String id2 = section.getExternalId(course2.getCourseId());
                        XEInterface.Registration registration = (XEInterface.Registration)registered.get(id2);
                        if (registration == null && (!section.isEnabledForScheduling() || noadd.contains(id2))) {
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course2, section, "Section not available for student scheduling.", false, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED.name(), "Section not available for student scheduling.")));
                            checked.add(id2);
                            failed.add(id2);
                        } else if (registration != null) {
                            if (added.add(id2)) {
                                req.keep(id2);
                            }
                            enrollmentRequest.setGradeMode(registration.gradingMode);
                            enrollmentRequest.setCreditHour(id2, registration.creditHour);
                        } else {
                            changed = true;
                            if (added.add(id2)) {
                                req.add(id2, notregistered.contains(id2));
                            }
                        }
                        sections = (List)id2section.get(id2);
                        if (sections == null) {
                            sections = new ArrayList();
                            id2section.put(id2, sections);
                        }
                        sections.add((XEInterface.FailedRegistration)((Object)section));
                        id2course.put(id2, course2);
                    }
                }
                for (Map.Entry entry : registered.entrySet()) {
                    String id3 = (String)entry.getKey();
                    if (added.contains(id3)) continue;
                    boolean drop = true;
                    boolean found = false;
                    for (XRequest xRequest : student.getRequests()) {
                        if (!(xRequest instanceof XCourseRequest)) continue;
                        for (XCourseId xCourseId : ((XCourseRequest)xRequest).getCourseIds()) {
                            XOffering xOffering = server.getOffering(xCourseId.getOfferingId());
                            if (xOffering == null) continue;
                            for (XConfig xConfig : xOffering.getConfigs()) {
                                for (XSubpart xSubpart : xConfig.getSubparts()) {
                                    for (XSection x : xSubpart.getSections()) {
                                        if (!id3.equals(x.getExternalId(xCourseId.getCourseId()))) continue;
                                        found = true;
                                        ArrayList<XSection> sections = (ArrayList<XSection>)id2section.get(id3);
                                        if (sections == null) {
                                            sections = new ArrayList<XSection>();
                                            id2section.put(id3, sections);
                                        }
                                        sections.add(x);
                                        id2course.put(id3, xOffering.getCourse(xCourseId.getCourseId()));
                                        if (!x.isEnabledForScheduling() || nodrop.contains(id3)) {
                                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(xOffering.getCourse(xCourseId), x, "Section not available for student scheduling.", true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED.name(), "Section not available for student scheduling.")));
                                            checked.add(id3);
                                            failed.add(id3);
                                            drop = false;
                                        } else if (lockedCoursesWithChanges.contains(xCourseId.getCourseId())) {
                                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(xOffering.getCourse(xCourseId), x, MESSAGES.courseLocked(xCourseId.getCourseName()), true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_LOCKED.name(), MESSAGES.courseLocked(xCourseId.getCourseName()))));
                                            checked.add(id3);
                                            failed.add(id3);
                                            drop = false;
                                        }
                                        for (StudentEnrollmentProvider.EnrollmentRequest request : enrollments) {
                                            if (!request.getCourse().equals(xCourseId)) continue;
                                            request.setGradeMode(((XEInterface.Registration)entry.getValue()).gradingMode);
                                            request.setCreditHour(id3, ((XEInterface.Registration)entry.getValue()).creditHour);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!found && !string.equals(((XEInterface.Registration)entry.getValue()).campus)) {
                        if (!added.add(id3)) continue;
                        req.keep(id3);
                        continue;
                    }
                    if (drop) {
                        changed = true;
                        req.drop(id3, actions);
                        hasDrop = true;
                        continue;
                    }
                    if (!added.add(id3)) continue;
                    req.keep(id3);
                }
                switch (this.getConditionalAddDrop(admin)) {
                    case ALWAYS: {
                        req.setConditionalAddDrop(true);
                        break;
                    }
                    case HAS_DROP: {
                        if (!hasDrop) break;
                        req.setConditionalAddDrop(true);
                        break;
                    }
                    case IS_REGISTERED: {
                        if (registered.isEmpty()) break;
                        req.setConditionalAddDrop(true);
                        break;
                    }
                }
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)req));
                }
                helper.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
                if (req.isEmpty() || !changed) {
                    if (!fails.isEmpty()) {
                        for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                            helper.getAction().addMessageBuilder().setText(enrollmentFailure.toString()).setLevel(OnlineSectioningLog.Message.Level.WARN);
                        }
                    }
                    Iterator iterator = fails;
                    return iterator;
                }
                long t1 = System.currentTimeMillis();
                try {
                    resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error3 = response.getError();
                        if (error3 != null && error3.message != null) {
                            throw new SectioningException(this.fixErrorMessage(error3.message));
                        }
                        if (error3 != null && error3.description != null) {
                            throw new SectioningException(this.fixErrorMessage(error3.description));
                        }
                        if (error3 != null && error3.errorMessage != null) {
                            throw new SectioningException(this.fixErrorMessage(error3.errorMessage));
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                }
                XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
                if (response == null || !response.validStudent.booleanValue()) {
                    Object reason = null;
                    if (response != null && response.failureReasons != null) {
                        for (String m : response.failureReasons) {
                            if (reason == null) {
                                reason = this.fixErrorMessage(m);
                                continue;
                            }
                            reason = (String)reason + "\n" + this.fixErrorMessage(m);
                        }
                    }
                    throw new SectioningException((String)(reason == null ? "Failed to enroll student." : reason));
                }
                HashSet<String> outcome = new HashSet<String>();
                String resetGradeModes = this.getResetGradeModesRegExp();
                float currentCredit = 0.0f;
                if (response.registrations != null) {
                    OnlineSectioningLog.Enrollment.Builder builder = OnlineSectioningLog.Enrollment.newBuilder();
                    builder.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                    for (XEInterface.Registration registration : response.registrations) {
                        XCourse course3;
                        void var47_177;
                        String string3 = registration.courseReferenceNumber;
                        checked.add(string3);
                        ArrayList<StudentEnrollmentProvider.EnrollmentError> errors = new ArrayList<StudentEnrollmentProvider.EnrollmentError>();
                        Object var47_176 = null;
                        if (registration.crnErrors != null) {
                            for (XEInterface.CrnError crnError : registration.crnErrors) {
                                if (var47_177 == null) {
                                    String string4 = this.fixErrorMessage(crnError.message);
                                } else {
                                    String string5 = (String)var47_177 + "\n" + this.fixErrorMessage(crnError.message);
                                }
                                errors.add(new StudentEnrollmentProvider.EnrollmentError(crnError.messageType, this.fixErrorMessage(crnError.message)));
                            }
                        }
                        if ("Registered".equals(registration.statusDescription)) {
                            builder.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(registration.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(registration.subject + " " + registration.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(registration.scheduleType));
                            outcome.add(registration.courseReferenceNumber);
                            if (gradeModes != null && registration.gradingMode != null) {
                                gradeModes.addGradeMode(registration.courseReferenceNumber, new OnlineSectioningInterface.GradeMode(registration.gradingMode, registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes)));
                            }
                            if (gradeModes != null && registration.creditHour != null) {
                                gradeModes.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                                currentCredit += registration.creditHour.floatValue();
                            }
                            if (added.contains(string3)) {
                                XCourse course2;
                                if (var47_177 == null || (course2 = (XCourse)id2course.get(string3)) == null) continue;
                                for (XSection section : (List)id2section.get(string3)) {
                                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course2, section, (String)var47_177, true, errors));
                                    failed.add(string3);
                                }
                                continue;
                            }
                        }
                        if ("Deleted".equals(registration.statusDescription) || "Dropped".equals(registration.statusDescription)) continue;
                        if ("Withdrawn".equals(registration.statusDescription) && gradeModes != null && registration.creditHour != null) {
                            currentCredit += registration.creditHour.floatValue();
                        }
                        if (var47_177 == null && response.registrationException != null) {
                            String string6 = response.registrationException;
                            errors.add(new StudentEnrollmentProvider.EnrollmentError("Unable to make requested changes so your schedule was not changed.".equals(response.registrationException) ? "IGNORE" : "UNKNOWN", response.registrationException));
                        }
                        if ((course3 = (XCourse)id2course.get(string3)) == null) continue;
                        for (XSection section : (List)id2section.get(string3)) {
                            void var47_182;
                            if (var47_182 == null && !failed.add(string3)) continue;
                            if (var47_182 == null) {
                                errors.add(new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", added.contains(string3) ? "Enrollment failed." : "Drop failed."));
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure(course3, section, (String)(var47_182 == null ? (added.contains(string3) ? "Enrollment failed." : "Drop failed.") : var47_182), "Registered".equals(registration.statusDescription), errors));
                        }
                    }
                    helper.getAction().addEnrollment(builder);
                }
                if (gradeModes != null) {
                    gradeModes.setCurrentCredit(Float.valueOf(currentCredit));
                }
                if (response.failedRegistrations != null) {
                    TreeSet<StudentEnrollmentProvider.EnrollmentError> treeSet = new TreeSet<StudentEnrollmentProvider.EnrollmentError>();
                    for (XEInterface.FailedRegistration failedRegistration : response.failedRegistrations) {
                        if (failedRegistration.failedCRN != null) {
                            String string7 = failedRegistration.failedCRN;
                            course = (XCourse)id2course.get(string7);
                            if (course != null) {
                                for (XSection section2 : (List)id2section.get(string7)) {
                                    if (failedRegistration.failure == null && !failed.add(string7)) continue;
                                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, section2, failedRegistration.failure == null ? "Enrollment failed." : this.fixErrorMessage(failedRegistration.failure), false, new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", failedRegistration.failure == null ? "Enrollment failed." : this.fixErrorMessage(failedRegistration.failure))));
                                }
                            }
                            checked.add(string7);
                            continue;
                        }
                        if (failedRegistration.failure == null) continue;
                        treeSet.add(new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", this.fixErrorMessage(failedRegistration.failure)));
                    }
                    Object em = null;
                    for (StudentEnrollmentProvider.EnrollmentError enrollmentError : treeSet) {
                        if (em == null) {
                            em = enrollmentError.getMessage();
                            continue;
                        }
                        em = em + "\n" + enrollmentError.getMessage();
                    }
                    if (response.registrationException != null) {
                        em = em == null ? this.fixErrorMessage(response.registrationException) : em + "\n" + this.fixErrorMessage(response.registrationException);
                        treeSet.add(new StudentEnrollmentProvider.EnrollmentError("Unable to make requested changes so your schedule was not changed.".equals(response.registrationException) ? "IGNORE" : "UNKNOWN", this.fixErrorMessage(response.registrationException)));
                    }
                    for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                        course = enrollmentRequest.getCourse();
                        for (XSection section2 : enrollmentRequest.getSections()) {
                            String string8 = section2.getExternalId(((XCourseId)course).getCourseId());
                            if (checked.contains(string8) || em == null && !failed.add(string8)) continue;
                            if (em == null) {
                                fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, section2, "Enrollment failed.", false, new StudentEnrollmentProvider.EnrollmentError("UNKNOWN", "Enrollment failed.")));
                                continue;
                            }
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, section2, (String)em, false, (Collection<StudentEnrollmentProvider.EnrollmentError>)treeSet));
                        }
                    }
                }
                if (outcome.equals(registered.keySet()) && !fails.isEmpty() && this.throwExceptionWhenNoChange(admin) && !hasWaitListedCourses) {
                    void var42_109;
                    String string9 = "";
                    for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                        if ("Unable to make requested changes so your schedule was not changed.".equals(enrollmentFailure.getMessage())) continue;
                        String string10 = (String)var42_109 + (var42_109.isEmpty() ? "" : "<br>") + String.valueOf(enrollmentFailure);
                    }
                    Iterator<XEInterface.Registration> e = new SectioningException(var42_109.replace("\n", " ")).setCanRequestOverride(true);
                    for (StudentEnrollmentProvider.EnrollmentFailure enrollmentFailure : fails) {
                        if (enrollmentFailure.getSection() != null && !"Unable to make requested changes so your schedule was not changed.".equals(enrollmentFailure.getMessage())) {
                            ((SectioningException)((Object)e)).setSectionMessage(enrollmentFailure.getSection().getSectionId(), enrollmentFailure.getMessage());
                        }
                        if (!enrollmentFailure.hasErrors()) continue;
                        for (StudentEnrollmentProvider.EnrollmentError enrollmentError : enrollmentFailure.getErrors()) {
                            if ("IGNORE".equals(enrollmentError.getCode())) continue;
                            ((SectioningException)((Object)e)).addError(new ClassAssignmentInterface.ErrorMessage(enrollmentFailure.getCourse().getCourseName(), enrollmentFailure.getSection().getExternalId(enrollmentFailure.getCourse().getCourseId()), enrollmentError.getCode(), enrollmentError.getMessage()));
                        }
                    }
                    throw e;
                }
                if (this.isPreserveGradeMode() && response.registrations != null) {
                    XEInterface.RegisterRequest registerRequest = new XEInterface.RegisterRequest(this.getBannerTerm(server.getAcademicSession()), this.getBannerId(student), null, true);
                    try {
                        if (resetGradeModes != null && !resetGradeModes.isEmpty()) {
                            block72: for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                                String string11 = enrollmentRequest.getGradeMode();
                                if (string11 == null || !string11.matches(resetGradeModes)) continue;
                                for (XEInterface.Registration registration : response.registrations) {
                                    if (!"Registered".equals(registration.statusDescription) || !enrollmentRequest.getCourse().equals(id2course.get(registration.courseReferenceNumber)) || registration.gradingMode == null || string11.equals(registration.gradingMode)) continue;
                                    enrollmentRequest.resetGradeMode(registration.gradingMode);
                                    helper.info("Resetting grade mode for " + enrollmentRequest.getCourse().getCourseName() + " from " + string11 + " to " + registration.gradingMode);
                                    continue block72;
                                }
                            }
                        }
                        registerRequest.courseReferenceNumbers = new ArrayList<XEInterface.CourseReferenceNumber>();
                        registerRequest.actionsAndOptions = new ArrayList<XEInterface.RegisterAction>();
                        block74: for (XEInterface.Registration registration : response.registrations) {
                            if (!"Registered".equals(registration.statusDescription)) continue;
                            registerRequest.courseReferenceNumbers.add(new XEInterface.CourseReferenceNumber(registration.courseReferenceNumber));
                            XCourse xCourse = (XCourse)id2course.get(registration.courseReferenceNumber);
                            if (xCourse == null) continue;
                            for (StudentEnrollmentProvider.EnrollmentRequest enrollmentRequest : enrollments) {
                                if (!enrollmentRequest.getCourse().equals(xCourse)) continue;
                                String gm = enrollmentRequest.getGradeMode();
                                if (gm == null || gm.equals(registration.gradingMode)) continue block74;
                                helper.info("Changing grade mode for " + enrollmentRequest.getCourse().getCourseName() + " " + registration.courseReferenceNumber + " from " + registration.gradingMode + " to " + gm);
                                XEInterface.RegisterAction registerAction = new XEInterface.RegisterAction(registration.courseReferenceNumber);
                                registerAction.selectedGradingMode = gm;
                                registerRequest.actionsAndOptions.add(registerAction);
                                continue block74;
                            }
                        }
                        if (registerRequest.actionsAndOptions.isEmpty()) break block184;
                        helper.getAction().addOptionBuilder().setKey("gm_request").setValue(gson.toJson((Object)registerRequest));
                        long t2 = System.currentTimeMillis();
                        try {
                            resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(registerRequest));
                        }
                        catch (ResourceException resourceException) {
                            helper.getAction().setApiException(resourceException.getMessage());
                            try {
                                XEInterface.ErrorResponse responseGM = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                                helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)responseGM));
                                XEInterface.Error error = responseGM.getError();
                                if (error != null && error.message != null) {
                                    throw new SectioningException(this.fixErrorMessage(error.message));
                                }
                                if (error != null && error.description != null) {
                                    throw new SectioningException(this.fixErrorMessage(error.description));
                                }
                                if (error != null && error.errorMessage != null) {
                                    throw new SectioningException(this.fixErrorMessage(error.errorMessage));
                                }
                                throw resourceException;
                            }
                            catch (SectioningException e) {
                                helper.getAction().setApiException(e.getMessage());
                                throw e;
                            }
                            catch (Throwable t) {
                                throw resourceException;
                            }
                        }
                        finally {
                            helper.getAction().setApiPostTime(helper.getAction().getApiPostTime() + (System.currentTimeMillis() - t2));
                        }
                        XEInterface.RegisterResponse registerResponse = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("gm_response").setValue(gson.toJson((Object)registerResponse));
                        if (registerResponse == null || !registerResponse.validStudent.booleanValue()) {
                            Object reason = null;
                            if (registerResponse != null && registerResponse.failureReasons != null) {
                                for (String m : registerResponse.failureReasons) {
                                    if (reason == null) {
                                        reason = this.fixErrorMessage(m);
                                        continue;
                                    }
                                    reason = reason + "\n" + this.fixErrorMessage(m);
                                }
                            }
                            throw new SectioningException((String)(reason == null ? "Failed to change grade modes." : reason));
                        }
                        currentCredit = 0.0f;
                        if (registerResponse.registrations != null) {
                            for (XEInterface.Registration registration : registerResponse.registrations) {
                                if ("Registered".equals(registration.statusDescription)) {
                                    if (registration.gradingMode != null) {
                                        String desc = (String)code2desc.get(registration.gradingMode);
                                        gradeModes.addGradeMode(registration.courseReferenceNumber, new OnlineSectioningInterface.GradeMode(registration.gradingMode, desc != null ? desc : registration.gradingModeDescription, resetGradeModes != null && !resetGradeModes.isEmpty() && registration.gradingMode.matches(resetGradeModes)));
                                    }
                                    if (registration.creditHour != null) {
                                        gradeModes.addCreditHour(registration.courseReferenceNumber, registration.creditHour);
                                        currentCredit += registration.creditHour.floatValue();
                                    }
                                }
                                if (!"Withdrawn".equals(registration.statusDescription) || registration.creditHour == null) continue;
                                currentCredit += registration.creditHour.floatValue();
                            }
                        }
                        gradeModes.setCurrentCredit(Float.valueOf(currentCredit));
                    }
                    catch (Exception e) {
                        block78: for (XEInterface.RegisterAction registerAction : registerRequest.actionsAndOptions) {
                            XSection section2;
                            course = (XCourse)id2course.get(registerAction.courseReferenceNumber);
                            if (course == null) continue;
                            for (XSection section2 : (List)id2section.get(registerAction.courseReferenceNumber)) {
                                for (StudentEnrollmentProvider.EnrollmentFailure ef : fails) {
                                    if (!section2.equals(ef.getSection())) continue;
                                    ef.addError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_GRADE_MODE.name(), "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + e.getMessage());
                                    ef.setMessage(ef.getMessage() + "\nFailed to change grade mode for " + registerAction.courseReferenceNumber + ": " + e.getMessage());
                                    continue block78;
                                }
                            }
                            Iterator iterator = ((List)id2section.get(registerAction.courseReferenceNumber)).iterator();
                            if (!iterator.hasNext()) continue;
                            section2 = (XSection)iterator.next();
                            fails.add(new StudentEnrollmentProvider.EnrollmentFailure((XCourse)course, section2, "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + e.getMessage(), true, new StudentEnrollmentProvider.EnrollmentError(ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_GRADE_MODE.name(), "Failed to change grade mode for " + registerAction.courseReferenceNumber + ": " + e.getMessage())));
                        }
                    }
                }
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.gradeModeWarnings", "true"))) {
                block81: for (StudentEnrollmentProvider.EnrollmentRequest request : enrollments) {
                    if (!request.hasGradeMode()) continue;
                    String string = request.getGradeMode();
                    for (XSection section : request.getSections()) {
                        OnlineSectioningInterface.GradeMode gradeMode = gradeModes.getGradeMode(section.getExternalId(request.getCourse().getCourseId()));
                        if (gradeMode == null || string.equals(gradeMode.getCode())) continue;
                        fails.add(new StudentEnrollmentProvider.EnrollmentFailure(request.getCourse(), section, ApplicationProperties.getProperty("banner.xe.warn.gradeModeChanged", "Grade mode changed back to {label}.").replace("{course}", request.getCourse().getCourseName()).replace("{label}", gradeMode.getLabel()).replace("{code}", gradeMode.getCode()), true).setInfo());
                        continue block81;
                    }
                }
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.creditWarnings", "true"))) {
                for (StudentEnrollmentProvider.EnrollmentRequest request : enrollments) {
                    if (!request.hasCreditHour()) continue;
                    float f = request.getCreditHour().floatValue();
                    float f3 = 0.0f;
                    XSection creditSection = null;
                    Object var47_204 = null;
                    for (XSection xSection : request.getSections()) {
                        void var47_205;
                        String crn = xSection.getExternalId(request.getCourse().getCourseId());
                        if (crn == null || crn.equals(var47_205)) continue;
                        Float credit = gradeModes.getCreditHour(crn);
                        if (credit != null) {
                            f3 += credit.floatValue();
                            if (creditSection == null || credit.floatValue() > 0.0f) {
                                creditSection = xSection;
                            }
                        }
                        String string = crn;
                    }
                    if (!((double)Math.abs(f3 - f) > 0.01) || creditSection == null) continue;
                    fails.add(new StudentEnrollmentProvider.EnrollmentFailure(request.getCourse(), creditSection, ApplicationProperties.getProperty("banner.xe.warn.creditChanged", "Variable credit changed back to {credit} credit hour(s).").replace("{course}", request.getCourse().getCourseName()).replace("{credit}", Formats.getNumberFormat("0.#").format(Float.valueOf(f3))), true).setInfo());
                }
            }
            if (helper.isDebugEnabled()) {
                helper.debug("Return: " + String.valueOf(fails));
            }
            if (!fails.isEmpty()) {
                for (StudentEnrollmentProvider.EnrollmentFailure f : fails) {
                    helper.getAction().addMessageBuilder().setText(f.toString()).setLevel(OnlineSectioningLog.Message.Level.WARN);
                }
            }
            ArrayList<StudentEnrollmentProvider.EnrollmentFailure> arrayList = fails;
            return arrayList;
        }
        catch (JsonParseException e) {
            helper.warn("Failed to read Banner response: " + e.getMessage(), e);
            throw new SectioningException("Invalid response received from Banner, likely due to a timeout. Please try again. If the problem persists, please contact the admins.");
        }
        catch (SectioningException e) {
            helper.info("Banner enrollment failed: " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.warn("Banner enrollment failed: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isAllowWaitListing() {
        return this.isBannerAdmin() && this.isBannerWaitlist();
    }

    @Override
    public boolean requestUpdate(OnlineSectioningServer server, OnlineSectioningHelper helper, Collection<XStudent> students) throws SectioningException {
        return false;
    }

    protected boolean updateStudentRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XEInterface.Registration> registration) throws SectioningException {
        return false;
    }

    @Override
    public boolean isCanRequestUpdates() {
        return false;
    }

    @Override
    public XEnrollment resection(OnlineSectioningServer server, OnlineSectioningHelper helper, SectioningRequest sectioningRequest, XEnrollment enrollment) throws SectioningException {
        ClientResource resource = null;
        try {
            XEInterface.RegisterResponse original;
            XOffering dropOffering;
            XEnrollment dropEnrollment;
            XStudent student = sectioningRequest.getStudent();
            XCourseId course = sectioningRequest.getRequest().getCourseIdByOfferingId(sectioningRequest.getOffering().getOfferingId());
            TreeSet<String> idsToAdd = new TreeSet<String>();
            TreeSet<String> idsToDrop = new TreeSet<String>();
            if (sectioningRequest.getLastEnrollment() != null) {
                for (XSection section : sectioningRequest.getOldOffering().getSections(sectioningRequest.getLastEnrollment())) {
                    idsToDrop.add(section.getExternalId(course.getCourseId()));
                }
            }
            if (enrollment != null) {
                for (XSection section : sectioningRequest.getOffering().getSections(enrollment)) {
                    idsToAdd.add(section.getExternalId(course.getCourseId()));
                }
            }
            if ((dropEnrollment = sectioningRequest.getDropEnrollment()) != null && (dropOffering = server.getOffering(dropEnrollment.getOfferingId())) != null) {
                for (XSection section : dropOffering.getSections(dropEnrollment)) {
                    idsToDrop.add(section.getExternalId(dropEnrollment.getCourseId()));
                }
            }
            Iterator<XSection> i = idsToDrop.iterator();
            while (i.hasNext()) {
                if (!idsToAdd.remove(i.next())) continue;
                i.remove();
            }
            if (idsToAdd.isEmpty() && idsToDrop.isEmpty()) {
                i = enrollment;
                return i;
            }
            if (!idsToDrop.isEmpty()) {
                if (sectioningRequest.getLastEnrollment() != null) {
                    for (XSection xSection : sectioningRequest.getOldOffering().getSections(sectioningRequest.getLastEnrollment())) {
                        if (xSection.isEnabledForScheduling() || !idsToDrop.contains(xSection.getExternalId(course.getCourseId()))) continue;
                        SectioningException e = new SectioningException("Section " + xSection.getExternalId(course.getCourseId()) + " is not available for student scheduling.");
                        e.addError(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED, "Section cannot be dropped."));
                        throw e;
                    }
                }
                if (dropEnrollment != null && (dropOffering = server.getOffering(dropEnrollment.getOfferingId())) != null) {
                    for (XSection section : dropOffering.getSections(dropEnrollment)) {
                        if (section.isEnabledForScheduling() || !idsToDrop.contains(section.getExternalId(dropEnrollment.getCourseId()))) continue;
                        SectioningException e = new SectioningException("Section " + section.getExternalId(dropEnrollment.getCourseId()) + " is not available for student scheduling.");
                        e.addError(new ClassAssignmentInterface.ErrorMessage(dropEnrollment.getCourseName(), section.getExternalId(dropEnrollment.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED, "Section cannot be dropped."));
                        throw e;
                    }
                }
            }
            AcademicSessionInfo session = server.getAcademicSession();
            String string = this.getBannerTerm(session);
            resource = new ClientResource(this.getBannerSite());
            resource.setNext((Uniform)this.iClient);
            resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(helper), this.getBannerPassword(helper));
            resource.addQueryParameter("term", string);
            resource.addQueryParameter("bannerId", this.getBannerId(student));
            resource.addQueryParameter(this.getAdminParameter(), "SB");
            sectioningRequest.getAction().addOptionBuilder().setKey("term").setValue(string);
            sectioningRequest.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
            Gson gson = this.getGson(helper);
            long t0 = System.currentTimeMillis();
            try {
                resource.get(MediaType.APPLICATION_JSON);
            }
            catch (ResourceException exception) {
                sectioningRequest.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(this.fixErrorMessage(error.message));
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(this.fixErrorMessage(error.description));
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(this.fixErrorMessage(error.errorMessage));
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    sectioningRequest.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                sectioningRequest.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
            sectioningRequest.getAction().addOptionBuilder().setKey("original").setValue(gson.toJson((Object)current));
            XEInterface.RegisterResponse registerResponse = original = current != null && !current.isEmpty() ? (XEInterface.RegisterResponse)current.get(0) : null;
            if (original == null || !original.validStudent.booleanValue()) {
                Object reason = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (reason == null) {
                            reason = this.fixErrorMessage(m);
                            continue;
                        }
                        reason = (String)reason + "\n" + this.fixErrorMessage(m);
                    }
                }
                throw new SectioningException((String)(reason == null ? "Failed to check student registration status." : reason));
            }
            XEInterface.RegisterRequest req = new XEInterface.RegisterRequest(string, this.getBannerId(student), null, true);
            if (this.getConditionalAddDrop(true) != ConditionalDropType.NEVER) {
                req.setConditionalAddDrop(true);
            }
            boolean changed = false;
            HashMap<String, String> actions = new HashMap<String, String>();
            if (original.registrations != null) {
                for (XEInterface.Registration reg : original.registrations) {
                    if (reg.isRegistered()) {
                        if (idsToDrop.contains(reg.courseReferenceNumber)) {
                            if (!reg.canDrop(true, actions)) {
                                SectioningException e = new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                                e.addError(new ClassAssignmentInterface.ErrorMessage(reg.subject + " " + reg.courseNumber, reg.courseReferenceNumber, ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED, "Section cannot be dropped."));
                                throw e;
                            }
                            req.drop(reg.courseReferenceNumber, actions);
                            changed = true;
                            continue;
                        }
                        req.keep(reg.courseReferenceNumber);
                        continue;
                    }
                    if (!idsToAdd.remove(reg.courseReferenceNumber)) continue;
                    if (!reg.canAdd(true)) {
                        SectioningException e = new SectioningException("Section " + reg.courseReferenceNumber + " is not available for student scheduling.");
                        e.addError(new ClassAssignmentInterface.ErrorMessage(reg.subject + " " + reg.courseNumber, reg.courseReferenceNumber, ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DISABLED, "Section cannot be added."));
                        throw e;
                    }
                    req.add(reg.courseReferenceNumber, true);
                    changed = true;
                }
            }
            for (String id : idsToAdd) {
                req.add(id, false);
                changed = true;
            }
            sectioningRequest.getAction().addOptionBuilder().setKey("request").setValue(gson.toJson((Object)req));
            if (req.isEmpty() || !changed) {
                XEnrollment xEnrollment = enrollment;
                return xEnrollment;
            }
            long t1 = System.currentTimeMillis();
            try {
                resource.post(new GsonRepresentation<XEInterface.RegisterRequest>(req));
            }
            catch (ResourceException exception) {
                sectioningRequest.getAction().setApiException(exception.getMessage());
                try {
                    XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                    sectioningRequest.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                    XEInterface.Error error = response.getError();
                    if (error != null && error.message != null) {
                        throw new SectioningException(this.fixErrorMessage(error.message));
                    }
                    if (error != null && error.description != null) {
                        throw new SectioningException(this.fixErrorMessage(error.description));
                    }
                    if (error != null && error.errorMessage != null) {
                        throw new SectioningException(this.fixErrorMessage(error.errorMessage));
                    }
                    throw exception;
                }
                catch (SectioningException e) {
                    sectioningRequest.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Throwable t) {
                    throw exception;
                }
            }
            finally {
                sectioningRequest.getAction().setApiPostTime(System.currentTimeMillis() - t1);
            }
            XEInterface.RegisterResponse response = new GsonRepresentation<XEInterface.RegisterResponse>(resource.getResponseEntity(), XEInterface.RegisterResponse.class).getObject();
            sectioningRequest.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)response));
            if (response == null || !response.validStudent.booleanValue()) {
                Object reason = null;
                if (response != null && response.failureReasons != null) {
                    for (String m : response.failureReasons) {
                        if (reason == null) {
                            reason = this.fixErrorMessage(m);
                            continue;
                        }
                        reason = (String)reason + "\n" + this.fixErrorMessage(m);
                    }
                }
                throw new SectioningException((String)(reason == null ? "Failed to enroll student." : reason));
            }
            SectioningException exception = null;
            if (response.registrationException != null) {
                exception = new SectioningException(response.registrationException);
            }
            XEnrollment ret = new XEnrollment(enrollment == null ? sectioningRequest.getLastEnrollment() : enrollment);
            ret.getSectionIds().clear();
            TreeSet<String> registered = new TreeSet<String>();
            if (response.registrations != null) {
                OnlineSectioningLog.Enrollment.Builder external = OnlineSectioningLog.Enrollment.newBuilder();
                external.setType(OnlineSectioningLog.Enrollment.EnrollmentType.EXTERNAL);
                for (XEInterface.Registration reg : response.registrations) {
                    List<XSection> sections;
                    String id = reg.courseReferenceNumber;
                    if (reg.crnErrors != null) {
                        for (XEInterface.CrnError e : reg.crnErrors) {
                            sectioningRequest.getAction().addMessageBuilder().setText(reg.subject + " " + reg.courseNumber + " " + reg.courseReferenceNumber + ": " + e.message + " (" + e.messageType + ")").setLevel(OnlineSectioningLog.Message.Level.WARN);
                            if (exception == null) continue;
                            exception.addError(new ClassAssignmentInterface.ErrorMessage(reg.subject + " " + reg.courseNumber, reg.courseReferenceNumber, e.messageType, this.fixErrorMessage(e.message)));
                        }
                    }
                    if (!(sections = sectioningRequest.getOffering().getSections(course.getCourseId(), id)).isEmpty() && "Registered".equals(reg.statusDescription)) {
                        for (XSection section : sections) {
                            ret.getSectionIds().add(section.getSectionId());
                        }
                        registered.add(id);
                    }
                    if (!"Registered".equals(reg.statusDescription)) continue;
                    external.addSectionBuilder().setClazz(OnlineSectioningLog.Entity.newBuilder().setName(reg.courseReferenceNumber)).setCourse(OnlineSectioningLog.Entity.newBuilder().setName(reg.subject + " " + reg.courseNumber)).setSubpart(OnlineSectioningLog.Entity.newBuilder().setName(reg.scheduleType));
                }
                sectioningRequest.getAction().addEnrollment(external);
            }
            if (response.failedRegistrations != null) {
                for (XEInterface.FailedRegistration reg : response.failedRegistrations) {
                    if (reg.failedCRN != null) {
                        sectioningRequest.getAction().addMessageBuilder().setText(reg.failedCRN + ": " + reg.failure).setLevel(OnlineSectioningLog.Message.Level.WARN);
                    } else {
                        sectioningRequest.getAction().addMessageBuilder().setText(reg.failure).setLevel(OnlineSectioningLog.Message.Level.WARN);
                    }
                    if (exception == null && ret.getSectionIds().isEmpty()) {
                        exception = new SectioningException(this.fixErrorMessage(reg.failure));
                    }
                    if (exception == null) continue;
                    exception.addError(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), reg.failedCRN, "UNKNOWN", this.fixErrorMessage(reg.failure)));
                }
            }
            if (exception != null) {
                throw exception;
            }
            XEnrollment xEnrollment = ret.getSectionIds().isEmpty() ? null : ret;
            return xEnrollment;
        }
        catch (JsonParseException e) {
            sectioningRequest.getAction().addMessageBuilder().setText("Banner enrollment failed: " + e.getMessage()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            throw new SectioningException("Invalid response received from Banner, likely due to a timeout.");
        }
        catch (SectioningException e) {
            sectioningRequest.getAction().addMessageBuilder().setText("Banner enrollment failed: " + e.getMessage()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            throw e;
        }
        catch (Exception e) {
            sectioningRequest.getAction().addMessageBuilder().setText("Banner enrollment failed: " + e.getMessage()).setLevel(OnlineSectioningLog.Message.Level.WARN);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    public static enum ConditionalDropType {
        NEVER,
        HAS_DROP,
        IS_REGISTERED,
        RESECTION,
        ALWAYS;


        public static ConditionalDropType parseType(String value) {
            if (value == null) {
                return NEVER;
            }
            try {
                return ConditionalDropType.valueOf(value);
            }
            catch (Exception e) {
                return "true".equalsIgnoreCase(value) ? HAS_DROP : NEVER;
            }
        }
    }
}

