/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;

public class BannerTermProvider
implements ExternalTermProvider {
    private Integer iCourseNumberLength = null;

    @Override
    public String getExternalTerm(AcademicSessionInfo session) {
        if (session.getTerm().toLowerCase().startsWith("spr")) {
            return session.getYear() + "20";
        }
        if (session.getTerm().toLowerCase().startsWith("sum")) {
            return session.getYear() + "30";
        }
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return String.valueOf(Integer.parseInt(session.getYear()) + 1) + "10";
        }
        if (session.getTerm().toLowerCase().startsWith("win")) {
            return String.valueOf(Integer.parseInt(session.getYear()) + 1) + "13";
        }
        return session.getYear() + session.getTerm().toLowerCase();
    }

    @Override
    public String getExternalCampus(AcademicSessionInfo session) {
        return session.getCampus();
    }

    @Override
    public String getExternalSubject(AcademicSessionInfo session, String subjectArea, String courseNumber) {
        if (subjectArea != null && subjectArea.indexOf(" - ") >= 0) {
            return subjectArea.substring(subjectArea.indexOf(" - ") + 3);
        }
        return subjectArea;
    }

    @Override
    public String getExternalCourseNumber(AcademicSessionInfo session, String subjectArea, String courseNumber) {
        return courseNumber.length() > this.getCourseNumberLength() ? courseNumber.substring(0, this.getCourseNumberLength()) : courseNumber;
    }

    public int getCourseNumberLength() {
        if (this.iCourseNumberLength == null) {
            this.iCourseNumberLength = Integer.valueOf(ApplicationProperties.getProperty("tmtbl.banner.courseNumberLength", "5"));
        }
        return this.iCourseNumberLength;
    }

    @Override
    public String getExternalCourseCampus(AcademicSessionInfo session, String subjectArea, String courseNumber) {
        String campus = session.getCampus();
        if (subjectArea.indexOf(" - ") >= 0) {
            campus = subjectArea.substring(0, subjectArea.indexOf(" - "));
        }
        return ApplicationProperties.getProperty("tmtbl.banner.campus." + campus, campus);
    }
}

