/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;

public class Banner9CourseDetailsProvider
implements CourseDetailsProvider {
    private static final long serialVersionUID = 3824728965799479063L;
    private static Log sLog = LogFactory.getLog(Banner9CourseDetailsProvider.class);
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static CourseMessages CMSG = Localization.create(CourseMessages.class);
    private static GwtMessages GMSG = Localization.create(GwtMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public Banner9CourseDetailsProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getReadTimeout() {
        return ApplicationProperties.getProperty("banner.catalog.readTimeout", "60000");
    }

    protected String getApiKey() {
        return ApplicationProperties.getProperty("banner.catalog.apiKey");
    }

    protected String getCatalogUrl() {
        return ApplicationProperties.getProperty("banner.catalog.url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAccessToken() throws IOException, ResourceException {
        ClientResource resource = null;
        try {
            resource = new ClientResource("https://integrate.elluciancloud.com/auth");
            resource.setNext((Uniform)this.iClient);
            ChallengeResponse challenge = new ChallengeResponse(ChallengeScheme.HTTP_OAUTH_BEARER);
            challenge.setRawValue(this.getApiKey());
            resource.setChallengeResponse(challenge);
            String string = resource.post(null).getText();
            return string;
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadSection(String url) throws IOException {
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "utf-8"));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                if (!buffer.isEmpty()) {
                    buffer.append("\n");
                }
                buffer.append(line);
            }
            in.close();
            String string = buffer.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<?, ?> executeAPI(String api, String accessToken, Map<String, String> params) throws IOException, ResourceException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(api);
            resource.setNext((Uniform)this.iClient);
            ChallengeResponse challenge = new ChallengeResponse(ChallengeScheme.HTTP_OAUTH_BEARER);
            challenge.setRawValue(accessToken);
            resource.setChallengeResponse(challenge);
            resource.post(new GsonRepresentation<Map<String, String>>(params), MediaType.APPLICATION_JSON);
            List ret = (List)new GsonRepresentation(resource.getResponseEntity(), (Type)((Object)ArrayList.class)).getObject();
            if (ret == null || ret.isEmpty()) {
                HashMap hashMap = new HashMap();
                return hashMap;
            }
            Map map = (Map)ret.get(0);
            return map;
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    @Override
    public String getDetails(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        try {
            String accessToken = this.getAccessToken();
            final HashMap<String, String> params = new HashMap<String, String>();
            params.put("subject", this.iExternalTermProvider.getExternalSubject(session, subject, courseNbr));
            params.put("courseNumber", this.iExternalTermProvider.getExternalCourseNumber(session, subject, courseNbr));
            params.put("queryTerm", this.iExternalTermProvider.getExternalTerm(session));
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put("scacrseSubjCode", this.iExternalTermProvider.getExternalSubject(session, subject, courseNbr));
            params2.put("scacrseCrseNumb", this.iExternalTermProvider.getExternalCourseNumber(session, subject, courseNbr));
            params2.put("scacrseTermCodeEff", this.iExternalTermProvider.getExternalTerm(session));
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_34);
            cfg.setClassForTemplateLoading(Banner9CourseDetailsProvider.class, "");
            cfg.setLocale(Localization.getJavaLocale());
            cfg.setOutputEncoding("utf-8");
            Template template = cfg.getTemplate("course-details.ftl");
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("msg", MSG);
            input.put("const", CONST);
            input.put("cmsg", CMSG);
            input.put("gmsg", GMSG);
            input.put("session", session);
            Map<?, ?> base = this.executeAPI("https://integrate.elluciancloud.com/qapi/catalog-course-bases", accessToken, params);
            if (base == null || base.isEmpty()) {
                return MSG.catalogCourseNotInCatalog(subject, courseNbr);
            }
            input.put("base", base);
            input.put("details", this.executeAPI("https://integrate.elluciancloud.com/qapi/catalog-course-additional-details", accessToken, params));
            input.put("prerequisites", this.executeAPI("https://integrate.elluciancloud.com/qapi/catalog-course-requisites-and-equivalents", accessToken, params));
            input.put("restrictions", this.executeAPI("https://integrate.elluciancloud.com/qapi/catalog-course-restrictions", accessToken, params));
            input.put("descriptors", this.executeAPI("https://integrate.elluciancloud.com/qapi/catalog-course-descriptors", accessToken, params));
            input.put("fees", this.executeAPI("https://integrate.elluciancloud.com/qapi/course-detail-information-fee-codes", accessToken, params2));
            input.put("lookup", new Lookup(){

                @Override
                public String getPrereqsFromCatalog() {
                    try {
                        String base = Banner9CourseDetailsProvider.this.getCatalogUrl();
                        if (base == null || base.isEmpty()) {
                            return "";
                        }
                        String p = "term=" + URLEncoder.encode((String)params.get("queryTerm"), "utf-8") + "&subjectCode=" + URLEncoder.encode((String)params.get("subject"), "utf-8") + "&courseNumber=" + URLEncoder.encode((String)params.get("courseNumber"), "utf-8");
                        return Banner9CourseDetailsProvider.this.downloadSection(base + "/getPrerequisites?" + p);
                    }
                    catch (Exception e) {
                        sLog.info((Object)("Failed to load catalog section: " + e.getMessage()), (Throwable)e);
                        return "Failed to load prerequisites: " + e.getMessage();
                    }
                }
            });
            String disclaimer = ApplicationProperties.getProperty("banner.catalog.disclaimer", null);
            if (disclaimer != null) {
                input.put("disclaimer", disclaimer);
            }
            StringWriter s = new StringWriter();
            template.process(input, (Writer)new PrintWriter(s));
            s.flush();
            s.close();
            return s.toString();
        }
        catch (SectioningException e) {
            sLog.info((Object)e.getMessage(), (Throwable)e);
            return MSG.exceptionCustomCourseDetailsFailed(e.getMessage());
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return MSG.exceptionCustomCourseDetailsFailed(e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            Banner9CourseDetailsProvider p = new Banner9CourseDetailsProvider();
            System.out.println(p.getDetails(new AcademicSessionInfo(-1L, "2026", "Spring", "PWL"), "ECON", "39000"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Lookup {
        public String getPrereqsFromCatalog();
    }
}

