/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

public class CustomWaitListValidationHolder {
    protected static Log sLog = LogFactory.getLog(CustomWaitListValidationHolder.class);
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public static WaitListValidationProvider getProvider() {
        return (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
    }

    public static void release() {
        Customization.WaitListValidationProvider.release();
    }

    public static boolean hasProvider() {
        return Customization.WaitListValidationProvider.hasProvider();
    }

    protected static abstract class Worker
    extends Thread {
        private Iterator<Long> iStudentsIds;
        private Long iSessionId;

        public Worker(int index, Long sessionId, Iterator<Long> studentsIds) {
            this.setName("Validator-" + (1 + index));
            this.iSessionId = sessionId;
            this.iStudentsIds = studentsIds;
        }

        protected abstract void process(Long var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ApplicationProperties.setSessionId(this.iSessionId);
                while (true) {
                    Long studentId = null;
                    Iterator<Long> iterator = this.iStudentsIds;
                    synchronized (iterator) {
                        if (!this.iStudentsIds.hasNext()) {
                            break;
                        }
                        studentId = this.iStudentsIds.next();
                    }
                    try {
                        this.process(studentId);
                    }
                    catch (Exception e) {
                        sLog.warn((Object)("Failed to process student " + studentId + ": " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            finally {
                ApplicationProperties.setSessionId(null);
                HibernateUtil.closeCurrentThreadSessions();
            }
        }
    }

    public static class Validate
    implements OnlineSectioningAction<Boolean> {
        private static final long serialVersionUID = 1L;
        private Collection<Long> iStudentIds = null;

        public Validate forStudents(Long ... studentIds) {
            this.iStudentIds = new ArrayList<Long>();
            for (Long studentId : studentIds) {
                this.iStudentIds.add(studentId);
            }
            return this;
        }

        public Validate forStudents(Collection<Long> studentIds) {
            this.iStudentIds = studentIds;
            return this;
        }

        public Collection<Long> getStudentIds() {
            return this.iStudentIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean execute(final OnlineSectioningServer server, final OnlineSectioningHelper helper) {
            if (!CustomWaitListValidationHolder.hasProvider()) {
                return false;
            }
            final ArrayList<Long> reloadIds = new ArrayList<Long>();
            try {
                int nrThreads = server.getConfig().getPropertyInt("CourseRequestsValidation.NrThreads", 10);
                if (nrThreads <= 1 || this.getStudentIds().size() <= 1) {
                    for (Long studentId : this.getStudentIds()) {
                        if (!this.revalidateStudent(server, helper, studentId)) continue;
                        reloadIds.add(studentId);
                    }
                } else {
                    ArrayList<1> workers = new ArrayList<1>();
                    Iterator<Long> studentIds = this.getStudentIds().iterator();
                    for (int i = 0; i < nrThreads; ++i) {
                        workers.add(new Worker(i, server.getAcademicSession().getUniqueId(), studentIds){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void process(Long studentId) {
                                if (this.revalidateStudent(server, new OnlineSectioningHelper(helper), studentId)) {
                                    List list = reloadIds;
                                    synchronized (list) {
                                        reloadIds.add(studentId);
                                    }
                                }
                            }
                        });
                    }
                    for (Worker worker : workers) {
                        worker.start();
                    }
                    for (Worker worker : workers) {
                        try {
                            worker.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            finally {
                if (!reloadIds.isEmpty() && !(server instanceof DatabaseServer)) {
                    server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
                }
            }
            return !reloadIds.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Long studentId) {
            helper.beginTransaction();
            try {
                Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                boolean changed = false;
                if (student != null) {
                    OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(studentId).setExternalId(student.getExternalUniqueId()).setName(helper.getStudentNameFormat().format(student)).setType(OnlineSectioningLog.Entity.EntityType.STUDENT));
                    long c0 = OnlineSectioningHelper.getCpuTime();
                    try {
                        if (CustomWaitListValidationHolder.getProvider().revalidateStudent(server, helper, student, action)) {
                            changed = true;
                            action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
                        } else {
                            action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                        }
                    }
                    catch (SectioningException e) {
                        action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        if (e.getCause() != null) {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                        } else {
                            action.addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                        }
                    }
                    finally {
                        action.setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        action.setEndTime(System.currentTimeMillis());
                    }
                }
                helper.commitTransaction();
                return changed;
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    throw (SectioningException)e;
                }
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }

        @Override
        public String name() {
            return "wait-revalidate";
        }
    }

    public static class Update
    implements OnlineSectioningAction<Boolean> {
        private static final long serialVersionUID = 1L;
        private Collection<Long> iStudentIds = null;

        public Update forStudents(Long ... studentIds) {
            this.iStudentIds = new ArrayList<Long>();
            for (Long studentId : studentIds) {
                this.iStudentIds.add(studentId);
            }
            return this;
        }

        public Update forStudents(Collection<Long> studentIds) {
            this.iStudentIds = studentIds;
            return this;
        }

        public Collection<Long> getStudentIds() {
            return this.iStudentIds;
        }

        @Override
        public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
            if (!CustomWaitListValidationHolder.hasProvider()) {
                return false;
            }
            ArrayList<Student> students = new ArrayList<Student>();
            for (Long studentId : this.getStudentIds()) {
                Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                if (student == null) continue;
                students.add(student);
            }
            Collection<Long> updatedStudentIds = null;
            if (!students.isEmpty()) {
                updatedStudentIds = CustomWaitListValidationHolder.getProvider().updateStudents(server, helper, students);
            }
            return updatedStudentIds != null && !updatedStudentIds.isEmpty();
        }

        @Override
        public String name() {
            return "wait-update";
        }
    }

    public static class Check
    implements OnlineSectioningAction<CourseRequestInterface> {
        private static final long serialVersionUID = 1L;
        private CourseRequestInterface iRequest;

        public Check withRequest(CourseRequestInterface request) {
            this.iRequest = request;
            return this;
        }

        public CourseRequestInterface getRequest() {
            return this.iRequest;
        }

        @Override
        public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
            CourseRequestInterface request = this.getRequest();
            if (CustomWaitListValidationHolder.hasProvider()) {
                CustomWaitListValidationHolder.getProvider().check(server, helper, request);
            }
            return request;
        }

        @Override
        public String name() {
            return "wait-check";
        }
    }
}

