/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.StudentSchedulingPreferencesInterface;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class GetStudentPreferences
implements OnlineSectioningAction<StudentSchedulingPreferencesInterface> {
    private static final long serialVersionUID = 1L;
    private Long iStudentId = null;

    public GetStudentPreferences forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    @Override
    public StudentSchedulingPreferencesInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        StudentSchedulingPreferencesInterface ret = new StudentSchedulingPreferencesInterface();
        ApplicationProperties.setSessionId(server.getAcademicSession().getUniqueId());
        ret.setAllowClassDates(ApplicationProperty.OnlineSchedulingStudentPreferencesDatesAllowed.isTrue());
        ret.setAllowRequireOnline(ApplicationProperty.OnlineSchedulingStudentPreferencesReqOnlineAllowed.isTrue());
        ret.setCustomNote(ApplicationProperty.OnlineSchedulingStudentPreferencesNote.value());
        XStudent student = server.getStudent(this.iStudentId);
        if (student != null) {
            ret.setClassModality(student.getPreferredClassModality());
            ret.setScheduleGaps(student.getPreferredScheduleGaps());
            ret.setClassDateFrom(student.getClassStartDate(server.getAcademicSession().getDatePatternFirstDate()));
            ret.setClassDateTo(student.getClassEndDate(server.getAcademicSession().getDatePatternFirstDate()));
        }
        return ret;
    }

    @Override
    public String name() {
        return "get-schedule-prefs";
    }
}

