/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumOverride;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.match.AnyStudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCurriculumReservation;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XGroupReservation;
import org.unitime.timetable.onlinesectioning.model.XIndividualReservation;
import org.unitime.timetable.onlinesectioning.model.XLearningCommunityReservation;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XUniversalReservation;
import org.unitime.timetable.server.sectioning.SectioningReportTypesBackend;

public class GenerateSectioningReport
implements OnlineSectioningAction<CSVFile> {
    private static final long serialVersionUID = 1L;
    private DataProperties iParameters = null;

    public GenerateSectioningReport withParameters(Properties parameters) {
        this.iParameters = parameters instanceof DataProperties ? (DataProperties)parameters : new DataProperties(parameters);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public CSVFile execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            String reference;
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            DistanceMetric dm = server.getDistanceMetric();
            model.setDistanceConflict(new DistanceConflict(dm, model.getProperties()));
            model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
            model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            AssignmentMap assignment = new AssignmentMap();
            HashMap<Long, Offering> offerings = new HashMap<Long, Offering>();
            Hashtable<Long, Course> courses = new Hashtable<Long, Course>();
            HashMap groups = new HashMap();
            Hashtable<Long, Config> configs = new Hashtable<Long, Config>();
            Hashtable<Long, Subpart> subparts = new Hashtable<Long, Subpart>();
            Hashtable<Long, Section> sections = new Hashtable<Long, Section>();
            Hashtable<Long, DummyReservation> reservations = new Hashtable<Long, DummyReservation>();
            HashSet<XDistribution> linkedSections = new HashSet<XDistribution>();
            AcademicSessionInfo session = server.getAcademicSession();
            HashSet<String> wlStates = new HashSet<String>();
            HashSet<String> noSubStates = new HashSet<String>();
            Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
            for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
                if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                    wlStates.add(status.getReference());
                    continue;
                }
                if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
                noSubStates.add(status.getReference());
            }
            boolean checkUnavailabilitiesFromOtherSessions = server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsForReporting", false);
            OnlineSectioningServer.Lock lock = server.readLock();
            try {
                HashMap<Long, Long> parentCourses = new HashMap<Long, Long>();
                for (XCourseId xCourseId : server.findCourses(new AnyCourseMatcher())) {
                    XOffering xOffering = server.getOffering(xCourseId.getOfferingId());
                    if (xOffering == null || offerings.containsKey(xOffering.getOfferingId())) continue;
                    Offering clonedOffering = new Offering(xOffering.getOfferingId().longValue(), xOffering.getName());
                    clonedOffering.setModel((Model)model);
                    for (XCourse course : xOffering.getCourses()) {
                        Course clonedCourse = new Course(course.getCourseId().longValue(), course.getSubjectArea(), course.getCourseNumber(), clonedOffering, course.getLimit(), course.getProjected());
                        clonedCourse.setNote(course.getNote());
                        clonedCourse.setType(course.getType());
                        clonedCourse.setTitle(course.getTitle());
                        clonedCourse.setCredit(course.getCredit());
                        courses.put(course.getCourseId(), clonedCourse);
                        if (course.getParentCourseId() == null) continue;
                        parentCourses.put(course.getCourseId(), course.getParentCourseId());
                    }
                    for (XConfig config : xOffering.getConfigs()) {
                        Config clonedConfig = new Config(config.getConfigId().longValue(), config.getLimit(), config.getName(), clonedOffering);
                        if (config.getInstructionalMethod() != null) {
                            clonedConfig.setInstructionalMethodId(config.getInstructionalMethod().getUniqueId());
                            clonedConfig.setInstructionalMethodName(config.getInstructionalMethod().getLabel());
                            clonedConfig.setInstructionalMethodReference(config.getInstructionalMethod().getReference());
                        }
                        configs.put(config.getConfigId(), clonedConfig);
                        for (XSubpart subpart : config.getSubparts()) {
                            Subpart clonedSubpart = new Subpart(subpart.getSubpartId().longValue(), subpart.getInstructionalType(), subpart.getName(), clonedConfig, subpart.getParentId() == null ? null : (Subpart)subparts.get(subpart.getParentId()));
                            clonedSubpart.setAllowOverlap(subpart.isAllowOverlap());
                            clonedSubpart.setCredit(subpart.getCredit(null));
                            subparts.put(subpart.getSubpartId(), clonedSubpart);
                            for (XSection section : subpart.getSections()) {
                                Section clonedSection = new Section(section.getSectionId().longValue(), section.getLimit(), section.getName(), clonedSubpart, section.toPlacement(), section.toInstructors(), section.getParentId() == null ? null : (Section)sections.get(section.getParentId()));
                                clonedSection.setName(-1L, section.getName(-1L));
                                clonedSection.setNote(section.getNote());
                                clonedSection.setCancelled(section.isCancelled());
                                clonedSection.setEnabled(section.isEnabledForScheduling());
                                clonedSection.setOnline(section.isOnline());
                                clonedSection.setPast(section.isPast());
                                for (XDistribution distribution : xOffering.getDistributions()) {
                                    if (distribution.getDistributionType() == XDistributionType.IngoreConflicts && distribution.hasSection(section.getSectionId())) {
                                        for (Long id : distribution.getSectionIds()) {
                                            if (id.equals(section.getSectionId())) continue;
                                            clonedSection.addIgnoreConflictWith(id.longValue());
                                        }
                                        continue;
                                    }
                                    if (distribution.getDistributionType() != XDistributionType.LinkedSections) continue;
                                    linkedSections.add(distribution);
                                }
                                sections.put(section.getSectionId(), clonedSection);
                            }
                        }
                    }
                    for (XReservation reservation : xOffering.getReservations()) {
                        Object clonedReservation = null;
                        switch (reservation.getType()) {
                            case Course: {
                                Iterator<Object> courseR = (XCourseReservation)reservation;
                                clonedReservation = new CourseReservation(reservation.getReservationId().longValue(), (Course)courses.get(((XCourseReservation)((Object)courseR)).getCourseId()));
                                break;
                            }
                            case Curriculum: {
                                XCurriculumReservation curriculumR = (XCurriculumReservation)reservation;
                                clonedReservation = new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, curriculumR.getAcademicAreas(), curriculumR.getClassifications(), curriculumR.getMajors(), curriculumR.getMinors());
                                for (String major : curriculumR.getMajors()) {
                                    Set<String> concs = curriculumR.getConcentrations(major);
                                    if (concs == null) continue;
                                    for (String conc : concs) {
                                        ((CurriculumReservation)clonedReservation).addConcentration(major, conc);
                                    }
                                }
                                break;
                            }
                            case Group: {
                                XIndividualReservation indR;
                                if (reservation instanceof XIndividualReservation) {
                                    indR = (XIndividualReservation)reservation;
                                    clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, indR.getStudentIds());
                                    break;
                                }
                                XGroupReservation groupR = (XGroupReservation)reservation;
                                clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, new Long[0]);
                                ArrayList<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                                if (list == null) {
                                    list = new ArrayList<GroupReservation>();
                                    groups.put(groupR.getGroup(), list);
                                }
                                list.add((GroupReservation)clonedReservation);
                                break;
                            }
                            case Individual: {
                                XIndividualReservation indR = (XIndividualReservation)reservation;
                                clonedReservation = new IndividualReservation(reservation.getReservationId().longValue(), clonedOffering, indR.getStudentIds());
                                break;
                            }
                            case IndividualOverride: {
                                Iterator ovrR = (XIndividualReservation)reservation;
                                clonedReservation = ((XIndividualReservation)((Object)ovrR)).isOverride() ? new ReservationOverride(reservation.getReservationId().longValue(), clonedOffering, ((XIndividualReservation)((Object)ovrR)).getStudentIds()) : new IndividualReservation(reservation.getReservationId().longValue(), clonedOffering, ((XIndividualReservation)((Object)ovrR)).getStudentIds());
                                clonedReservation.setMustBeUsed(((XReservation)((Object)ovrR)).mustBeUsed());
                                clonedReservation.setAllowOverlap(((XReservation)((Object)ovrR)).isAllowOverlap());
                                clonedReservation.setCanAssignOverLimit(((XReservation)((Object)ovrR)).canAssignOverLimit());
                                break;
                            }
                            case GroupOverride: {
                                XGroupReservation groupR = (XGroupReservation)reservation;
                                clonedReservation = new GroupReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, new Long[0]);
                                List<GroupReservation> list = (ArrayList<GroupReservation>)groups.get(groupR.getGroup());
                                if (list == null) {
                                    list = new ArrayList<GroupReservation>();
                                    groups.put(groupR.getGroup(), list);
                                }
                                list.add((GroupReservation)clonedReservation);
                                ((GroupReservation)clonedReservation).setMustBeUsed(groupR.mustBeUsed());
                                ((GroupReservation)clonedReservation).setAllowOverlap(groupR.isAllowOverlap());
                                ((GroupReservation)clonedReservation).setCanAssignOverLimit(groupR.canAssignOverLimit());
                                break;
                            }
                            case LearningCommunity: {
                                XLearningCommunityReservation lcR = (XLearningCommunityReservation)reservation;
                                clonedReservation = new LearningCommunityReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), (Course)courses.get(lcR.getCourseId()), lcR.getStudentIds());
                                if (lcR.getGroup() == null) break;
                                List<GroupReservation> list = (List)groups.get(lcR.getGroup());
                                if (list == null) {
                                    list = new ArrayList();
                                    groups.put(lcR.getGroup(), list);
                                }
                                list.add((GroupReservation)clonedReservation);
                                break;
                            }
                            case CurriculumOverride: {
                                XCurriculumReservation curR = (XCurriculumReservation)reservation;
                                clonedReservation = curR.isOverride() ? new CurriculumOverride(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, curR.getAcademicAreas(), curR.getClassifications(), curR.getMajors(), curR.getMinors()) : new CurriculumReservation(reservation.getReservationId().longValue(), (double)reservation.getLimit(), clonedOffering, curR.getAcademicAreas(), curR.getClassifications(), curR.getMajors(), curR.getMinors());
                                ((CurriculumReservation)clonedReservation).setMustBeUsed(curR.mustBeUsed());
                                ((CurriculumReservation)clonedReservation).setAllowOverlap(curR.isAllowOverlap());
                                ((CurriculumReservation)clonedReservation).setCanAssignOverLimit(curR.canAssignOverLimit());
                                for (String major : curR.getMajors()) {
                                    Set<String> concs = curR.getConcentrations(major);
                                    if (concs == null) continue;
                                    for (String conc : concs) {
                                        ((CurriculumReservation)clonedReservation).addConcentration(major, conc);
                                    }
                                }
                                break;
                            }
                            case Universal: {
                                XUniversalReservation uniR = (XUniversalReservation)reservation;
                                clonedReservation = new UniversalOverride(reservation.getReservationId().longValue(), reservation.isOverride(), (double)reservation.getLimit(), clonedOffering, uniR.getFilter());
                                ((UniversalOverride)clonedReservation).setMustBeUsed(uniR.mustBeUsed());
                                ((UniversalOverride)clonedReservation).setAllowOverlap(uniR.isAllowOverlap());
                                ((UniversalOverride)clonedReservation).setCanAssignOverLimit(uniR.canAssignOverLimit());
                                break;
                            }
                            default: {
                                clonedReservation = new DummyReservation(clonedOffering);
                            }
                        }
                        for (Long configId : reservation.getConfigsIds()) {
                            clonedReservation.addConfig((Config)configs.get(configId));
                        }
                        for (Map.Entry<Long, Set<Long>> entry : reservation.getSections().entrySet()) {
                            HashSet<Section> clonedSections = new HashSet<Section>();
                            for (Long sectionId : entry.getValue()) {
                                clonedSections.add((Section)sections.get(sectionId));
                            }
                            clonedReservation.getSections().put((Subpart)subparts.get(entry.getKey()), clonedSections);
                        }
                        reservations.put(reservation.getReservationId(), (DummyReservation)clonedReservation);
                    }
                    offerings.put(xOffering.getOfferingId(), clonedOffering);
                    model.addOffering(clonedOffering);
                }
                for (Map.Entry entry : parentCourses.entrySet()) {
                    Course course = (Course)courses.get(entry.getKey());
                    Course parent = (Course)courses.get(entry.getValue());
                    if (course == null || parent == null) continue;
                    course.setParent(parent);
                }
                HashMap<Long, Student> students = new HashMap<Long, Student>();
                for (XStudentId xStudentId : server.findStudents(new AnyStudentMatcher())) {
                    Collection<Long> offeringIds;
                    XStudent student;
                    XStudent xStudent = student = xStudentId instanceof XStudent ? (XStudent)xStudentId : server.getStudent(xStudentId.getStudentId());
                    if (student == null) {
                        Iterator<Comparable<XCourseId>> iterator = null;
                        return iterator;
                    }
                    String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                    OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                    if (status == null || wlStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.WaitList;
                    } else if (noSubStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                    }
                    Student clonnedStudent = new Student(student.getStudentId().longValue());
                    clonnedStudent.setExternalId(student.getExternalId());
                    clonnedStudent.setName(student.getName());
                    clonnedStudent.setNeedShortDistances(student.hasAccomodation(dm.getShortDistanceAccommodationReference()));
                    clonnedStudent.setAllowDisabled(student.isAllowDisabled());
                    clonnedStudent.setClassFirstDate(student.getClassStartDate());
                    clonnedStudent.setClassLastDate(student.getClassEndDate());
                    clonnedStudent.setBackToBackPreference(student.getBackToBackPreference());
                    clonnedStudent.setModalityPreference(student.getModalityPreference());
                    for (XStudent.XGroup g : student.getGroups()) {
                        clonnedStudent.getGroups().add(new StudentGroup(g.getType(), g.getAbbreviation(), g.getTitle()));
                        List list = (List)groups.get(g);
                        if (list == null) continue;
                        for (Object gr : list) {
                            gr.getStudentIds().add(student.getStudentId());
                        }
                    }
                    for (XAreaClassificationMajor acm : student.getMajors()) {
                        clonnedStudent.getAreaClassificationMajors().add(new AreaClassificationMajor(acm.getArea(), acm.getAreaLabel(), acm.getClassification(), acm.getClassificationLabel(), acm.getMajor(), acm.getMajorLabel(), acm.getConcentration(), acm.getConcentrationLabel(), acm.getDegree(), acm.getDegreeLabel(), acm.getProgram(), acm.getProgramLabel(), Double.valueOf(acm.getWeight())));
                    }
                    for (XAreaClassificationMajor acm : student.getMinors()) {
                        clonnedStudent.getAreaClassificationMinors().add(new AreaClassificationMajor(acm.getArea(), acm.getAreaLabel(), acm.getClassification(), acm.getClassificationLabel(), acm.getMajor(), acm.getMajorLabel(), acm.getConcentration(), acm.getConcentrationLabel(), acm.getDegree(), acm.getDegreeLabel(), acm.getProgram(), acm.getProgramLabel(), Double.valueOf(acm.getWeight())));
                    }
                    for (XStudent.XGroup acc : student.getAccomodations()) {
                        clonnedStudent.getAccommodations().add(acc.getAbbreviation());
                    }
                    for (XRequest r : student.getRequests()) {
                        Reservation reservation;
                        Object gr;
                        if (r instanceof XFreeTimeRequest) {
                            XFreeTimeRequest ft = (XFreeTimeRequest)r;
                            new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                            continue;
                        }
                        XCourseRequest cr = (XCourseRequest)r;
                        ArrayList<Course> req = new ArrayList<Course>();
                        gr = cr.getCourseIds().iterator();
                        while (gr.hasNext()) {
                            XCourseId c = (XCourseId)gr.next();
                            Course course = (Course)courses.get(c.getCourseId());
                            if (course == null) continue;
                            req.add(course);
                        }
                        if (req.isEmpty()) continue;
                        CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), clonnedStudent, req, cr.isWaitListOrNoSub(wl), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                        if (cr.isCritical()) {
                            if (cr.getCritical() == CourseDemand.Critical.CRITICAL.ordinal()) {
                                clonnedRequest.setRequestPriority(Request.RequestPriority.Critical);
                            } else if (cr.getCritical() == CourseDemand.Critical.IMPORTANT.ordinal()) {
                                clonnedRequest.setRequestPriority(Request.RequestPriority.Important);
                            } else if (cr.getCritical() == CourseDemand.Critical.VITAL.ordinal()) {
                                clonnedRequest.setRequestPriority(Request.RequestPriority.Vital);
                            } else if (cr.getCritical() == CourseDemand.Critical.LC.ordinal()) {
                                clonnedRequest.setRequestPriority(Request.RequestPriority.LC);
                            } else if (cr.getCritical() == CourseDemand.Critical.VISITING_F2F.ordinal()) {
                                clonnedRequest.setRequestPriority(Request.RequestPriority.VisitingF2F);
                            }
                        }
                        cr.fillChoicesIn(clonnedRequest);
                        XEnrollment enrollment = cr.getEnrollment();
                        if (enrollment == null) continue;
                        Config config = (Config)configs.get(enrollment.getConfigId());
                        HashSet<Section> assignments = new HashSet<Section>();
                        for (Long sectionId : enrollment.getSectionIds()) {
                            Section section = (Section)sections.get(sectionId);
                            if (section == null) continue;
                            assignments.add(section);
                        }
                        Reservation reservation2 = reservation = enrollment.getReservation() == null ? null : (Reservation)reservations.get(enrollment.getReservation().getReservationId());
                        if (config == null || sections.isEmpty()) continue;
                        Course course = (Course)courses.get(enrollment.getCourseId());
                        assignment.assign(0L, (Value)new Enrollment((Request)clonnedRequest, clonnedRequest.getCourses().indexOf(course), course, config, assignments, reservation));
                    }
                    for (XStudent.XAdvisor advisor : student.getAdvisors()) {
                        clonnedStudent.getAdvisors().add(new Instructor(0L, advisor.getExternalId(), advisor.getName(), advisor.getEmail()));
                    }
                    students.put(student.getStudentId(), clonnedStudent);
                    model.addStudent(clonnedStudent);
                    if (clonnedStudent.getExternalId() == null || clonnedStudent.getExternalId().isEmpty() || (offeringIds = server.getInstructedOfferings(clonnedStudent.getExternalId())) == null) continue;
                    for (Long offeringId : offeringIds) {
                        XOffering offering = server.getOffering(offeringId);
                        if (offering == null) continue;
                        offering.fillInUnavailabilities(clonnedStudent);
                    }
                }
                if (checkUnavailabilitiesFromOtherSessions) {
                    GetInfo.fillInAllUnavailabilitiesFromOtherSessionsUsingDatabase(students, server, helper);
                }
                for (XDistribution xDistribution : linkedSections) {
                    ArrayList<Section> linked = new ArrayList<Section>();
                    for (Long id : xDistribution.getSectionIds()) {
                        Section section = (Section)sections.get(id);
                        if (section == null) continue;
                        linked.add(section);
                    }
                    if (linked.size() <= 1) continue;
                    model.addLinkedSections(linkedClassesMustBeUsed, linked);
                }
            }
            finally {
                lock.release();
            }
            String name = this.iParameters.getProperty("report", null);
            if (name == null && (reference = this.iParameters.getProperty("name")) != null) {
                name = SectioningReportTypesBackend.ReportType.valueOf(reference).getImplementation();
            }
            if (name == null || name.isEmpty()) {
                return null;
            }
            Class<?> clazz = Class.forName(name);
            StudentSectioningReport studentSectioningReport = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(model);
            return studentSectioningReport.create((Assignment)assignment, this.iParameters);
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "report";
    }
}

