/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;

public class ClassCourseComparator
implements Comparator {
    static CourseMessages MSG = Localization.create(CourseMessages.class);
    SortBy iSortyBy;
    ClassAssignmentProxy iClassAssignmentProxy;
    boolean iKeepSubpart;

    public static String getName(SortBy sortBy) {
        switch (sortBy) {
            case NAME: {
                return MSG.sortByName();
            }
            case DIV_SEC: {
                return MSG.sortByDivSec();
            }
            case ENROLLMENT: {
                return MSG.sortByEnrollment();
            }
            case LIMIT: {
                return MSG.sortByLimit();
            }
            case ROOM_SIZE: {
                return MSG.sortByRoomSize();
            }
            case DATE_PATTERN: {
                return MSG.sortByDatePattern();
            }
            case TIME_PATTERN: {
                return MSG.sortByTimePattern();
            }
            case INSTRUCTOR: {
                return MSG.sortByInstructor();
            }
            case ASSIGNED_TIME: {
                return MSG.sortByAssignedTime();
            }
            case ASSIGNED_ROOM: {
                return MSG.sortByAssignedRoom();
            }
            case ASSIGNED_ROOM_CAP: {
                return MSG.sortByAssignedRoomCapacity();
            }
        }
        return MSG.sortByName();
    }

    public static SortBy getSortBy(String name) {
        for (SortBy s : SortBy.values()) {
            if (!ClassCourseComparator.getName(s).equals(name)) continue;
            return s;
        }
        return SortBy.NAME;
    }

    public static String[] getNames() {
        String[] names = new String[SortBy.values().length];
        for (int i = 0; i < SortBy.values().length; ++i) {
            names[i] = ClassCourseComparator.getName(SortBy.values()[i]);
        }
        return names;
    }

    public ClassCourseComparator(String sortBy, ClassAssignmentProxy classAssignmentProxy, boolean keepSubparts) {
        this.iSortyBy = ClassCourseComparator.getSortBy(sortBy);
        this.iClassAssignmentProxy = classAssignmentProxy;
        this.iKeepSubpart = keepSubparts;
    }

    public ClassCourseComparator(SortBy sort) {
        this.iSortyBy = sort;
        this.iClassAssignmentProxy = new CommitedClassAssignmentProxy();
        this.iKeepSubpart = true;
    }

    public ClassCourseComparator() {
        this(SortBy.NAME);
    }

    public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
        SchedulingSubpart p1 = s1.getParentSubpart();
        if (p1 == null) {
            return false;
        }
        if (p1.equals(s2)) {
            return true;
        }
        return this.isParent(p1, s2);
    }

    public int compareSubparts(SchedulingSubpart s1, SchedulingSubpart s2) {
        int cmp;
        if (this.isParent(s1, s2)) {
            return 1;
        }
        if (this.isParent(s2, s1)) {
            return -1;
        }
        if (s1.getParentSubpart() != null || s2.getParentSubpart() != null) {
            SchedulingSubpart p1 = s1;
            int d1 = 0;
            while (p1.getParentSubpart() != null) {
                p1 = p1.getParentSubpart();
                ++d1;
            }
            SchedulingSubpart p2 = s2;
            int d2 = 0;
            while (p2.getParentSubpart() != null) {
                p2 = p2.getParentSubpart();
                ++d2;
            }
            if (d1 < d2) {
                int cmp2 = this.compareSubparts(s1, s2.getParentSubpart());
                if (cmp2 != 0) {
                    return cmp2;
                }
            } else if (d1 > d2) {
                int cmp3 = this.compareSubparts(s1.getParentSubpart(), s2);
                if (cmp3 != 0) {
                    return cmp3;
                }
            } else {
                int cmp4 = this.compareSubparts(s1.getParentSubpart(), s2.getParentSubpart());
                if (cmp4 != 0) {
                    return cmp4;
                }
            }
        }
        if ((cmp = s1.getItype().getItype().compareTo(s2.getItype().getItype())) != 0) {
            return cmp;
        }
        if (!s1.getInstrOfferingConfig().equals(s2.getInstrOfferingConfig())) {
            return new InstrOfferingConfigComparator(null).compare(s1.getInstrOfferingConfig(), s2.getInstrOfferingConfig());
        }
        return s1.getUniqueId().compareTo(s2.getUniqueId());
    }

    public boolean isParentSameIType(SchedulingSubpart s1, SchedulingSubpart s2) {
        SchedulingSubpart p1 = s1.getParentSubpart();
        if (p1 == null) {
            return false;
        }
        if (p1.equals(s2)) {
            return true;
        }
        if (!p1.getItype().equals(s2.getItype())) {
            return false;
        }
        return this.isParentSameIType(p1, s2);
    }

    public int compareClasses(CourseOffering co1, CourseOffering co2, Class_ c1, Class_ c2) {
        int cmp = 0;
        try {
            switch (this.iSortyBy) {
                case NAME: {
                    if (!co1.equals(co2)) {
                        cmp = ClassCourseComparator.compareComparable(co1, co2);
                        break;
                    }
                    if (!c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart())) {
                        cmp = this.compareSubparts(c1.getSchedulingSubpart(), c2.getSchedulingSubpart());
                        break;
                    }
                    cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
                    break;
                }
                case DIV_SEC: {
                    String sx1 = c1.getClassSuffix(co1);
                    String sx2 = c2.getClassSuffix(co2);
                    if (sx1 == null) {
                        if (sx2 == null) {
                            cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
                            break;
                        }
                        return -1;
                    }
                    if (sx2 == null) {
                        return 1;
                    }
                    cmp = sx1.compareTo(sx2);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
                    break;
                }
                case TIME_PATTERN: {
                    Set<TimePattern> t1s = c1.effectiveTimePatterns();
                    Set<TimePattern> t2s = c2.effectiveTimePatterns();
                    TimePattern p1 = t1s == null || t1s.isEmpty() ? null : t1s.iterator().next();
                    TimePattern p2 = t2s == null || t2s.isEmpty() ? null : t2s.iterator().next();
                    cmp = ClassCourseComparator.compareComparable(p1, p2);
                    break;
                }
                case LIMIT: {
                    cmp = ClassCourseComparator.compareComparable(c1.getExpectedCapacity(), c2.getExpectedCapacity());
                    break;
                }
                case ROOM_SIZE: {
                    cmp = ClassCourseComparator.compareComparable(c1.getMinRoomLimit(), c2.getMinRoomLimit());
                    break;
                }
                case DATE_PATTERN: {
                    ClassAssignmentProxy.AssignmentInfo a1 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c1);
                    ClassAssignmentProxy.AssignmentInfo a2 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c2);
                    DatePattern d1 = a1 == null ? c1.effectiveDatePattern() : a1.getDatePattern();
                    DatePattern d2 = a2 == null ? c2.effectiveDatePattern() : a2.getDatePattern();
                    cmp = ClassCourseComparator.compareComparable(d1, d2);
                    break;
                }
                case INSTRUCTOR: {
                    cmp = ClassCourseComparator.compareInstructors(c1, c2);
                    break;
                }
                case ASSIGNED_TIME: {
                    ClassAssignmentProxy.AssignmentInfo a2;
                    ClassAssignmentProxy.AssignmentInfo a1 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c1);
                    ClassAssignmentProxy.AssignmentInfo assignmentInfo = a2 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c2);
                    if (a1 == null) {
                        cmp = a2 == null ? 0 : -1;
                        break;
                    }
                    if (a2 == null) {
                        cmp = 1;
                        break;
                    }
                    TimeLocation t1 = a1.getPlacement().getTimeLocation();
                    TimeLocation t2 = a2.getPlacement().getTimeLocation();
                    cmp = ((Integer)t1.getStartSlots().nextElement()).compareTo((Integer)t2.getStartSlots().nextElement());
                    if (cmp == 0) {
                        cmp = Double.compare(t1.getDayCode(), t2.getDayCode());
                    }
                    if (cmp == 0) {
                        cmp = Double.compare(t1.getLength(), t2.getLength());
                    }
                    break;
                }
                case ASSIGNED_ROOM: {
                    ClassAssignmentProxy.AssignmentInfo a2;
                    ClassAssignmentProxy.AssignmentInfo a1 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c1);
                    ClassAssignmentProxy.AssignmentInfo assignmentInfo = a2 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c2);
                    if (a1 == null) {
                        cmp = a2 == null ? 0 : -1;
                        break;
                    }
                    if (a2 == null) {
                        cmp = 1;
                        break;
                    }
                    cmp = a1.getPlacement().getRoomName(",").compareTo(a2.getPlacement().getRoomName(","));
                    break;
                }
                case ASSIGNED_ROOM_CAP: {
                    ClassAssignmentProxy.AssignmentInfo a2;
                    ClassAssignmentProxy.AssignmentInfo a1 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c1);
                    ClassAssignmentProxy.AssignmentInfo assignmentInfo = a2 = this.iClassAssignmentProxy == null ? null : this.iClassAssignmentProxy.getAssignment(c2);
                    cmp = a1 == null ? (a2 == null ? 0 : -1) : (a2 == null ? 1 : Double.compare(a1.getPlacement().getRoomSize(), a2.getPlacement().getRoomSize()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cmp != 0) {
            return cmp;
        }
        cmp = !co1.equals(co2) ? this.compareCourses(co1, co2) : (!c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart()) ? this.compareSubparts(c1.getSchedulingSubpart(), c2.getSchedulingSubpart()) : c1.getSectionNumber().compareTo(c2.getSectionNumber()));
        if (cmp != 0) {
            return cmp;
        }
        cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
        if (cmp != 0) {
            return cmp;
        }
        return c1.getUniqueId().compareTo(c2.getUniqueId());
    }

    public int compareByParentChildSameIType(CourseOffering co, Class_ c1, Class_ c2) {
        SchedulingSubpart s2;
        SchedulingSubpart s1 = c1.getSchedulingSubpart();
        if (s1.equals(s2 = c2.getSchedulingSubpart())) {
            while (s1.getParentSubpart() != null && s1.getParentSubpart().getItype().equals(s1.getItype()) && !c1.getParentClass().equals(c2.getParentClass())) {
                s1 = s1.getParentSubpart();
                c1 = c1.getParentClass();
                s2 = s2.getParentSubpart();
                c2 = c2.getParentClass();
            }
            return this.compareClasses(co, co, c1, c2);
        }
        if (s1.getItype().equals(s2.getItype())) {
            if (this.isParentSameIType(s1, s2)) {
                while (!s1.equals(s2)) {
                    s1 = s1.getParentSubpart();
                    c1 = c1.getParentClass();
                }
                while (s1.getParentSubpart() != null && s1.getParentSubpart().getItype().equals(s1.getItype())) {
                    s1 = s1.getParentSubpart();
                    c1 = c1.getParentClass();
                    s2 = s2.getParentSubpart();
                    c2 = c2.getParentClass();
                }
                int cmp = this.compareClasses(co, co, c1, c2);
                if (cmp != 0) {
                    return cmp;
                }
                return 1;
            }
            if (this.isParentSameIType(s2, s1)) {
                while (!s2.equals(s1)) {
                    s2 = s2.getParentSubpart();
                    c2 = c2.getParentClass();
                }
                while (s1.getParentSubpart() != null && s1.getParentSubpart().getItype().equals(s1.getItype())) {
                    s1 = s1.getParentSubpart();
                    c1 = c1.getParentClass();
                    s2 = s2.getParentSubpart();
                    c2 = c2.getParentClass();
                }
                int cmp = this.compareClasses(co, co, c1, c2);
                if (cmp != 0) {
                    return cmp;
                }
                return -1;
            }
        }
        return this.compareSubparts(s1, s2);
    }

    public static int compareComparable(Comparable c1, Comparable c2) {
        return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
    }

    public static int compareInstructors(Class_ c1, Class_ c2) {
        TreeSet<DepartmentalInstructor> s1 = new TreeSet<DepartmentalInstructor>();
        TreeSet<DepartmentalInstructor> s2 = new TreeSet<DepartmentalInstructor>();
        for (ClassInstructor i : c1.getClassInstructors()) {
            s1.add(i.getInstructor());
        }
        for (ClassInstructor i : c2.getClassInstructors()) {
            s2.add(i.getInstructor());
        }
        Iterator i1 = s1.iterator();
        Iterator i2 = s2.iterator();
        while (i1.hasNext() || i2.hasNext()) {
            if (!i1.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            int cmp = ((DepartmentalInstructor)i1.next()).compareTo(i2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int compareCourses(CourseOffering co1, CourseOffering co2) {
        int cmp = co1.getCourseName().compareTo(co2.getCourseName());
        if (cmp != 0) {
            return cmp;
        }
        return co1.getUniqueId().compareTo(co2.getUniqueId());
    }

    public int compare(Object o1, Object o2) {
        CourseOffering co2;
        CourseOffering co1;
        Class_ c2;
        Class_ c1;
        if (o1 instanceof Class_) {
            c1 = (Class_)o1;
            c2 = (Class_)o2;
            co1 = c1.getSchedulingSubpart().getControllingCourseOffering();
            co2 = c2.getSchedulingSubpart().getControllingCourseOffering();
        } else {
            c1 = (Class_)((Object[])o1)[0];
            c2 = (Class_)((Object[])o2)[0];
            co1 = (CourseOffering)((Object[])o1)[1];
            co2 = (CourseOffering)((Object[])o2)[1];
        }
        if (!co1.getSubjectArea().equals(co2.getSubjectArea())) {
            int cmp = co1.getSubjectAreaAbbv().compareToIgnoreCase(co2.getSubjectAreaAbbv());
            if (cmp != 0) {
                return cmp;
            }
            return co1.getSubjectArea().getUniqueId().compareTo(co2.getSubjectArea().getUniqueId());
        }
        if (this.iKeepSubpart) {
            if (!co1.equals(co2)) {
                return this.compareCourses(co1, co2);
            }
            return this.compareByParentChildSameIType(co1, c1, c2);
        }
        return this.compareClasses(co1, co2, c1, c2);
    }

    public static enum SortBy {
        NAME,
        DIV_SEC,
        ENROLLMENT,
        LIMIT,
        ROOM_SIZE,
        DATE_PATTERN,
        TIME_PATTERN,
        INSTRUCTOR,
        ASSIGNED_TIME,
        ASSIGNED_ROOM,
        ASSIGNED_ROOM_CAP;

    }
}

