/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentNote;

@MappedSuperclass
public abstract class BaseStudentNote
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iTextNote;
    private Date iTimeStamp;
    private String iUserId;
    private Student iStudent;

    public BaseStudentNote() {
    }

    public BaseStudentNote(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="text_note", nullable=true, length=1000)
    public String getTextNote() {
        return this.iTextNote;
    }

    public void setTextNote(String textNote) {
        this.iTextNote = textNote;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="user_id", nullable=true, length=40)
    public String getUserId() {
        return this.iUserId;
    }

    public void setUserId(String userId) {
        this.iUserId = userId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentNote)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentNote)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentNote)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentNote[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "StudentNote[\n\tStudent: " + String.valueOf(this.getStudent()) + "\n\tTextNote: " + this.getTextNote() + "\n\tTimeStamp: " + String.valueOf(this.getTimeStamp()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUserId: " + this.getUserId() + "]";
    }
}

