/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverPredefinedSetting;

@MappedSuperclass
public abstract class BaseSolverPredefinedSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iDescription;
    private Integer iAppearance;
    private Set<SolverParameter> iParameters;

    public BaseSolverPredefinedSetting() {
    }

    public BaseSolverPredefinedSetting(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="solver_predef_setting_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=true, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @Column(name="appearance", nullable=true, length=2)
    public Integer getAppearance() {
        return this.iAppearance;
    }

    public void setAppearance(Integer appearance) {
        this.iAppearance = appearance;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="solver_predef_setting_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SolverParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<SolverParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(SolverParameter solverParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<SolverParameter>();
        }
        this.iParameters.add(solverParameter);
    }

    @Deprecated
    public void addToparameters(SolverParameter solverParameter) {
        this.addToParameters(solverParameter);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolverPredefinedSetting)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolverPredefinedSetting)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolverPredefinedSetting)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "SolverPredefinedSetting[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "SolverPredefinedSetting[\n\tAppearance: " + this.getAppearance() + "\n\tDescription: " + this.getDescription() + "\n\tName: " + this.getName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

