/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.RoomFeatureType;

@MappedSuperclass
public abstract class BaseRoomFeatureType
extends RefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean iShowInEventManagement;
    private Boolean iShowInInstructorSurvey;

    public BaseRoomFeatureType() {
    }

    public BaseRoomFeatureType(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="events", nullable=false)
    public Boolean isShowInEventManagement() {
        return this.iShowInEventManagement;
    }

    @Transient
    public Boolean getShowInEventManagement() {
        return this.iShowInEventManagement;
    }

    public void setShowInEventManagement(Boolean showInEventManagement) {
        this.iShowInEventManagement = showInEventManagement;
    }

    @Column(name="survey", nullable=false)
    public Boolean isShowInInstructorSurvey() {
        return this.iShowInInstructorSurvey;
    }

    @Transient
    public Boolean getShowInInstructorSurvey() {
        return this.iShowInInstructorSurvey;
    }

    public void setShowInInstructorSurvey(Boolean showInInstructorSurvey) {
        this.iShowInInstructorSurvey = showInInstructorSurvey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomFeatureType)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomFeatureType)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomFeatureType)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "RoomFeatureType[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "RoomFeatureType[\n\tLabel: " + this.getLabel() + "\n\tReference: " + this.getReference() + "\n\tShowInEventManagement: " + this.getShowInEventManagement() + "\n\tShowInInstructorSurvey: " + this.getShowInInstructorSurvey() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

