/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.JoinFormula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomDept;

@MappedSuperclass
public abstract class BaseRoomDept
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Boolean iControl;
    private PreferenceLevel iPreference;
    private Location iRoom;
    private Department iDepartment;

    public BaseRoomDept() {
    }

    public BaseRoomDept(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="room_sharing_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="is_control", nullable=false)
    public Boolean isControl() {
        return this.iControl;
    }

    @Transient
    public Boolean getControl() {
        return this.iControl;
    }

    public void setControl(Boolean control) {
        this.iControl = control;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="(select p.pref_level_id from %SCHEMA%.room_pref p where p.owner_id = department_id and p.room_id = room_id)")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public PreferenceLevel getPreference() {
        return this.iPreference;
    }

    public void setPreference(PreferenceLevel preference) {
        this.iPreference = preference;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="room_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Location getRoom() {
        return this.iRoom;
    }

    public void setRoom(Location room) {
        this.iRoom = room;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="department_id", nullable=false)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomDept)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomDept)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomDept)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RoomDept[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "RoomDept[\n\tControl: " + this.getControl() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tRoom: " + String.valueOf(this.getRoom()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

