/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.TeachingResponsibility;

@MappedSuperclass
public abstract class BasePitClassInstructor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPercentShare;
    private Integer iNormalizedPercentShare;
    private Boolean iLead;
    private PitClass iPitClassInstructing;
    private PitDepartmentalInstructor iPitDepartmentalInstructor;
    private TeachingResponsibility iResponsibility;

    public BasePitClassInstructor() {
    }

    public BasePitClassInstructor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="percent_share", nullable=false, length=3)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @Column(name="normalized_pct_share", nullable=false, length=3)
    public Integer getNormalizedPercentShare() {
        return this.iNormalizedPercentShare;
    }

    public void setNormalizedPercentShare(Integer normalizedPercentShare) {
        this.iNormalizedPercentShare = normalizedPercentShare;
    }

    @Column(name="is_lead", nullable=false)
    public Boolean isLead() {
        return this.iLead;
    }

    @Transient
    public Boolean getLead() {
        return this.iLead;
    }

    public void setLead(Boolean lead) {
        this.iLead = lead;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_class_id", nullable=false)
    public PitClass getPitClassInstructing() {
        return this.iPitClassInstructing;
    }

    public void setPitClassInstructing(PitClass pitClassInstructing) {
        this.iPitClassInstructing = pitClassInstructing;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_dept_instr_id", nullable=false)
    public PitDepartmentalInstructor getPitDepartmentalInstructor() {
        return this.iPitDepartmentalInstructor;
    }

    public void setPitDepartmentalInstructor(PitDepartmentalInstructor pitDepartmentalInstructor) {
        this.iPitDepartmentalInstructor = pitDepartmentalInstructor;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="responsibility_id", nullable=true)
    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitClassInstructor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitClassInstructor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitClassInstructor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitClassInstructor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitClassInstructor[\n\tLead: " + this.getLead() + "\n\tNormalizedPercentShare: " + this.getNormalizedPercentShare() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tPitClassInstructing: " + String.valueOf(this.getPitClassInstructing()) + "\n\tPitDepartmentalInstructor: " + String.valueOf(this.getPitDepartmentalInstructor()) + "\n\tResponsibility: " + String.valueOf(this.getResponsibility()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

