/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseGlobalRoomFeature
extends RoomFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iSisReference;
    private String iSisValue;
    private Session iSession;

    public BaseGlobalRoomFeature() {
    }

    public BaseGlobalRoomFeature(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="sis_reference", nullable=true, length=20)
    public String getSisReference() {
        return this.iSisReference;
    }

    public void setSisReference(String sisReference) {
        this.iSisReference = sisReference;
    }

    @Column(name="sis_value", nullable=true, length=20)
    public String getSisValue() {
        return this.iSisValue;
    }

    public void setSisValue(String sisValue) {
        this.iSisValue = sisValue;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof GlobalRoomFeature)) {
            return false;
        }
        if (this.getUniqueId() == null || ((GlobalRoomFeature)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((GlobalRoomFeature)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "GlobalRoomFeature[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "GlobalRoomFeature[\n\tAbbv: " + this.getAbbv() + "\n\tDescription: " + this.getDescription() + "\n\tFeatureType: " + String.valueOf(this.getFeatureType()) + "\n\tLabel: " + this.getLabel() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tSisReference: " + this.getSisReference() + "\n\tSisValue: " + this.getSisValue() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

