/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;

@MappedSuperclass
public abstract class BaseExamOwner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iOwnerId;
    private Integer iOwnerType;
    private Exam iExam;
    private CourseOffering iCourse;

    public BaseExamOwner() {
    }

    public BaseExamOwner(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="owner_id", nullable=false, length=20)
    public Long getOwnerId() {
        return this.iOwnerId;
    }

    public void setOwnerId(Long ownerId) {
        this.iOwnerId = ownerId;
    }

    @Column(name="owner_type", nullable=false, length=10)
    public Integer getOwnerType() {
        return this.iOwnerType;
    }

    public void setOwnerType(Integer ownerType) {
        this.iOwnerType = ownerType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="exam_id", nullable=false)
    public Exam getExam() {
        return this.iExam;
    }

    public void setExam(Exam exam) {
        this.iExam = exam;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_id", nullable=false)
    public CourseOffering getCourse() {
        return this.iCourse;
    }

    public void setCourse(CourseOffering course) {
        this.iCourse = course;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamOwner)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExamOwner)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExamOwner)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExamOwner[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExamOwner[\n\tCourse: " + String.valueOf(this.getCourse()) + "\n\tExam: " + String.valueOf(this.getExam()) + "\n\tOwnerId: " + this.getOwnerId() + "\n\tOwnerType: " + this.getOwnerType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

