/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExternalDepartmentStatusType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseDepartment
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iDeptCode;
    private String iAbbreviation;
    private String iName;
    private Boolean iAllowReqTime;
    private Boolean iAllowReqRoom;
    private Boolean iAllowReqDistribution;
    private Boolean iAllowEvents;
    private Boolean iAllowStudentScheduling;
    private Boolean iInheritInstructorPreferences;
    private String iRoomSharingColor;
    private Boolean iExternalManager;
    private String iExternalMgrLabel;
    private String iExternalMgrAbbv;
    private Integer iDistributionPrefPriority;
    private Boolean iExternalFundingDept;
    private Session iSession;
    private DepartmentStatusType iStatusType;
    private SolverGroup iSolverGroup;
    private Set<SubjectArea> iSubjectAreas;
    private Set<RoomDept> iRoomDepts;
    private Set<DatePattern> iDatePatterns;
    private Set<TimePattern> iTimePatterns;
    private Set<ExternalDepartmentStatusType> iExternalStatusTypes;
    private Set<TimetableManager> iTimetableManagers;
    private Set<DepartmentalInstructor> iInstructors;

    public BaseDepartment() {
    }

    public BaseDepartment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="dept_code", nullable=false, length=50)
    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    @Column(name="abbreviation", nullable=true, length=20)
    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="allow_req_time", nullable=false)
    public Boolean isAllowReqTime() {
        return this.iAllowReqTime;
    }

    @Transient
    public Boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(Boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    @Column(name="allow_req_room", nullable=false)
    public Boolean isAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    @Transient
    public Boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(Boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    @Column(name="allow_req_dist", nullable=false)
    public Boolean isAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    @Transient
    public Boolean getAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    public void setAllowReqDistribution(Boolean allowReqDistribution) {
        this.iAllowReqDistribution = allowReqDistribution;
    }

    @Column(name="allow_events", nullable=false)
    public Boolean isAllowEvents() {
        return this.iAllowEvents;
    }

    @Transient
    public Boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(Boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    @Column(name="allow_student_schd", nullable=false)
    public Boolean isAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    @Transient
    public Boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(Boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    @Column(name="instructor_pref", nullable=false)
    public Boolean isInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    @Transient
    public Boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(Boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    @Column(name="rs_color", nullable=true, length=6)
    public String getRoomSharingColor() {
        return this.iRoomSharingColor;
    }

    public void setRoomSharingColor(String roomSharingColor) {
        this.iRoomSharingColor = roomSharingColor;
    }

    @Column(name="external_manager", nullable=false)
    public Boolean isExternalManager() {
        return this.iExternalManager;
    }

    @Transient
    public Boolean getExternalManager() {
        return this.iExternalManager;
    }

    public void setExternalManager(Boolean externalManager) {
        this.iExternalManager = externalManager;
    }

    @Column(name="external_mgr_label", nullable=true, length=30)
    public String getExternalMgrLabel() {
        return this.iExternalMgrLabel;
    }

    public void setExternalMgrLabel(String externalMgrLabel) {
        this.iExternalMgrLabel = externalMgrLabel;
    }

    @Column(name="external_mgr_abbv", nullable=true, length=10)
    public String getExternalMgrAbbv() {
        return this.iExternalMgrAbbv;
    }

    public void setExternalMgrAbbv(String externalMgrAbbv) {
        this.iExternalMgrAbbv = externalMgrAbbv;
    }

    @Column(name="dist_priority", nullable=false)
    public Integer getDistributionPrefPriority() {
        return this.iDistributionPrefPriority;
    }

    public void setDistributionPrefPriority(Integer distributionPrefPriority) {
        this.iDistributionPrefPriority = distributionPrefPriority;
    }

    @Column(name="external_funding_dept", nullable=true)
    public Boolean isExternalFundingDept() {
        return this.iExternalFundingDept;
    }

    @Transient
    public Boolean getExternalFundingDept() {
        return this.iExternalFundingDept;
    }

    public void setExternalFundingDept(Boolean externalFundingDept) {
        this.iExternalFundingDept = externalFundingDept;
    }

    @Override
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="status_type", nullable=true)
    public DepartmentStatusType getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(DepartmentStatusType statusType) {
        this.iStatusType = statusType;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="solver_group_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public SolverGroup getSolverGroup() {
        return this.iSolverGroup;
    }

    public void setSolverGroup(SolverGroup solverGroup) {
        this.iSolverGroup = solverGroup;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="department", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SubjectArea> getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Set<SubjectArea> subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void addToSubjectAreas(SubjectArea subjectArea) {
        if (this.iSubjectAreas == null) {
            this.iSubjectAreas = new HashSet<SubjectArea>();
        }
        this.iSubjectAreas.add(subjectArea);
    }

    @Deprecated
    public void addTosubjectAreas(SubjectArea subjectArea) {
        this.addToSubjectAreas(subjectArea);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="department", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RoomDept> getRoomDepts() {
        return this.iRoomDepts;
    }

    public void setRoomDepts(Set<RoomDept> roomDepts) {
        this.iRoomDepts = roomDepts;
    }

    public void addToRoomDepts(RoomDept roomDept) {
        if (this.iRoomDepts == null) {
            this.iRoomDepts = new HashSet<RoomDept>();
        }
        this.iRoomDepts.add(roomDept);
    }

    @Deprecated
    public void addToroomDepts(RoomDept roomDept) {
        this.addToRoomDepts(roomDept);
    }

    @ManyToMany
    @JoinTable(name="date_pattern_dept", joinColumns={@JoinColumn(name="dept_id")}, inverseJoinColumns={@JoinColumn(name="pattern_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DatePattern> getDatePatterns() {
        return this.iDatePatterns;
    }

    public void setDatePatterns(Set<DatePattern> datePatterns) {
        this.iDatePatterns = datePatterns;
    }

    public void addToDatePatterns(DatePattern datePattern) {
        if (this.iDatePatterns == null) {
            this.iDatePatterns = new HashSet<DatePattern>();
        }
        this.iDatePatterns.add(datePattern);
    }

    @Deprecated
    public void addTodatePatterns(DatePattern datePattern) {
        this.addToDatePatterns(datePattern);
    }

    @Override
    @ManyToMany
    @JoinTable(name="time_pattern_dept", joinColumns={@JoinColumn(name="dept_id")}, inverseJoinColumns={@JoinColumn(name="pattern_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimePattern> getTimePatterns() {
        return this.iTimePatterns;
    }

    public void setTimePatterns(Set<TimePattern> timePatterns) {
        this.iTimePatterns = timePatterns;
    }

    public void addToTimePatterns(TimePattern timePattern) {
        if (this.iTimePatterns == null) {
            this.iTimePatterns = new HashSet<TimePattern>();
        }
        this.iTimePatterns.add(timePattern);
    }

    @Deprecated
    public void addTotimePatterns(TimePattern timePattern) {
        this.addToTimePatterns(timePattern);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="externalDepartment", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExternalDepartmentStatusType> getExternalStatusTypes() {
        return this.iExternalStatusTypes;
    }

    public void setExternalStatusTypes(Set<ExternalDepartmentStatusType> externalStatusTypes) {
        this.iExternalStatusTypes = externalStatusTypes;
    }

    public void addToExternalStatusTypes(ExternalDepartmentStatusType externalDepartmentStatusType) {
        if (this.iExternalStatusTypes == null) {
            this.iExternalStatusTypes = new HashSet<ExternalDepartmentStatusType>();
        }
        this.iExternalStatusTypes.add(externalDepartmentStatusType);
    }

    @Deprecated
    public void addToexternalStatusTypes(ExternalDepartmentStatusType externalDepartmentStatusType) {
        this.addToExternalStatusTypes(externalDepartmentStatusType);
    }

    @ManyToMany
    @JoinTable(name="dept_to_tt_mgr", joinColumns={@JoinColumn(name="department_id")}, inverseJoinColumns={@JoinColumn(name="timetable_mgr_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimetableManager> getTimetableManagers() {
        return this.iTimetableManagers;
    }

    public void setTimetableManagers(Set<TimetableManager> timetableManagers) {
        this.iTimetableManagers = timetableManagers;
    }

    public void addToTimetableManagers(TimetableManager timetableManager) {
        if (this.iTimetableManagers == null) {
            this.iTimetableManagers = new HashSet<TimetableManager>();
        }
        this.iTimetableManagers.add(timetableManager);
    }

    @Deprecated
    public void addTotimetableManagers(TimetableManager timetableManager) {
        this.addToTimetableManagers(timetableManager);
    }

    @OneToMany(mappedBy="department", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToInstructors(departmentalInstructor);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Department)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Department)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Department)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Department[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    @Override
    public String toDebugString() {
        return "Department[\n\tAbbreviation: " + this.getAbbreviation() + "\n\tAllowEvents: " + this.getAllowEvents() + "\n\tAllowReqDistribution: " + this.getAllowReqDistribution() + "\n\tAllowReqRoom: " + this.getAllowReqRoom() + "\n\tAllowReqTime: " + this.getAllowReqTime() + "\n\tAllowStudentScheduling: " + this.getAllowStudentScheduling() + "\n\tDeptCode: " + this.getDeptCode() + "\n\tDistributionPrefPriority: " + this.getDistributionPrefPriority() + "\n\tExternalFundingDept: " + this.getExternalFundingDept() + "\n\tExternalManager: " + this.getExternalManager() + "\n\tExternalMgrAbbv: " + this.getExternalMgrAbbv() + "\n\tExternalMgrLabel: " + this.getExternalMgrLabel() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tInheritInstructorPreferences: " + this.getInheritInstructorPreferences() + "\n\tName: " + this.getName() + "\n\tRoomSharingColor: " + this.getRoomSharingColor() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tSolverGroup: " + String.valueOf(this.getSolverGroup()) + "\n\tStatusType: " + String.valueOf(this.getStatusType()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

