/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.RelatedCourseInfo;

@MappedSuperclass
public abstract class BaseCourseEvent
extends Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean iReqAttendance;
    private Set<RelatedCourseInfo> iRelatedCourses;

    public BaseCourseEvent() {
    }

    public BaseCourseEvent(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="req_attd", nullable=false)
    public Boolean isReqAttendance() {
        return this.iReqAttendance;
    }

    @Transient
    public Boolean getReqAttendance() {
        return this.iReqAttendance;
    }

    public void setReqAttendance(Boolean reqAttendance) {
        this.iReqAttendance = reqAttendance;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="event", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RelatedCourseInfo> getRelatedCourses() {
        return this.iRelatedCourses;
    }

    public void setRelatedCourses(Set<RelatedCourseInfo> relatedCourses) {
        this.iRelatedCourses = relatedCourses;
    }

    public void addToRelatedCourses(RelatedCourseInfo relatedCourseInfo) {
        if (this.iRelatedCourses == null) {
            this.iRelatedCourses = new HashSet<RelatedCourseInfo>();
        }
        this.iRelatedCourses.add(relatedCourseInfo);
    }

    @Deprecated
    public void addTorelatedCourses(RelatedCourseInfo relatedCourseInfo) {
        this.addToRelatedCourses(relatedCourseInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseEvent)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseEvent)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseEvent)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "CourseEvent[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "CourseEvent[\n\tEmail: " + this.getEmail() + "\n\tEventName: " + this.getEventName() + "\n\tExpirationDate: " + String.valueOf(this.getExpirationDate()) + "\n\tMainContact: " + String.valueOf(this.getMainContact()) + "\n\tMaxCapacity: " + this.getMaxCapacity() + "\n\tMinCapacity: " + this.getMinCapacity() + "\n\tReqAttendance: " + this.getReqAttendance() + "\n\tSponsoringOrganization: " + String.valueOf(this.getSponsoringOrganization()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

