/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinFormula;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TeachingClassRequest;

@MappedSuperclass
public abstract class BaseClass_
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iExpectedCapacity;
    private String iNotes;
    private Integer iNbrRooms;
    private Boolean iRoomsSplitAttendance;
    private Integer iSectionNumberCache;
    private Boolean iDisplayInstructor;
    private String iSchedulePrintNote;
    private String iClassSuffix;
    private Boolean iEnabledForStudentScheduling;
    private Integer iMaxExpectedCapacity;
    private Float iRoomRatio;
    private Long iUniqueIdRolledForwardFrom;
    private String iExternalUniqueId;
    private Integer iEnrollment;
    private Boolean iCancelled;
    private Integer iSnapshotLimit;
    private Date iSnapshotLimitDate;
    private Department iControllingDept;
    private Department iManagingDept;
    private SchedulingSubpart iSchedulingSubpart;
    private Class_ iParentClass;
    private DatePattern iDatePattern;
    private Assignment iCommittedAssignment;
    private LearningManagementSystemInfo iLmsInfo;
    private Department iFundingDept;
    private Set<Class_> iChildClasses;
    private Set<ClassInstructor> iClassInstructors;
    private Set<Assignment> iAssignments;
    private Set<StudentClassEnrollment> iStudentEnrollments;
    private Set<TeachingClassRequest> iTeachingRequests;

    public BaseClass_() {
    }

    public BaseClass_(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="expected_capacity", nullable=false, length=4)
    public Integer getExpectedCapacity() {
        return this.iExpectedCapacity;
    }

    public void setExpectedCapacity(Integer expectedCapacity) {
        this.iExpectedCapacity = expectedCapacity;
    }

    @Column(name="notes", nullable=true, length=1000)
    public String getNotes() {
        return this.iNotes;
    }

    public void setNotes(String notes) {
        this.iNotes = notes;
    }

    @Column(name="nbr_rooms", nullable=true, length=4)
    public Integer getNbrRooms() {
        return this.iNbrRooms;
    }

    public void setNbrRooms(Integer nbrRooms) {
        this.iNbrRooms = nbrRooms;
    }

    @Column(name="rooms_split_att", nullable=true)
    public Boolean isRoomsSplitAttendance() {
        return this.iRoomsSplitAttendance;
    }

    @Transient
    public Boolean getRoomsSplitAttendance() {
        return this.iRoomsSplitAttendance;
    }

    public void setRoomsSplitAttendance(Boolean roomsSplitAttendance) {
        this.iRoomsSplitAttendance = roomsSplitAttendance;
    }

    @Column(name="section_number", nullable=true, length=5)
    public Integer getSectionNumberCache() {
        return this.iSectionNumberCache;
    }

    public void setSectionNumberCache(Integer sectionNumberCache) {
        this.iSectionNumberCache = sectionNumberCache;
    }

    @Column(name="display_instructor", nullable=false)
    public Boolean isDisplayInstructor() {
        return this.iDisplayInstructor;
    }

    @Transient
    public Boolean getDisplayInstructor() {
        return this.iDisplayInstructor;
    }

    public void setDisplayInstructor(Boolean displayInstructor) {
        this.iDisplayInstructor = displayInstructor;
    }

    @Column(name="sched_print_note", nullable=true, length=2000)
    public String getSchedulePrintNote() {
        return this.iSchedulePrintNote;
    }

    public void setSchedulePrintNote(String schedulePrintNote) {
        this.iSchedulePrintNote = schedulePrintNote;
    }

    @Column(name="class_suffix", nullable=true, length=40)
    public String getClassSuffix() {
        return this.iClassSuffix;
    }

    public void setClassSuffix(String classSuffix) {
        this.iClassSuffix = classSuffix;
    }

    @Column(name="display_in_sched_book", nullable=false)
    public Boolean isEnabledForStudentScheduling() {
        return this.iEnabledForStudentScheduling;
    }

    @Transient
    public Boolean getEnabledForStudentScheduling() {
        return this.iEnabledForStudentScheduling;
    }

    public void setEnabledForStudentScheduling(Boolean enabledForStudentScheduling) {
        this.iEnabledForStudentScheduling = enabledForStudentScheduling;
    }

    @Column(name="max_expected_capacity", nullable=false, length=4)
    public Integer getMaxExpectedCapacity() {
        return this.iMaxExpectedCapacity;
    }

    public void setMaxExpectedCapacity(Integer maxExpectedCapacity) {
        this.iMaxExpectedCapacity = maxExpectedCapacity;
    }

    @Column(name="room_ratio", nullable=false)
    public Float getRoomRatio() {
        return this.iRoomRatio;
    }

    public void setRoomRatio(Float roomRatio) {
        this.iRoomRatio = roomRatio;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Formula(value="(select count(e.student_id) from %SCHEMA%.student_class_enrl e where e.class_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @Column(name="cancelled", nullable=false)
    public Boolean isCancelled() {
        return this.iCancelled;
    }

    @Transient
    public Boolean getCancelled() {
        return this.iCancelled;
    }

    public void setCancelled(Boolean cancelled) {
        this.iCancelled = cancelled;
    }

    @Column(name="snapshot_limit", nullable=true, length=10)
    public Integer getSnapshotLimit() {
        return this.iSnapshotLimit;
    }

    public void setSnapshotLimit(Integer snapshotLimit) {
        this.iSnapshotLimit = snapshotLimit;
    }

    @Column(name="snapshot_limit_date", nullable=true)
    public Date getSnapshotLimitDate() {
        return this.iSnapshotLimitDate;
    }

    public void setSnapshotLimitDate(Date snapshotLimitDate) {
        this.iSnapshotLimitDate = snapshotLimitDate;
    }

    @ManyToOne
    @JoinFormula(value=" ( select sa.department_uniqueid from %SCHEMA%.scheduling_subpart ss, %SCHEMA%.instr_offering_config ioc, %SCHEMA%.instructional_offering io, %SCHEMA%.course_offering co, %SCHEMA%.subject_area sa where ss.uniqueid = subpart_id and ioc.uniqueid = ss.config_id and io.uniqueid = ioc.instr_offr_id and co.instr_offr_id = io.uniqueid and co.is_control = %TRUE% and sa.uniqueid = co.subject_area_id ) ")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getControllingDept() {
        return this.iControllingDept;
    }

    public void setControllingDept(Department controllingDept) {
        this.iControllingDept = controllingDept;
    }

    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    @JoinColumn(name="managing_dept", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getManagingDept() {
        return this.iManagingDept;
    }

    public void setManagingDept(Department managingDept) {
        this.iManagingDept = managingDept;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="subpart_id", nullable=false)
    public SchedulingSubpart getSchedulingSubpart() {
        return this.iSchedulingSubpart;
    }

    public void setSchedulingSubpart(SchedulingSubpart schedulingSubpart) {
        this.iSchedulingSubpart = schedulingSubpart;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="parent_class_id", nullable=true)
    public Class_ getParentClass() {
        return this.iParentClass;
    }

    public void setParentClass(Class_ parentClass) {
        this.iParentClass = parentClass;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="date_pattern_id", nullable=true)
    public DatePattern getDatePattern() {
        return this.iDatePattern;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.iDatePattern = datePattern;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value=" (       select a.uniqueid from        %SCHEMA%.assignment a,        %SCHEMA%.solution s,        %SCHEMA%.department d,       %SCHEMA%.solver_group g      where a.class_id=uniqueid and        a.solution_id=s.uniqueid and        s.commited = %TRUE% and        d.uniqueid=managing_dept and        s.owner_id=g.uniqueid and       d.solver_group_id=g.uniqueid ) ")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Assignment getCommittedAssignment() {
        return this.iCommittedAssignment;
    }

    public void setCommittedAssignment(Assignment committedAssignment) {
        this.iCommittedAssignment = committedAssignment;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="lms_info_id", nullable=true)
    public LearningManagementSystemInfo getLmsInfo() {
        return this.iLmsInfo;
    }

    public void setLmsInfo(LearningManagementSystemInfo lmsInfo) {
        this.iLmsInfo = lmsInfo;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="funding_dept_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getFundingDept() {
        return this.iFundingDept;
    }

    public void setFundingDept(Department fundingDept) {
        this.iFundingDept = fundingDept;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentClass")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Class_> getChildClasses() {
        return this.iChildClasses;
    }

    public void setChildClasses(Set<Class_> childClasses) {
        this.iChildClasses = childClasses;
    }

    public void addToChildClasses(Class_ class_) {
        if (this.iChildClasses == null) {
            this.iChildClasses = new HashSet<Class_>();
        }
        this.iChildClasses.add(class_);
    }

    @Deprecated
    public void addTochildClasses(Class_ class_) {
        this.addToChildClasses(class_);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="classInstructing", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ClassInstructor> getClassInstructors() {
        return this.iClassInstructors;
    }

    public void setClassInstructors(Set<ClassInstructor> classInstructors) {
        this.iClassInstructors = classInstructors;
    }

    public void addToClassInstructors(ClassInstructor classInstructor) {
        if (this.iClassInstructors == null) {
            this.iClassInstructors = new HashSet<ClassInstructor>();
        }
        this.iClassInstructors.add(classInstructor);
    }

    @Deprecated
    public void addToclassInstructors(ClassInstructor classInstructor) {
        this.addToClassInstructors(classInstructor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="clazz", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToAssignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    @Deprecated
    public void addToassignments(Assignment assignment) {
        this.addToAssignments(assignment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="clazz", orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentClassEnrollment> getStudentEnrollments() {
        return this.iStudentEnrollments;
    }

    public void setStudentEnrollments(Set<StudentClassEnrollment> studentEnrollments) {
        this.iStudentEnrollments = studentEnrollments;
    }

    public void addToStudentEnrollments(StudentClassEnrollment studentClassEnrollment) {
        if (this.iStudentEnrollments == null) {
            this.iStudentEnrollments = new HashSet<StudentClassEnrollment>();
        }
        this.iStudentEnrollments.add(studentClassEnrollment);
    }

    @Deprecated
    public void addTostudentEnrollments(StudentClassEnrollment studentClassEnrollment) {
        this.addToStudentEnrollments(studentClassEnrollment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="teachingClass", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TeachingClassRequest> getTeachingRequests() {
        return this.iTeachingRequests;
    }

    public void setTeachingRequests(Set<TeachingClassRequest> teachingRequests) {
        this.iTeachingRequests = teachingRequests;
    }

    public void addToTeachingRequests(TeachingClassRequest teachingClassRequest) {
        if (this.iTeachingRequests == null) {
            this.iTeachingRequests = new HashSet<TeachingClassRequest>();
        }
        this.iTeachingRequests.add(teachingClassRequest);
    }

    @Deprecated
    public void addToteachingRequests(TeachingClassRequest teachingClassRequest) {
        this.addToTeachingRequests(teachingClassRequest);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Class_)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Class_)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Class_)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "Class_[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "Class_[\n\tCancelled: " + this.getCancelled() + "\n\tClassSuffix: " + this.getClassSuffix() + "\n\tDatePattern: " + String.valueOf(this.getDatePattern()) + "\n\tDisplayInstructor: " + this.getDisplayInstructor() + "\n\tEnabledForStudentScheduling: " + this.getEnabledForStudentScheduling() + "\n\tExpectedCapacity: " + this.getExpectedCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFundingDept: " + String.valueOf(this.getFundingDept()) + "\n\tLmsInfo: " + String.valueOf(this.getLmsInfo()) + "\n\tManagingDept: " + String.valueOf(this.getManagingDept()) + "\n\tMaxExpectedCapacity: " + this.getMaxExpectedCapacity() + "\n\tNbrRooms: " + this.getNbrRooms() + "\n\tNotes: " + this.getNotes() + "\n\tParentClass: " + String.valueOf(this.getParentClass()) + "\n\tRoomRatio: " + this.getRoomRatio() + "\n\tRoomsSplitAttendance: " + this.getRoomsSplitAttendance() + "\n\tSchedulePrintNote: " + this.getSchedulePrintNote() + "\n\tSchedulingSubpart: " + String.valueOf(this.getSchedulingSubpart()) + "\n\tSectionNumberCache: " + this.getSectionNumberCache() + "\n\tSnapshotLimit: " + this.getSnapshotLimit() + "\n\tSnapshotLimitDate: " + String.valueOf(this.getSnapshotLimitDate()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

