/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;

@MappedSuperclass
public abstract class BaseClassInstructor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPercentShare;
    private Boolean iLead;
    private Class_ iClassInstructing;
    private DepartmentalInstructor iInstructor;
    private TeachingResponsibility iResponsibility;
    private TeachingRequest iTeachingRequest;

    public BaseClassInstructor() {
    }

    public BaseClassInstructor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="class_instructor_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="percent_share", nullable=false, length=3)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @Column(name="is_lead", nullable=false)
    public Boolean isLead() {
        return this.iLead;
    }

    @Transient
    public Boolean getLead() {
        return this.iLead;
    }

    public void setLead(Boolean lead) {
        this.iLead = lead;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="class_id", nullable=false)
    public Class_ getClassInstructing() {
        return this.iClassInstructing;
    }

    public void setClassInstructing(Class_ classInstructing) {
        this.iClassInstructing = classInstructing;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="instructor_id", nullable=false)
    public DepartmentalInstructor getInstructor() {
        return this.iInstructor;
    }

    public void setInstructor(DepartmentalInstructor instructor) {
        this.iInstructor = instructor;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="responsibility_id", nullable=true)
    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="request_id", nullable=true)
    public TeachingRequest getTeachingRequest() {
        return this.iTeachingRequest;
    }

    public void setTeachingRequest(TeachingRequest teachingRequest) {
        this.iTeachingRequest = teachingRequest;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassInstructor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ClassInstructor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ClassInstructor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ClassInstructor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ClassInstructor[\n\tClassInstructing: " + String.valueOf(this.getClassInstructing()) + "\n\tInstructor: " + String.valueOf(this.getInstructor()) + "\n\tLead: " + this.getLead() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tResponsibility: " + String.valueOf(this.getResponsibility()) + "\n\tTeachingRequest: " + String.valueOf(this.getTeachingRequest()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

