/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseBuildingPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iDistanceFrom;
    private Integer iRoomIndex;
    private Building iBuilding;

    public BaseBuildingPref() {
    }

    public BaseBuildingPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="distance_from", nullable=true)
    public Integer getDistanceFrom() {
        return this.iDistanceFrom;
    }

    public void setDistanceFrom(Integer distanceFrom) {
        this.iDistanceFrom = distanceFrom;
    }

    @Column(name="room_idx", nullable=true)
    public Integer getRoomIndex() {
        return this.iRoomIndex;
    }

    public void setRoomIndex(Integer roomIndex) {
        this.iRoomIndex = roomIndex;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="bldg_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Building getBuilding() {
        return this.iBuilding;
    }

    public void setBuilding(Building building) {
        this.iBuilding = building;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof BuildingPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((BuildingPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((BuildingPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "BuildingPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "BuildingPref[\n\tBuilding: " + String.valueOf(this.getBuilding()) + "\n\tDistanceFrom: " + this.getDistanceFrom() + "\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tRoomIndex: " + this.getRoomIndex() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

