/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AccessStatistics;

@MappedSuperclass
public abstract class BaseAccessStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private String iHost;
    private String iPage;
    private Integer iAccess;
    private Integer iActive;
    private Integer iWaiting;
    private Integer iOpened;
    private Integer iTracking;
    private Integer iActive1m;
    private Integer iActive2m;
    private Integer iActive5m;
    private Integer iActive10m;
    private Integer iActive15m;
    private Integer iGotIn;
    private Integer iLeft;
    private Integer iGaveUp;
    private Long iAvgAccessTime;
    private Long iAvgWaitTime;
    private Long iAvgAccessTimeWhenLeft;
    private Long iAvgWaitTimeWhenGotIn;

    public BaseAccessStatistics() {
    }

    public BaseAccessStatistics(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="host", nullable=false, length=50)
    public String getHost() {
        return this.iHost;
    }

    public void setHost(String host) {
        this.iHost = host;
    }

    @Column(name="page", nullable=false, length=50)
    public String getPage() {
        return this.iPage;
    }

    public void setPage(String page) {
        this.iPage = page;
    }

    @Column(name="nbr_access", nullable=false)
    public Integer getAccess() {
        return this.iAccess;
    }

    public void setAccess(Integer access) {
        this.iAccess = access;
    }

    @Column(name="nbr_active", nullable=false)
    public Integer getActive() {
        return this.iActive;
    }

    public void setActive(Integer active) {
        this.iActive = active;
    }

    @Column(name="nbr_waiting", nullable=false)
    public Integer getWaiting() {
        return this.iWaiting;
    }

    public void setWaiting(Integer waiting) {
        this.iWaiting = waiting;
    }

    @Column(name="nbr_opened", nullable=false)
    public Integer getOpened() {
        return this.iOpened;
    }

    public void setOpened(Integer opened) {
        this.iOpened = opened;
    }

    @Column(name="nbr_tracking", nullable=false)
    public Integer getTracking() {
        return this.iTracking;
    }

    public void setTracking(Integer tracking) {
        this.iTracking = tracking;
    }

    @Column(name="nbr_active1m", nullable=false)
    public Integer getActive1m() {
        return this.iActive1m;
    }

    public void setActive1m(Integer active1m) {
        this.iActive1m = active1m;
    }

    @Column(name="nbr_active2m", nullable=false)
    public Integer getActive2m() {
        return this.iActive2m;
    }

    public void setActive2m(Integer active2m) {
        this.iActive2m = active2m;
    }

    @Column(name="nbr_active5m", nullable=false)
    public Integer getActive5m() {
        return this.iActive5m;
    }

    public void setActive5m(Integer active5m) {
        this.iActive5m = active5m;
    }

    @Column(name="nbr_active10m", nullable=false)
    public Integer getActive10m() {
        return this.iActive10m;
    }

    public void setActive10m(Integer active10m) {
        this.iActive10m = active10m;
    }

    @Column(name="nbr_active15m", nullable=false)
    public Integer getActive15m() {
        return this.iActive15m;
    }

    public void setActive15m(Integer active15m) {
        this.iActive15m = active15m;
    }

    @Column(name="nbr_gotin", nullable=true)
    public Integer getGotIn() {
        return this.iGotIn;
    }

    public void setGotIn(Integer gotIn) {
        this.iGotIn = gotIn;
    }

    @Column(name="nbr_left", nullable=true)
    public Integer getLeft() {
        return this.iLeft;
    }

    public void setLeft(Integer left) {
        this.iLeft = left;
    }

    @Column(name="nbr_gaveup", nullable=true)
    public Integer getGaveUp() {
        return this.iGaveUp;
    }

    public void setGaveUp(Integer gaveUp) {
        this.iGaveUp = gaveUp;
    }

    @Column(name="avg_access", nullable=true)
    public Long getAvgAccessTime() {
        return this.iAvgAccessTime;
    }

    public void setAvgAccessTime(Long avgAccessTime) {
        this.iAvgAccessTime = avgAccessTime;
    }

    @Column(name="avg_wait", nullable=true)
    public Long getAvgWaitTime() {
        return this.iAvgWaitTime;
    }

    public void setAvgWaitTime(Long avgWaitTime) {
        this.iAvgWaitTime = avgWaitTime;
    }

    @Column(name="avg_access_out", nullable=true)
    public Long getAvgAccessTimeWhenLeft() {
        return this.iAvgAccessTimeWhenLeft;
    }

    public void setAvgAccessTimeWhenLeft(Long avgAccessTimeWhenLeft) {
        this.iAvgAccessTimeWhenLeft = avgAccessTimeWhenLeft;
    }

    @Column(name="avg_wait_in", nullable=true)
    public Long getAvgWaitTimeWhenGotIn() {
        return this.iAvgWaitTimeWhenGotIn;
    }

    public void setAvgWaitTimeWhenGotIn(Long avgWaitTimeWhenGotIn) {
        this.iAvgWaitTimeWhenGotIn = avgWaitTimeWhenGotIn;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AccessStatistics)) {
            return false;
        }
        if (this.getUniqueId() == null || ((AccessStatistics)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((AccessStatistics)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "AccessStatistics[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "AccessStatistics[\n\tAccess: " + this.getAccess() + "\n\tActive: " + this.getActive() + "\n\tActive10m: " + this.getActive10m() + "\n\tActive15m: " + this.getActive15m() + "\n\tActive1m: " + this.getActive1m() + "\n\tActive2m: " + this.getActive2m() + "\n\tActive5m: " + this.getActive5m() + "\n\tAvgAccessTime: " + this.getAvgAccessTime() + "\n\tAvgAccessTimeWhenLeft: " + this.getAvgAccessTimeWhenLeft() + "\n\tAvgWaitTime: " + this.getAvgWaitTime() + "\n\tAvgWaitTimeWhenGotIn: " + this.getAvgWaitTimeWhenGotIn() + "\n\tGaveUp: " + this.getGaveUp() + "\n\tGotIn: " + this.getGotIn() + "\n\tHost: " + this.getHost() + "\n\tLeft: " + this.getLeft() + "\n\tOpened: " + this.getOpened() + "\n\tPage: " + this.getPage() + "\n\tTimeStamp: " + String.valueOf(this.getTimeStamp()) + "\n\tTracking: " + this.getTracking() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWaiting: " + this.getWaiting() + "]";
    }
}

