/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.base.BaseTimePatternDays;
import org.unitime.timetable.util.Constants;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="time_pattern_days")
public class TimePatternDays
extends BaseTimePatternDays
implements Comparable {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private static final long serialVersionUID = 1L;

    public TimePatternDays() {
    }

    public TimePatternDays(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof TimePatternDays)) {
            return -1;
        }
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        if (firstDayOfWeek == null || firstDayOfWeek.equals(0)) {
            return -this.getDayCode().compareTo(((TimePatternDays)o).getDayCode());
        }
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            boolean b;
            int idx = (i + firstDayOfWeek) % 7;
            boolean a = (this.getDayCode() & Constants.DAY_CODES[idx]) != 0;
            boolean bl = b = (((TimePatternDays)o).getDayCode() & Constants.DAY_CODES[idx]) != 0;
            if (a == b) continue;
            return a ? -1 : 1;
        }
        return 0;
    }

    @Transient
    public String getLabel() {
        int nrDays = 0;
        for (int d = 0; d < Constants.DAY_CODES.length; ++d) {
            if ((Constants.DAY_CODES[d] & this.getDayCode()) == 0) continue;
            ++nrDays;
        }
        Object ret = "";
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            int j;
            int n = j = firstDayOfWeek == null ? i : (i + firstDayOfWeek) % 7;
            if ((Constants.DAY_CODES[j] & this.getDayCode()) == 0) continue;
            ret = nrDays <= 1 ? (String)ret + CONSTANTS.days()[j] : (String)ret + CONSTANTS.shortDays()[j];
        }
        return ret;
    }

    @Override
    public int hashCode() {
        return this.getDayCode().hashCode();
    }
}

