/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseStudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Entity
@Table(name="sectioning_status")
public class StudentSectioningStatus
extends BaseStudentSectioningStatus {
    private static final long serialVersionUID = -33276457852954947L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public boolean hasOption(Option ... options) {
        if (this.getStatus() == null) {
            return false;
        }
        for (Option option : options) {
            if ((this.getStatus() & option.toggle()) != 0) continue;
            return false;
        }
        return true;
    }

    public void addOption(Option option) {
        if (!this.hasOption(option)) {
            this.setStatus((this.getStatus() == null ? 0 : this.getStatus()) + option.toggle());
        }
    }

    public void removeOption(Option option) {
        if (this.hasOption(option)) {
            this.setStatus(this.getStatus() - option.toggle());
        }
    }

    public static StudentSectioningStatus getStatus(String reference, Long sessionId, org.hibernate.Session hibSession) {
        StudentSectioningStatus status;
        if (reference != null) {
            status = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus s where s.reference = :reference and s.session is null", StudentSectioningStatus.class).setParameter("reference", (Object)reference).setMaxResults(1).setCacheable(true).uniqueResult();
            if (status != null) {
                return status;
            }
            if (sessionId != null && (status = (StudentSectioningStatus)hibSession.createQuery("from StudentSectioningStatus s where s.reference = :reference and s.session.uniqueId = :sessionId", StudentSectioningStatus.class).setParameter("reference", (Object)reference).setParameter("sessionId", (Object)sessionId).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
                return status;
            }
        }
        if (sessionId != null && (status = (StudentSectioningStatus)hibSession.createQuery("select s.defaultSectioningStatus from Session s where s.uniqueId = :sessionId", StudentSectioningStatus.class).setParameter("sessionId", (Object)sessionId).setMaxResults(1).setCacheable(true).uniqueResult()) != null) {
            return status;
        }
        return null;
    }

    public static boolean hasOption(Option option, String reference, Long sessionId, org.hibernate.Session hibSession) {
        StudentSectioningStatus status = StudentSectioningStatus.getStatus(reference, sessionId, hibSession);
        return status == null || status.hasOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getMatchingStatuses(Long sessionId, Option ... options) {
        try (org.hibernate.Session hibSession = StudentSectioningStatusDAO.getInstance().createNewSession();){
            Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
            HashSet<String> statuses = new HashSet<String>();
            for (StudentSectioningStatus status : StudentSectioningStatus.findAll(hibSession, sessionId)) {
                if (!StudentSectioningStatus.hasEffectiveOption(status, session, options)) continue;
                statuses.add(status.getReference());
            }
            HashSet<String> hashSet = statuses;
            return hashSet;
        }
    }

    @Transient
    public boolean isEffectiveNow() {
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        int slot = 12 * cal.get(11) + cal.get(12) / 5;
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (this.getEffectiveStartDate() != null && today.before(this.getEffectiveStartDate())) {
            return false;
        }
        if (this.getEffectiveStartPeriod() != null && (this.getEffectiveStartDate() == null || today.equals(this.getEffectiveStartDate())) && slot < this.getEffectiveStartPeriod()) {
            return false;
        }
        if (this.getEffectiveStopDate() != null && today.after(this.getEffectiveStopDate())) {
            return false;
        }
        return this.getEffectiveStopPeriod() == null || this.getEffectiveStopPeriod() != null && !today.equals(this.getEffectiveStopDate()) || slot < this.getEffectiveStopPeriod();
    }

    @Transient
    public boolean isPast() {
        Calendar cal = Calendar.getInstance(Localization.getJavaLocale());
        int slot = 12 * cal.get(11) + cal.get(12) / 5;
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        if (this.getEffectiveStopDate() != null && today.after(this.getEffectiveStopDate())) {
            return true;
        }
        return this.getEffectiveStopPeriod() != null && (this.getEffectiveStopPeriod() == null || today.equals(this.getEffectiveStopDate())) && slot >= this.getEffectiveStopPeriod();
    }

    public static boolean hasEffectiveOption(StudentSectioningStatus status, Session session, Option ... options) {
        StudentSectioningStatus defaultStatus;
        if (status != null) {
            if (status.isEffectiveNow()) {
                return status.hasOption(options);
            }
            int depth = 10;
            for (StudentSectioningStatus fallback = status.getFallBackStatus(); fallback != null && depth-- > 0; fallback = fallback.getFallBackStatus()) {
                if (!fallback.isEffectiveNow()) continue;
                return fallback.hasOption(options);
            }
        }
        StudentSectioningStatus studentSectioningStatus = defaultStatus = session == null ? null : session.getDefaultSectioningStatus();
        if (defaultStatus != null) {
            if (defaultStatus.isEffectiveNow()) {
                return defaultStatus.hasOption(options);
            }
            int depth = 10;
            for (StudentSectioningStatus fallback = defaultStatus.getFallBackStatus(); fallback != null && depth-- > 0; fallback = fallback.getFallBackStatus()) {
                if (!fallback.isEffectiveNow()) continue;
                return fallback.hasOption(options);
            }
        }
        return true;
    }

    @Transient
    public String getEffectivePeriod() {
        Object start = null;
        Object stop = null;
        if (this.getEffectiveStartDate() != null || this.getEffectiveStartPeriod() != null) {
            start = this.getEffectiveStartDate() == null ? Constants.slot2str(this.getEffectiveStartPeriod()) : (this.getEffectiveStartPeriod() == null ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStartDate()) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStartDate()) + " " + Constants.slot2str(this.getEffectiveStartPeriod()));
        }
        if (this.getEffectiveStopDate() != null || this.getEffectiveStopPeriod() != null) {
            stop = this.getEffectiveStopDate() == null ? Constants.slot2str(this.getEffectiveStopPeriod()) : (this.getEffectiveStopPeriod() == null ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStopDate()) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT).format(this.getEffectiveStopDate()) + " " + Constants.slot2str(this.getEffectiveStopPeriod()));
        }
        if (start != null) {
            if (stop != null) {
                return MSG.messageEffectivePeriodBetween((String)start, (String)stop);
            }
            return MSG.messageEffectivePeriodAfter((String)start);
        }
        if (stop != null) {
            return MSG.messageEffectivePeriodBefore((String)stop);
        }
        return null;
    }

    public static List<StudentSectioningStatus> findAll(Long sessionId) {
        return StudentSectioningStatus.findAll(null, sessionId);
    }

    public static List<StudentSectioningStatus> findAll(org.hibernate.Session hibSession, Long sessionId) {
        if (sessionId == null) {
            return (hibSession == null ? StudentSectioningStatusDAO.getInstance().getSession() : hibSession).createQuery("from StudentSectioningStatus where session is null order by label", StudentSectioningStatus.class).setCacheable(true).list();
        }
        return (hibSession == null ? StudentSectioningStatusDAO.getInstance().getSession() : hibSession).createQuery("from StudentSectioningStatus where session is null or session.uniqueId = :sessionId order by label", StudentSectioningStatus.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static StudentSectioningStatus getPresentStatus(StudentSectioningStatus status) {
        int depth = 10;
        while (status != null && status.isPast() && status.getFallBackStatus() != null) {
            status = status.getFallBackStatus();
            if (depth-- != 0) continue;
            return null;
        }
        return status;
    }

    public static StudentSectioningStatus getPresentStatus(String reference, Long sessionId, org.hibernate.Session hibSession) {
        return StudentSectioningStatus.getPresentStatus(StudentSectioningStatus.getStatus(reference, sessionId, hibSession));
    }

    public boolean hasNotification(NotificationType ... notifications) {
        if (this.getNotifications() == null) {
            return false;
        }
        for (NotificationType notication : notifications) {
            if ((this.getNotifications() & notication.toggle()) != 0) continue;
            return false;
        }
        return true;
    }

    public void addNotification(NotificationType notification) {
        if (!this.hasNotification(notification)) {
            this.setNotifications((this.getNotifications() == null ? 0 : this.getNotifications()) + notification.toggle());
        }
    }

    public void removeNotification(NotificationType notification) {
        if (this.hasNotification(notification)) {
            this.setNotifications(this.getNotifications() - notification.toggle());
        }
    }

    public static enum Option {
        enabled("Scheduling Assistant Access Enabled"),
        advisor("Advisor Can Enroll"),
        email("Email Notifications"),
        notype("Must Have Course Type"),
        waitlist("Wait-Listing Enabled"),
        nobatch("Do Not Schedule in Batch Solver"),
        enrollment("Student Can Enrol"),
        admin("Admin Can Enroll"),
        registration("Student Can Register"),
        regenabled("Course Requests Access Enabled"),
        regadvisor("Advisor Can Register"),
        regadmin("Admin Can Register"),
        advcanset("Advisor Can Set Status"),
        reqval("Course Request Validation"),
        specreg("Special Registration"),
        canreq("Can Require Sections / IMs"),
        noschedule("Do Not Show Personal Schedule"),
        nosubs("No-Substitutions Enabled"),
        reschedule("Re-Scheduling Allowed");

        private String iName;

        private Option(String name) {
            this.iName = name;
        }

        @Transient
        public String getName() {
            return this.iName;
        }

        public int toggle() {
            return 1 << this.ordinal();
        }
    }

    public static enum NotificationType {
        StudentChangeRequest(MSG.notifStudentChangeRequest()),
        StudentChangeEnrollment(MSG.notifStudentChangeEnrollment()),
        AdminChangeRequest(MSG.notifAdminChangeRequest()),
        AdminChangeEnrollment(MSG.notifAdminChangeEnrollment()),
        AdminChangeApproval(MSG.notifAdminEnrollmentApproval()),
        CourseChangeSchedule(MSG.notifCourseChangeSchedule()),
        CourseChangeEnrollment(MSG.notifCourseChangeEnrollment()),
        CourseChangeEnrollmentFailed(MSG.notifCourseChangeEnrollmentFailed()),
        ExternalChangeEnrollment(MSG.notifExternalChangeEnrollment());

        private String iName;

        private NotificationType(String name) {
            this.iName = name;
        }

        public String label() {
            return this.iName;
        }

        public int toggle() {
            return 1 << this.ordinal();
        }
    }
}

