/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseStudentGroupReservation;

@Entity
@DiscriminatorValue(value="1")
public class StudentGroupReservation
extends BaseStudentGroupReservation {
    private static final long serialVersionUID = 1L;

    public StudentGroupReservation() {
    }

    public StudentGroupReservation(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        return student.getGroups().contains(this.getGroup());
    }

    @Override
    @Transient
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityGroup.intValue();
    }

    @Override
    @Transient
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitGroup.isTrue();
    }

    @Override
    @Transient
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedGroup.isTrue();
    }

    @Override
    @Transient
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapGroup.isTrue();
    }
}

