/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseSolverInfo;
import org.unitime.timetable.solver.ui.FileInfo;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;
import org.unitime.timetable.solver.ui.TimetableInfoUtil;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="solver_info")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="type", discriminatorType=DiscriminatorType.INTEGER)
public class SolverInfo
extends BaseSolverInfo {
    private static final long serialVersionUID = 1L;
    protected static Hashtable sInfoCache = null;
    protected static InfoCacheCleanup sCleanupThread = null;
    protected static long sInfoCacheTimeToLive = 600000L;
    protected static long sInfoCacheCleanupInterval = 30000L;

    public SolverInfo() {
    }

    public SolverInfo(Long uniqueId) {
        super(uniqueId);
    }

    public SolverInfo(Long uniqueId, Document value) {
        super(uniqueId);
        this.setValue(value);
    }

    @Transient
    public TimetableInfo getInfo() {
        return this.getInfo(TimetableInfoUtil.getInstance());
    }

    public TimetableInfo getInfo(TimetableInfoFileProxy proxy) {
        try {
            TimetableInfo info = SolverInfo.getCached(this.getUniqueId());
            if (info != null) {
                return info;
            }
            if (this.getData() == null) {
                return null;
            }
            Element root = this.getValue().getRootElement();
            Class<?> infoClass = null;
            try {
                infoClass = Class.forName(root.getName());
            }
            catch (ClassNotFoundException ex) {
                infoClass = Class.forName(this.getDefinition().getImplementation());
            }
            info = (TimetableInfo)infoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            info.load(root);
            if (info instanceof FileInfo) {
                info = ((FileInfo)info).loadInfo(proxy);
            }
            if (info != null) {
                SolverInfo.setCached(this.getUniqueId(), info);
            }
            return info;
        }
        catch (Exception e) {
            Debug.warning("Failed to retrieve info: " + e.getMessage());
            return null;
        }
    }

    public String generateId() {
        throw new RuntimeException("This should never happen.");
    }

    public void setInfo(TimetableInfo info) {
        this.setInfo(info, TimetableInfoUtil.getInstance());
    }

    public void setInfo(TimetableInfo info, TimetableInfoFileProxy proxy) {
        if (info.saveToFile()) {
            FileInfo fInfo = new FileInfo();
            String defName = null;
            if (this.getDefinition() != null) {
                defName = this.getDefinition().getName();
            } else {
                defName = info.getClass().getName();
                if (defName.indexOf(46) >= 0) {
                    defName = defName.substring(defName.lastIndexOf(46) + 1);
                }
            }
            fInfo.setName(defName + "_" + this.generateId() + ".zxml");
            fInfo.saveInfo(info, proxy);
            info = fInfo;
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(info.getClass().getName());
        info.save(root);
        this.setValue(document);
        SolverInfo.setCached(this.getUniqueId(), info);
    }

    public void delete(Session hibSession) throws Exception {
        this.delete(hibSession, TimetableInfoUtil.getInstance());
    }

    public void delete(Session hibSession, TimetableInfoFileProxy proxy) throws Exception {
        if (this.getData() != null) {
            Element root = this.getValue().getRootElement();
            Class<?> infoClass = null;
            try {
                infoClass = Class.forName(root.getName());
            }
            catch (ClassNotFoundException ex) {
                infoClass = Class.forName(this.getDefinition().getImplementation());
            }
            TimetableInfo info = (TimetableInfo)infoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (info instanceof FileInfo) {
                info.load(root);
                ((FileInfo)info).deleteFile(proxy);
            }
        }
        SolverInfo.removeCached(this.getUniqueId());
        hibSession.remove((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimetableInfo getCached(Long uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        Hashtable hashtable = sInfoCache;
        synchronized (hashtable) {
            CachedTimetableInfo cInfo = (CachedTimetableInfo)sInfoCache.get(uniqueId);
            if (cInfo == null) {
                return null;
            }
            cInfo.mark();
            return cInfo.getInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCached(Long uniqueId, TimetableInfo info) {
        if (uniqueId == null) {
            return;
        }
        Hashtable hashtable = sInfoCache;
        synchronized (hashtable) {
            sInfoCache.put(uniqueId, new CachedTimetableInfo(info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCached(Long uniqueId) {
        if (uniqueId == null) {
            return;
        }
        Hashtable hashtable = sInfoCache;
        synchronized (hashtable) {
            sInfoCache.remove(uniqueId);
        }
    }

    public static void stopInfoCacheCleanup() {
        sInfoCache = null;
        if (sCleanupThread != null && sCleanupThread.isAlive()) {
            sCleanupThread.interrupt();
        }
    }

    @Transient
    public Document getValue() {
        try {
            SAXReader reader = new SAXReader();
            GZIPInputStream gzipInput = new GZIPInputStream(new ByteArrayInputStream(this.getData()));
            Document document = reader.read((InputStream)gzipInput);
            gzipInput.close();
            return document;
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    public void setValue(Document document) {
        try {
            if (document == null) {
                this.setData(null);
            } else {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)new GZIPOutputStream(bytes), OutputFormat.createCompactFormat());
                writer.write(document);
                writer.flush();
                writer.close();
                this.setData(bytes.toByteArray());
            }
        }
        catch (IOException e) {
            throw new HibernateException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        sInfoCache = new Hashtable();
        sCleanupThread = new InfoCacheCleanup();
        sCleanupThread.start();
    }

    protected static class CachedTimetableInfo {
        private TimetableInfo iInfo = null;
        private long iTimeStamp = System.currentTimeMillis();

        public CachedTimetableInfo(TimetableInfo info) {
            this.iInfo = info;
        }

        @Transient
        public TimetableInfo getInfo() {
            return this.iInfo;
        }

        @Transient
        public long getAge() {
            return System.currentTimeMillis() - this.iTimeStamp;
        }

        public void mark() {
            this.iTimeStamp = System.currentTimeMillis();
        }
    }

    protected static class InfoCacheCleanup
    extends Thread {
        public InfoCacheCleanup() {
            this.setDaemon(true);
            this.setName("InfoCacheCleanup");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Debug.info("InfoCache cleanup thread started.");
            try {
                while (true) {
                    InfoCacheCleanup.sleep(sInfoCacheCleanupInterval);
                    if (sInfoCache == null) {
                        return;
                    }
                    Hashtable hashtable = sInfoCache;
                    synchronized (hashtable) {
                        if (sInfoCache.isEmpty()) {
                            continue;
                        }
                        Iterator i = sInfoCache.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            CachedTimetableInfo cInfo = (CachedTimetableInfo)entry.getValue();
                            if (cInfo.getAge() <= sInfoCacheTimeToLive) continue;
                            i.remove();
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                Debug.info("InfoCache cleanup thread interrupted.");
                Debug.info("InfoCache cleanup thread finished.");
                return;
            }
        }
    }
}

