/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.base.BaseSettings;
import org.unitime.timetable.model.dao.SettingsDAO;
import org.unitime.timetable.model.dao._RootDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="settings")
public class Settings
extends BaseSettings {
    private static final long serialVersionUID = 1L;

    public Settings() {
    }

    public Settings(Long uniqueId) {
        super(uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSettingValue(String currRole, Set uSettings, Long keyId, String defaultValue) {
        String[] data = new String[]{"-1", defaultValue};
        if (uSettings == null) {
            return data;
        }
        Session hibSession = null;
        try {
            _RootDAO rootDao = new _RootDAO();
            hibSession = rootDao.getSession();
            for (ManagerSettings mgrSettings : uSettings) {
                hibSession.merge((Object)mgrSettings);
                if (mgrSettings.getKey().getUniqueId().intValue() != keyId.intValue()) continue;
                data[0] = mgrSettings.getUniqueId().toString();
                data[1] = mgrSettings.getValue();
            }
        }
        catch (Exception ex) {
            Debug.error(ex);
        }
        return data;
    }

    public static Settings getSetting(String key) {
        return (Settings)SettingsDAO.getInstance().getSession().createQuery("from Settings where key = :key", Settings.class).setParameter("key", (Object)key).setCacheable(true).setMaxResults(1).uniqueResult();
    }
}

