/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.base.BaseRoomType;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.RoomTypeOptionDAO;

@Entity
@Table(name="room_type")
public class RoomType
extends BaseRoomType
implements Comparable<RoomType> {
    private static final long serialVersionUID = 1L;

    public RoomType() {
    }

    public RoomType(Long uniqueId) {
        super(uniqueId);
    }

    public static TreeSet<RoomType> findAll() {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().findAll());
    }

    public static TreeSet<RoomType> findAll(Long sessionId) {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().getSession().createQuery("select distinct t from Location l inner join l.roomType t where l.session.uniqueId = :sessionId", RoomType.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static TreeSet<RoomType> findAll(boolean isRoom) {
        return new TreeSet<RoomType>(RoomTypeDAO.getInstance().getSession().createQuery("from RoomType where room = :isRoom", RoomType.class).setParameter("isRoom", (Object)isRoom).setCacheable(true).list());
    }

    public static RoomType findByReference(String ref) {
        return (RoomType)RoomTypeDAO.getInstance().getSession().createQuery("from RoomType where reference = :ref", RoomType.class).setParameter("ref", (Object)ref).setCacheable(true).uniqueResult();
    }

    @Override
    public int compareTo(RoomType t) {
        int cmp = this.getOrd().compareTo(t.getOrd());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getLabel().compareTo(t.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(t.getUniqueId() == null ? -1L : t.getUniqueId());
    }

    public RoomTypeOption getOption(Department department) {
        if (department == null) {
            RoomTypeOption opt = new RoomTypeOption(this, department);
            opt.setStatus(RoomTypeOption.getDefaultStatus());
            opt.setBreakTime(ApplicationProperty.RoomDefaultBreakTime.intValue(this.getReference()));
            return opt;
        }
        RoomTypeOption opt = (RoomTypeOption)RoomTypeOptionDAO.getInstance().getSession().createQuery("from RoomTypeOption where department.uniqueId = :departmentId and roomType.uniqueId = :roomTypeId", RoomTypeOption.class).setParameter("departmentId", (Object)department.getUniqueId()).setParameter("roomTypeId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult();
        if (opt == null) {
            opt = new RoomTypeOption(this, department);
        }
        if (opt.getStatus() == null) {
            opt.setStatus(RoomTypeOption.getDefaultStatus());
        }
        if (opt.getBreakTime() == null) {
            opt.setBreakTime(ApplicationProperty.RoomDefaultBreakTime.intValue(this.getReference()));
        }
        return opt;
    }

    @Deprecated
    public boolean canScheduleEvents(Long sessionId) {
        boolean ret = false;
        for (RoomTypeOption option : RoomTypeDAO.getInstance().getSession().createQuery("select distinct o from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r, RoomTypeOption o where r.roomType.uniqueId = :roomTypeId and r.session.uniqueId = :sessionId and r.eventDepartment.allowEvents = true and r.eventDepartment = o.department and r.roomType = o.roomType", RoomTypeOption.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            if (!option.canScheduleEvents()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int countRooms() {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(distinct r.permanentId) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId", Number.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue();
    }

    public int countRooms(Long sessionId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId", Number.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).intValue();
    }

    public int countManagableRooms() {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(distinct r.permanentId) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId and r.eventDepartment.allowEvents = true", Number.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).intValue();
    }

    public List<Location> getManagableRooms(Long sessionId) {
        return RoomTypeDAO.getInstance().getSession().createQuery("select r from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId and r.eventDepartment.allowEvents = true", Location.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public int countManagableRooms(Long sessionId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from " + (this.isRoom() != false ? "Room" : "NonUniversityLocation") + " r where r.roomType.uniqueId=:roomTypeId and r.session.uniqueId=:sessionId and r.eventDepartment.allowEvents = true", Number.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).intValue();
    }

    public int countManagableRoomsOfBuilding(Long buildingId) {
        return ((Number)RoomTypeDAO.getInstance().getSession().createQuery("select count(r) from Room r where r.roomType.uniqueId=:roomTypeId and r.building.uniqueId=:buildingId and r.eventDepartment.allowEvents = true", Number.class).setParameter("roomTypeId", (Object)this.getUniqueId()).setParameter("buildingId", (Object)buildingId).setCacheable(true).uniqueResult()).intValue();
    }
}

