/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseRoles;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.security.rights.HasRights;
import org.unitime.timetable.security.rights.Right;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="roles")
public class Roles
extends BaseRoles
implements HasRights,
Comparable<Roles> {
    private static final long serialVersionUID = 3256722879445154100L;
    public static final String ROLE_STUDENT = "Student";
    public static final String ROLE_INSTRUCTOR = "Instructor";
    public static final String ROLE_NONE = "No Role";
    public static final String ROLE_ANONYMOUS = "Anonymous";
    public static String USER_ROLES_ATTR_NAME = "userRoles";
    public static String ROLES_ATTR_NAME = "rolesList";

    public Roles() {
    }

    public Roles(Long roleId) {
        super(roleId);
    }

    public static Roles getRole(String roleRef, Session hibSession) {
        return (Roles)hibSession.createQuery("from Roles where reference = :reference", Roles.class).setParameter("reference", (Object)roleRef).setCacheable(true).uniqueResult();
    }

    @Override
    public boolean hasRight(Right right) {
        return this.getRights().contains(right.name());
    }

    @Transient
    public Long getUniqueId() {
        return this.getRoleId();
    }

    @Transient
    public boolean isUsed() {
        return ((Number)RolesDAO.getInstance().getSession().createQuery("select count(m) from ManagerRole m where m.role.roleId = :roleId", Number.class).setParameter("roleId", (Object)this.getRoleId()).uniqueResult()).intValue() > 0;
    }

    public static Set<Roles> findAll(boolean managerOnly) {
        return Roles.findAll(managerOnly, RolesDAO.getInstance().getSession());
    }

    public static Set<Roles> findAll(boolean managerOnly, Session hibSession) {
        if (managerOnly) {
            return new TreeSet<Roles>(hibSession.createQuery("from Roles where manager = true", Roles.class).setCacheable(true).list());
        }
        return new TreeSet<Roles>(hibSession.createQuery("from Roles", Roles.class).setCacheable(true).list());
    }

    public static Set<Roles> findAllInstructorRoles() {
        return Roles.findAllInstructorRoles(RolesDAO.getInstance().getSession());
    }

    public static Set<Roles> findAllInstructorRoles(Session hibSession) {
        return new TreeSet<Roles>(hibSession.createQuery("from Roles where instructor = true", Roles.class).setCacheable(true).list());
    }

    @Override
    public int compareTo(Roles o) {
        if (this.isManager() != o.isManager()) {
            return this.isManager() != false ? 1 : -1;
        }
        if (this.getRights().size() != o.getRights().size()) {
            return this.getRights().size() < o.getRights().size() ? -1 : 1;
        }
        return this.getAbbv().compareToIgnoreCase(o.getAbbv());
    }
}

