/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseExternalBuilding;
import org.unitime.timetable.model.dao.ExternalBuildingDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="external_building")
public class ExternalBuilding
extends BaseExternalBuilding {
    private static final long serialVersionUID = 1L;

    public ExternalBuilding() {
    }

    public ExternalBuilding(Long uniqueId) {
        super(uniqueId);
    }

    public static Map<String, ExternalBuilding> getBuildings(Long sessionId) {
        List bldgs = ExternalBuildingDAO.getInstance().getSession().createQuery("from ExternalBuilding as b where b.session.uniqueId = " + sessionId, ExternalBuilding.class).list();
        HashMap<String, ExternalBuilding> buildings = new HashMap<String, ExternalBuilding>((int)((double)bldgs.size() * 1.25));
        for (ExternalBuilding bldg : bldgs) {
            buildings.put(bldg.getExternalUniqueId(), bldg);
        }
        return buildings;
    }

    public static ExternalBuilding findExternalBuildingForSession(String externalUniqueId, Session session) {
        return (ExternalBuilding)ExternalBuildingDAO.getInstance().getSession().createQuery("from ExternalBuilding where externalUniqueId = :externalId and session.uniqueId = :sessionId", ExternalBuilding.class).setParameter("externalId", (Object)externalUniqueId).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static ExternalBuilding findByAbbv(Long sessionId, String bldgAbbr) {
        return (ExternalBuilding)ExternalBuildingDAO.getInstance().getSession().createQuery("from ExternalBuilding where abbreviation = :bldgAbbr and session.uniqueId = :sessionId", ExternalBuilding.class).setParameter("bldgAbbr", (Object)bldgAbbr).setParameter("sessionId", (Object)sessionId).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public ExternalRoom findRoom(String roomNbr) {
        ExternalRoom room = null;
        for (ExternalRoom rm : this.getRooms()) {
            if (!roomNbr.trim().equalsIgnoreCase(rm.getRoomNumber().trim())) continue;
            room = rm;
            break;
        }
        return room;
    }
}

