/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseCourseReservation;

@Entity
@DiscriminatorValue(value="3")
public class CourseReservation
extends BaseCourseReservation {
    private static final long serialVersionUID = -1024840740051802430L;

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        return request.getCourseOffering().equals(this.getCourse());
    }

    @Override
    @Transient
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityCourse.intValue();
    }

    @Override
    @Transient
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitCourse.isTrue();
    }

    @Override
    @Transient
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedCourse.isTrue();
    }

    @Override
    @Transient
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapCourse.isTrue();
    }
}

