/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Iterator;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseCourseCatalog;
import org.unitime.timetable.model.dao.SubjectAreaDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="course_catalog")
public class CourseCatalog
extends BaseCourseCatalog {
    private static final long serialVersionUID = 1L;

    public CourseCatalog() {
    }

    public CourseCatalog(Long uniqueId) {
        super(uniqueId);
    }

    public static CourseCatalog findCourseFromPreviousSessionInCatalogForSession(CourseOffering courseOffering, Session session) {
        List l;
        if (courseOffering == null || session == null) {
            return null;
        }
        Object query = "select distinct cc from CourseCatalog cc";
        query = (String)query + " where cc.session.uniqueId=:sessionId";
        query = (String)query + "  and ((cc.subject=:subjectAbbv";
        query = (String)query + "    and cc.courseNumber=:courseNbr";
        query = (String)query + "    and (cc.previousSubject is null or cc.previousSubject = cc.subject)";
        query = (String)query + "    and (cc.previousCourseNumber is null or cc.previousCourseNumber = cc.courseNumber))";
        query = (String)query + "   or (cc.previousSubject=:subjectAbbv";
        query = (String)query + "    and cc.previousCourseNumber=:courseNbr))";
        if (courseOffering.getPermId() != null && Integer.parseInt(courseOffering.getPermId()) > 0) {
            query = (String)query + "  and cc.permanentId = '" + courseOffering.getPermId() + "'";
        }
        if ((l = SubjectAreaDAO.getInstance().getSession().createQuery((String)query, CourseCatalog.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("subjectAbbv", (Object)courseOffering.getSubjectAreaAbbv()).setParameter("courseNbr", (Object)courseOffering.getCourseNbr()).list()) != null && l.size() == 1) {
            return (CourseCatalog)l.get(0);
        }
        if (l != null && l.size() > 1) {
            CourseCatalog cc = null;
            boolean found = false;
            Iterator ccIt = l.iterator();
            while (ccIt.hasNext() && !found) {
                cc = (CourseCatalog)ccIt.next();
                if (cc.getPreviousSubject().equals(courseOffering.getSubjectAreaAbbv()) && cc.getPreviousCourseNumber().equals(courseOffering.getCourseNbr())) {
                    found = true;
                    continue;
                }
                if (cc.getPermanentId() == null || courseOffering.getPermId() == null || !cc.getPermanentId().equals(courseOffering.getPermId())) continue;
                found = true;
            }
            if (found) {
                return cc;
            }
        }
        return null;
    }

    public static CourseCatalog findCourseInCatalogForSession(CourseOffering courseOffering, Session session) {
        if (courseOffering == null || session == null) {
            return null;
        }
        Object query = "select distinct cc.* from CourseCatalog cc";
        query = (String)query + " where cc.session.uniqueId=:sessionId";
        query = (String)query + "  and cc.subject=:subjectAbbv";
        query = (String)query + "  and cc.courseNumber=:courseNbr";
        List l = SubjectAreaDAO.getInstance().getSession().createQuery((String)query, CourseCatalog.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("subjectAbbv", (Object)courseOffering.getSubjectAreaAbbv()).setParameter("courseNbr", (Object)courseOffering.getCourseNbr()).list();
        if (l != null && l.size() == 1) {
            return (CourseCatalog)l.get(0);
        }
        if (l != null && l.size() > 1) {
            CourseCatalog cc = null;
            boolean found = false;
            Iterator ccIt = l.iterator();
            while (ccIt.hasNext() && !found) {
                cc = (CourseCatalog)ccIt.next();
                if (!cc.getSubject().equals(courseOffering.getSubjectAreaAbbv()) || !cc.getCourseNumber().equals(courseOffering.getCourseNbr())) continue;
                found = true;
            }
            if (found) {
                return cc;
            }
        }
        return null;
    }
}

