/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseBuildingPref;

@Entity
@Table(name="building_pref")
public class BuildingPref
extends BaseBuildingPref {
    private static final long serialVersionUID = 1L;

    public BuildingPref() {
    }

    public BuildingPref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        Object ret = this.getBuilding().getAbbreviation();
        if (this.getRoomIndex() != null) {
            ret = (String)ret + " (" + MSG.itemOnlyRoom(1 + this.getRoomIndex()) + ")";
        }
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        try {
            BuildingPref p = (BuildingPref)o;
            int cmp = Integer.compare(this.getRoomIndex() == null ? -1 : this.getRoomIndex(), p.getRoomIndex() == null ? -1 : p.getRoomIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getBuilding().getAbbreviation().compareTo(p.getBuilding().getAbbreviation());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    @Override
    public Object clone() {
        BuildingPref pref = new BuildingPref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setBuilding(this.getBuilding());
        pref.setRoomIndex(this.getRoomIndex());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof BuildingPref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getBuilding(), (Object)((BuildingPref)other).getBuilding()) && ToolBox.equals((Object)this.getRoomIndex(), (Object)((BuildingPref)other).getRoomIndex());
    }

    @Override
    public boolean isSame(Preference other, PreferenceGroup level) {
        if (other == null || !(other instanceof BuildingPref)) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getBuilding(), (Object)((BuildingPref)other).getBuilding())) {
            return false;
        }
        if (!(level == null || !(level instanceof Class_) || ((Class_)level).getNbrRooms() != 1 || this.getRoomIndex() != null && this.getRoomIndex() != 0 || ((BuildingPref)other).getRoomIndex() != null && ((BuildingPref)other).getRoomIndex() != 0)) {
            return true;
        }
        return ToolBox.equals((Object)this.getRoomIndex(), (Object)((BuildingPref)other).getRoomIndex());
    }

    @Override
    public String preferenceHtml(String nameFormat, boolean highlightClassPrefs) {
        StringBuffer sb = new StringBuffer("<span ");
        Object style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = (String)style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && highlightClassPrefs) {
            style = (String)style + "background: #ffa;";
        }
        sb.append("style='" + (String)style + "' ");
        Object owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = " (" + MSG.prefOwnerClass() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = " (" + MSG.prefOwnerSchedulingSubpart() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = " (" + MSG.prefOwnerInstructor() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = " (" + MSG.prefOwnerExamination() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = " (" + MSG.prefOwnerDepartment() + ")";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = " (" + MSG.prefOwnerSession() + ")";
        }
        sb.append("onmouseover=\"showGwtRoomHint(this, '-" + this.getBuilding().getUniqueId() + "', '" + this.getPrefLevel().getPrefName() + " " + MSG.prefBuilding() + " {0}" + (String)owner + "');\" onmouseout=\"hideGwtRoomHint();\">");
        sb.append(this.preferenceAbbv());
        sb.append("</span>");
        return sb.toString();
    }

    @Override
    public String preferenceTitle() {
        return MSG.prefTitleBuilding(this.getPrefLevel().getPrefName(), this.getBuilding().getName());
    }

    @Override
    @Transient
    public Preference.Type getType() {
        return Preference.Type.BUILDING;
    }

    @Override
    public boolean appliesTo(PreferenceGroup group) {
        if (!super.appliesTo(group)) {
            return false;
        }
        if (this.getRoomIndex() != null && group instanceof Class_) {
            return this.getRoomIndex() < ((Class_)group).getNbrRooms();
        }
        if (this.getRoomIndex() != null && group instanceof SchedulingSubpart) {
            return this.getRoomIndex() < ((SchedulingSubpart)group).getMaxRooms();
        }
        return true;
    }
}

