/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.interfaces;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.unitime.timetable.defaults.ApplicationProperty;

public interface RoomAvailabilityInterface {
    public static final String sMidtermExamType = ApplicationProperty.RoomAvailabilityMidtermExamType.value();
    public static final String sFinalExamType = ApplicationProperty.RoomAvailabilityFinalExamType.value();
    public static final String sClassType = ApplicationProperty.RoomAvailabilityClassType.value();

    public String getTimeStamp(Date var1, Date var2, String var3);

    public Collection<TimeBlock> getRoomAvailability(Long var1, Date var2, Date var3, String var4);

    public Collection<TimeBlock> getInstructorAvailability(Long var1, Date var2, Date var3, String var4);

    public void activate(Long var1, Date var2, Date var3, String var4, boolean var5);

    public void startService();

    public void stopService();

    public static class TimeBlockComparator
    implements Comparator<TimeBlock> {
        @Override
        public int compare(TimeBlock t1, TimeBlock t2) {
            int cmp = t1.getEventName().compareToIgnoreCase(t2.getEventName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = t1.getEventType().compareToIgnoreCase(t2.getEventType());
            if (cmp != 0) {
                return cmp;
            }
            cmp = t1.getStartTime().compareTo(t2.getStartTime());
            if (cmp != 0) {
                return cmp;
            }
            return t1.getEndTime().compareTo(t2.getEndTime());
        }
    }

    public static interface HasRoom
    extends Serializable {
        public Long getLocationId();

        public Long getPermanentId();

        public String getLabel();

        public Double getCoordinateX();

        public Double getCoordinateY();

        public boolean isIgnoreTooFar();

        public boolean isIgnoreRoomCheck();
    }

    public static interface TimeBlock
    extends Serializable {
        public Long getEventId();

        public String getEventName();

        public String getEventType();

        public Date getStartTime();

        public Date getEndTime();
    }
}

