/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class PatternServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SessionContext context = this.getSessionContext();
        boolean vertical = true;
        vertical = request.getParameter("v") != null ? "1".equals(request.getParameter("v")) : (request.getParameter("c") != null ? "0".equals(request.getParameter("c").split("\\|")[5]) : CommonValues.VerticalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
        RequiredTimeTable rtt = null;
        if (request.getParameter("tp") != null) {
            TimePattern p = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(request.getParameter("tp")));
            if (p != null) {
                TimeLocation t = null;
                if (request.getParameter("as") != null && request.getParameter("ad") != null) {
                    t = new TimeLocation(Integer.parseInt(request.getParameter("ad")), Integer.parseInt(request.getParameter("as")), 1, 0, 0.0, null, null, null, 0);
                }
                rtt = new RequiredTimeTable(p.getTimePatternModel(t, true));
            }
        } else if (request.getParameter("loc") != null) {
            Location location = (Location)LocationDAO.getInstance().get(Long.valueOf(request.getParameter("loc")));
            if (location != null) {
                if (request.getParameter("xt") != null) {
                    PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), Long.valueOf(request.getParameter("xt")));
                    px.load(location);
                    rtt = new RequiredTimeTable(px);
                } else {
                    rtt = "1".equals(request.getParameter("e")) ? location.getEventAvailabilityTable() : location.getRoomSharingTable();
                }
            }
        } else if (request.getParameter("x") != null) {
            Exam exam = (Exam)ExamDAO.getInstance().get(Long.valueOf(request.getParameter("x")));
            if (exam != null) {
                ExamPeriod p = null;
                if (request.getParameter("ap") != null) {
                    p = (ExamPeriod)ExamPeriodDAO.getInstance().get(Long.valueOf(request.getParameter("ap")));
                }
                PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), p, exam.getExamType().getUniqueId());
                px.load(exam);
                rtt = new RequiredTimeTable(px);
            }
        } else {
            rtt = new RequiredTimeTable(new TimePattern().getTimePatternModel());
        }
        if (request.getParameter("pref") != null) {
            rtt.getModel().setPreferences(request.getParameter("pref"));
        }
        if (rtt != null) {
            if (request.getParameter("d") != null) {
                Department d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(request.getParameter("d")));
                String tp = ApplicationProperty.InstructorSurveyTimePreferencesDept.value(d.getDeptCode());
                if (tp == null) {
                    tp = ApplicationProperty.InstructorSurveyTimePreferences.value();
                }
                ((TimePatternModel)rtt.getModel()).setMode("|" + tp);
            } else if (request.getParameter("s") != null) {
                rtt.getModel().setDefaultSelection(request.getParameter("s"));
            } else {
                String defaultGridSize = RequiredTimeTable.getTimeGridSize(context.getUser());
                if (defaultGridSize != null) {
                    rtt.getModel().setDefaultSelection(defaultGridSize);
                }
            }
            if (request.getParameter("p") != null) {
                rtt.getModel().setPreferences(request.getParameter("p"));
            }
            boolean hc = "1".equals(request.getParameter("hc"));
            response.setContentType("image/png");
            response.setHeader("Content-Disposition", "attachment; filename=\"pattern.png\"");
            BufferedImage image = rtt.createBufferedImage(vertical, hc);
            if (image != null) {
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
            }
        }
    }
}

