/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.services.LimitAndProjectionSnapshotService;
import org.unitime.timetable.gwt.shared.LimitAndProjectionSnapshotException;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.util.PopulateProjectedDemandSnapshotData;

@Service(value="snapshot.gwt")
public class LimitAndProjectionSnapshotServlet
implements LimitAndProjectionSnapshotService {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    private SessionContext sessionContext;

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private Long getAcademicSessionId() throws PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? "Your timetabling session has expired. Please log in again." : "Login is required to use this page.");
        }
        if (user.getCurrentAuthority() == null) {
            throw new PageAccessException("Insufficient user privileges.");
        }
        Long sessionId = user.getCurrentAcademicSessionId();
        if (sessionId == null) {
            throw new PageAccessException("No academic session is selecgted.");
        }
        return sessionId;
    }

    @Override
    @PreAuthorize(value="checkPermission('LimitAndProjectionSnapshotSave')")
    public Boolean canTakeSnapshot() throws LimitAndProjectionSnapshotException, PageAccessException {
        return true;
    }

    @Override
    public Date getCurrentSnapshotDate() throws LimitAndProjectionSnapshotException, PageAccessException {
        Session session = null;
        if (this.getAcademicSessionId() != null) {
            session = (Session)SessionDAO.getInstance().get(this.getAcademicSessionId());
        } else if (this.sessionContext.getUser() != null && this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
            session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        return session.getCurrentSnapshotDate();
    }

    @Override
    public Date takeSnapshot() throws LimitAndProjectionSnapshotException, PageAccessException {
        Session session = null;
        Date snapshotDate = null;
        if (this.getAcademicSessionId() != null) {
            session = (Session)SessionDAO.getInstance().get(this.getAcademicSessionId());
        }
        if (session != null) {
            PopulateProjectedDemandSnapshotData ppdsd = new PopulateProjectedDemandSnapshotData();
            snapshotDate = ppdsd.populateProjectedDemandDataFor(session);
        }
        return snapshotDate;
    }
}

