/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;
import org.unitime.timetable.gwt.client.widgets.IntervalSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

public class WeekSelector
extends IntervalSelector<EventInterface.WeekInterface> {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private RegExp[] iRegExp = new RegExp[]{RegExp.compile((String)"^[^0-9]*([0-9]+)[/ ]*([0-9]*)[ -]*([0-9]*)[/ ]*([0-9]*)$"), RegExp.compile((String)"^[^0-9]*([0-9]+)\\.?([0-9]*)\\.?[ -]*([0-9]*)\\.?([0-9]*)\\.?$")};
    private AcademicSessionProvider iAcademicSession;

    public WeekSelector(AcademicSessionProvider session) {
        super(true);
        this.iAcademicSession = session;
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                WeekSelector.this.init(WeekSelector.this.iAcademicSession.getAcademicSessionId());
            }
        });
        session.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                WeekSelector.this.init(event.getNewAcademicSessionId());
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<IntervalSelector.Interval>(){

            public void onValueChange(ValueChangeEvent<IntervalSelector.Interval> event) {
                WeekSelector.this.setAriaLabel(ARIA.weekSelection(WeekSelector.this.toAriaString()));
            }
        });
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                WeekSelector.this.setAriaLabel(ARIA.weekSelection(WeekSelector.this.toAriaString()));
            }
        });
    }

    public void init(Long sessionId) {
        if (sessionId == null) {
            this.setHint("No academic session is selected.");
        } else {
            this.setHint("Loading data for " + this.iAcademicSession.getAcademicSessionName() + " ...");
            RPC.execute(new WeekSelectorRequest(sessionId), new AsyncCallback<GwtRpcResponseList<EventInterface.WeekInterface>>(){

                public void onFailure(Throwable caught) {
                    WeekSelector.this.setErrorHint(caught.getMessage());
                }

                public void onSuccess(GwtRpcResponseList<EventInterface.WeekInterface> result) {
                    WeekSelector.this.clearHint();
                    WeekSelector.this.setValues(result);
                    WeekSelector.this.setDefaultValue(new IntervalSelector.Interval());
                    WeekSelector.this.setValue(WeekSelector.this.getDefaultValue());
                }
            });
        }
    }

    @Override
    public IntervalSelector.Interval parse(String query) {
        if (query == null || this.getValues() == null) {
            return new IntervalSelector.Interval();
        }
        if ("today".equalsIgnoreCase(query)) {
            Date today = new Date();
            int m1 = Integer.parseInt(DateTimeFormat.getFormat((String)"MM").format(today));
            int d1 = Integer.parseInt(DateTimeFormat.getFormat((String)"dd").format(today));
            EventInterface.WeekInterface first = this.find(m1, d1, null);
            return new IntervalSelector.Interval(first, null);
        }
        MatchResult match = this.iRegExp[0].exec(query);
        if (match != null) {
            int d2;
            int m1 = Integer.parseInt(match.getGroup(1));
            int d1 = match.getGroup(2).isEmpty() ? 1 : Integer.parseInt(match.getGroup(2));
            EventInterface.WeekInterface first = this.find(m1, d1, null);
            int m2 = match.getGroup(3).isEmpty() ? -1 : Integer.parseInt(match.getGroup(3));
            int n = d2 = match.getGroup(4).isEmpty() ? 1 : Integer.parseInt(match.getGroup(4));
            if (m2 == m1 && d2 < d1) {
                d2 = d1;
            }
            EventInterface.WeekInterface last = match.getGroup(3).isEmpty() ? null : this.find(m2, d2, first);
            return new IntervalSelector.Interval(first, last);
        }
        match = this.iRegExp[1].exec(query);
        if (match != null) {
            int m2;
            int d1 = Integer.parseInt(match.getGroup(1));
            int m1 = match.getGroup(2).isEmpty() ? -1 : Integer.parseInt(match.getGroup(2));
            EventInterface.WeekInterface first = this.find(m1, d1, null);
            int d2 = match.getGroup(3).isEmpty() ? 1 : Integer.parseInt(match.getGroup(3));
            int n = m2 = match.getGroup(4).isEmpty() ? -1 : Integer.parseInt(match.getGroup(4));
            if (m2 == m1 && d2 < d1) {
                d2 = d1;
            }
            EventInterface.WeekInterface last = match.getGroup(3).isEmpty() ? null : this.find(m2, d2, first);
            return new IntervalSelector.Interval(first, last);
        }
        return new IntervalSelector.Interval();
    }

    public EventInterface.WeekInterface find(int month, int day, EventInterface.WeekInterface after) {
        EventInterface.WeekInterface first = null;
        for (EventInterface.WeekInterface w : this.getValues()) {
            if (after != null && w.getDayOfYear() < after.getDayOfYear()) continue;
            if (first == null) {
                first = w;
            }
            for (EventInterface.DateInterface dayName : w.getDayNames()) {
                if (dayName.getMonth() != month || dayName.getDay() != day) continue;
                return w;
            }
        }
        EventInterface.DateInterface firstDay = ((EventInterface.WeekInterface)this.getValues().get(0)).getDayNames().get(0);
        return month < firstDay.getMonth() || firstDay.getMonth() == month && day < firstDay.getDay() ? (first == null ? (EventInterface.WeekInterface)this.getValues().get(0) : first) : (EventInterface.WeekInterface)this.getValues().get(this.getValues().size() - 1);
    }

    @Override
    public String getDisplayString(IntervalSelector.Interval interval) {
        if (interval.isAll()) {
            return interval.isEnableFilter() ? MESSAGES.itemAllWeeksWithFilter() : MESSAGES.itemAllWeeks();
        }
        if (interval.isOne()) {
            return MESSAGES.itemWeek(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(0).getLabel(), ((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().size() - 1).getLabel());
        }
        return "&nbsp;&nbsp;&nbsp;" + String.valueOf(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(0)) + " - " + String.valueOf(((EventInterface.WeekInterface)interval.getLast()).getDayNames().get(6));
    }

    @Override
    public String getReplaceString(IntervalSelector.Interval interval) {
        if (interval.isAll()) {
            return interval.isEnableFilter() ? MESSAGES.itemAllWeeksWithFilter() : MESSAGES.itemAllWeeks();
        }
        if (interval.isOne()) {
            return MESSAGES.itemWeek(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(0).getLabel(), ((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().size() - 1).getLabel());
        }
        return MESSAGES.itemWeeks(((EventInterface.WeekInterface)interval.getFirst()).getDayNames().get(0).getLabel(), ((EventInterface.WeekInterface)interval.getLast()).getDayNames().get(6).getLabel());
    }

    public String getSelection() {
        if (this.getValue() == null || this.getValue().isAll()) {
            return "";
        }
        return this.getValue().isOne() ? ((EventInterface.WeekInterface)this.getValue().getFirst()).getDayNames().get(0).getLabel() : ((EventInterface.WeekInterface)this.getValue().getFirst()).getDayNames().get(0).getLabel() + "-" + ((EventInterface.WeekInterface)this.getValue().getLast()).getDayNames().get(6).getLabel();
    }

    public int getFirstDayOfYear() {
        if (this.getValues() == null || this.getValues().isEmpty()) {
            return 0;
        }
        return ((EventInterface.WeekInterface)this.getValues().get(0)).getDayOfYear();
    }

    public int getLastDayOfYear() {
        if (this.getValues() == null || this.getValues().isEmpty()) {
            return 0;
        }
        return ((EventInterface.WeekInterface)this.getValues().get(this.getValues().size() - 1)).getDayOfYear() + 6;
    }

    public static class WeekSelectorRequest
    implements GwtRpcRequest<GwtRpcResponseList<EventInterface.WeekInterface>> {
        private Long iSessionId;

        public WeekSelectorRequest() {
        }

        public WeekSelectorRequest(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        @Override
        public String toString() {
            return this.getSessionId().toString();
        }
    }
}

