/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.GwtConstants;

public class DayCodeSelector
extends Composite
implements HasValue<Integer>,
HasText {
    protected static GwtConstants CONST = (GwtConstants)GWT.create(GwtConstants.class);
    private P iPanel = new P("unitime-DayCodeSector");
    private List<Bit> iBits = new ArrayList<Bit>();
    protected static int[] DAY_CODES = new int[]{64, 32, 16, 8, 4, 2, 1};

    public DayCodeSelector() {
        for (int i = 0; i < CONST.days().length; ++i) {
            Bit bit = new Bit(DAY_CODES[i], CONST.days()[i]);
            this.iPanel.add((Widget)bit);
            this.iBits.add(bit);
        }
        this.initWidget((Widget)this.iPanel);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        int ret = 0;
        for (Bit bit : this.iBits) {
            if (!bit.getValue().booleanValue()) continue;
            ret += bit.value();
        }
        return ret;
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        if (value == null) {
            value = 0;
        }
        for (Bit bit : this.iBits) {
            bit.setValue((value & bit.value()) != 0);
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public String getText() {
        Integer value = this.getValue();
        return value == null ? "" : value.toString();
    }

    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.setValue(null);
        } else {
            try {
                this.setValue(Integer.parseInt(text));
            }
            catch (NumberFormatException e) {
                this.setValue(null);
            }
        }
    }

    class Bit
    extends CheckBox {
        private int iValue;

        Bit(int value, String text) {
            super(text);
            this.addStyleName("bit");
            this.iValue = value;
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> e) {
                    ValueChangeEvent.fire((HasValueChangeHandlers)DayCodeSelector.this, (Object)DayCodeSelector.this.getValue());
                }
            });
        }

        public int value() {
            return this.iValue;
        }
    }
}

