/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class CourseSelectionSuggestBox
extends P
implements CourseSelection {
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected AriaSuggestBox iSuggest;
    private SimpleSuggestion iLastSuggestion;
    protected ImageButton iFinderButton;
    private Label iError;
    private String iHint = "";
    private Map<String, CourseRequestInterface.RequestedCourse> iValidCourseNames = new HashMap<String, CourseRequestInterface.RequestedCourse>();
    private DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> iDataProvider;
    private FreeTimeParser iFreeTimeParser = null;
    private CourseFinder iCourseFinder = null;
    private CourseFinderFactory iCourseFinderFactory = null;
    private List<Validator<CourseSelection>> iValidators = new ArrayList<Validator<CourseSelection>>();
    private boolean iShowCourses = false;
    private boolean iShowDefaultSuggestions = false;
    private boolean iSaved = false;

    public CourseSelectionSuggestBox() {
        this(false, false);
    }

    public CourseSelectionSuggestBox(boolean showCourses, boolean showDefaultSuggestions) {
        super("unitime-CourseSelectionBox");
        this.iShowCourses = showCourses;
        this.iShowDefaultSuggestions = showDefaultSuggestions;
        SuggestOracle courseOfferingOracle = new SuggestOracle(){

            public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
                if (request.getQuery().equals(CourseSelectionSuggestBox.this.iHint)) {
                    return;
                }
                CourseSelectionSuggestBox.this.iDataProvider.getData(request.getQuery(), new SuggestCallback(request, callback));
            }

            public void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
                if (CourseSelectionSuggestBox.this.iShowDefaultSuggestions) {
                    CourseSelectionSuggestBox.this.iDataProvider.getData("", new SuggestCallback(request, callback));
                } else {
                    super.requestDefaultSuggestions(request, callback);
                }
            }

            public boolean isDisplayStringHTML() {
                return true;
            }
        };
        this.iSuggest = new AriaSuggestBox(courseOfferingOracle);
        this.iSuggest.setStyleName("unitime-TextBoxHint");
        this.iSuggest.addStyleName("text");
        this.add((Widget)this.iSuggest);
        this.iFinderButton = new ImageButton(RESOURCES.search_picker(), RESOURCES.search_picker_Down(), RESOURCES.search_picker_Over(), RESOURCES.search_picker_Disabled());
        this.iFinderButton.setTabIndex(-1);
        this.iFinderButton.addStyleName("button");
        this.add((Widget)this.iFinderButton);
        this.iError = new Label();
        this.iError.setStyleName("unitime-ErrorHint");
        this.iError.setVisible(false);
        Roles.getPresentationRole().setAriaHiddenState((Element)this.iError.getElement(), true);
        this.iError.addStyleName("error");
        this.add((Widget)this.iError);
        this.iFinderButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CourseSelectionSuggestBox.this.iSuggest.isEnabled()) {
                    CourseSelectionSuggestBox.this.openDialogAsync();
                }
            }
        });
        this.iSuggest.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                CourseSelectionSuggestBox.this.iLastSuggestion = (SimpleSuggestion)event.getSelectedItem();
                if (CourseSelectionSuggestBox.this.iLastSuggestion.hasRequestedCourse()) {
                    CourseSelectionEvent.fire((HasHandlers)CourseSelectionSuggestBox.this, CourseSelectionSuggestBox.this.iLastSuggestion.getRequestedCourse());
                } else {
                    CourseSelectionEvent.fire((HasHandlers)CourseSelectionSuggestBox.this, CourseSelectionSuggestBox.this.iLastSuggestion.getReplacementString());
                }
            }
        });
        this.iSuggest.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String text = CourseSelectionSuggestBox.this.iSuggest.getText();
                if (CourseSelectionSuggestBox.this.iLastSuggestion != null && text.equalsIgnoreCase(CourseSelectionSuggestBox.this.iLastSuggestion.getReplacementString()) && CourseSelectionSuggestBox.this.iLastSuggestion.hasRequestedCourse()) {
                    CourseSelectionEvent.fire((HasHandlers)CourseSelectionSuggestBox.this, CourseSelectionSuggestBox.this.iLastSuggestion.getRequestedCourse());
                } else if (CourseSelectionSuggestBox.this.iValidCourseNames.containsKey(text.toLowerCase())) {
                    CourseSelectionEvent.fire((HasHandlers)CourseSelectionSuggestBox.this, CourseSelectionSuggestBox.this.iValidCourseNames.get(text.toLowerCase()));
                } else {
                    CourseSelectionEvent.fire((HasHandlers)CourseSelectionSuggestBox.this, text);
                }
            }
        });
        this.iSuggest.getValueBox().addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (!CourseSelectionSuggestBox.this.iSuggest.isEnabled()) {
                    return;
                }
                if ((event.getNativeEvent().getKeyCode() == 70 || event.getNativeEvent().getKeyCode() == 102) && (event.isControlKeyDown() || event.isAltKeyDown())) {
                    CourseSelectionSuggestBox.this.iSuggest.hideSuggestionList();
                    CourseSelectionSuggestBox.this.openDialogAsync();
                }
                if (event.getNativeEvent().getKeyCode() == 27) {
                    CourseSelectionSuggestBox.this.iSuggest.hideSuggestionList();
                }
                if ((event.getNativeEvent().getKeyCode() == 76 || event.getNativeEvent().getKeyCode() == 108) && (event.isControlKeyDown() || event.isAltKeyDown())) {
                    CourseSelectionSuggestBox.this.iSuggest.showSuggestionList();
                }
            }
        });
        this.iSuggest.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (CourseSelectionSuggestBox.this.iSuggest.getText().isEmpty()) {
                    if (CourseSelectionSuggestBox.this.iError.isVisible()) {
                        CourseSelectionSuggestBox.this.iError.setVisible(false);
                    }
                    if (!CourseSelectionSuggestBox.this.iHint.isEmpty()) {
                        CourseSelectionSuggestBox.this.iSuggest.setText(CourseSelectionSuggestBox.this.iHint);
                        CourseSelectionSuggestBox.this.iSuggest.setStyleName("unitime-TextBoxHint");
                    }
                }
            }
        });
        this.iSuggest.getValueBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                CourseSelectionSuggestBox.this.iSuggest.setStyleName("gwt-SuggestBox");
                if (!CourseSelectionSuggestBox.this.iHint.isEmpty() && CourseSelectionSuggestBox.this.iSuggest.getText().equals(CourseSelectionSuggestBox.this.iHint)) {
                    CourseSelectionSuggestBox.this.iSuggest.setText("");
                }
                if (!CourseSelectionSuggestBox.this.iError.getText().isEmpty()) {
                    AriaStatus.getInstance().setText(CourseSelectionSuggestBox.this.iError.getText());
                }
            }
        });
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        if (this.iSuggest.getText().equals(this.iHint) || this.iSuggest.getText().trim().isEmpty()) {
            return new CourseRequestInterface.RequestedCourse();
        }
        if (this.iLastSuggestion != null && this.iLastSuggestion.hasRequestedCourse() && this.iSuggest.getText().equalsIgnoreCase(this.iLastSuggestion.getReplacementString())) {
            return this.iLastSuggestion.getRequestedCourse();
        }
        if (this.iValidCourseNames.containsKey(this.iSuggest.getText().toLowerCase())) {
            return this.iValidCourseNames.get(this.iSuggest.getText().toLowerCase().toLowerCase());
        }
        CourseRequestInterface.RequestedCourse ret = new CourseRequestInterface.RequestedCourse();
        if (this.iFreeTimeParser != null) {
            try {
                ret.setFreeTime(this.iFreeTimeParser.parseFreeTime(this.iSuggest.getText()));
            }
            catch (IllegalArgumentException e) {
                ret.setCourseName(this.iSuggest.getText());
            }
        } else {
            ret.setCourseName(this.iSuggest.getText());
        }
        if (!this.isEnabled() && ret.isCourse() && this.isSaved()) {
            ret.setReadOnly(true);
        }
        return ret;
    }

    public boolean hasValue() {
        CourseRequestInterface.RequestedCourse value = this.getValue();
        return value != null && !value.isEmpty();
    }

    @Override
    public String getText() {
        return this.iSuggest.getText().equals(this.iHint) ? "" : this.iSuggest.getText();
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false);
    }

    private void openDialogAsync() {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                CourseSelectionSuggestBox.this.openDialog();
            }

            public void onFailure(Throwable reason) {
                UniTimeNotifications.error(MESSAGES.failedToLoadTheApp(reason.getMessage()));
            }
        });
    }

    private void openDialog() {
        this.getCourseFinder().setValue(this.getValue(), true);
        this.getCourseFinder().findCourse();
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, boolean fireEvents) {
        if (value == null || value.isEmpty()) {
            this.iSaved = false;
            this.iSuggest.setText(this.iHint);
            if (!this.iHint.isEmpty()) {
                this.iSuggest.setStyleName("unitime-TextBoxHint");
            } else {
                this.iSuggest.setStyleName("gwt-SuggestBox");
            }
            this.setError(null);
        } else {
            this.iSaved = value.isReadOnly();
            this.iLastSuggestion = new SimpleSuggestion(value);
            this.iSuggest.setText(this.iLastSuggestion.getReplacementString());
            if (this.iSuggest.getText().isEmpty()) {
                if (!this.iHint.isEmpty()) {
                    this.iSuggest.setText(this.iHint);
                    this.iSuggest.setStyleName("unitime-TextBoxHint");
                } else {
                    this.iSuggest.setStyleName("gwt-SuggestBox");
                }
            } else {
                this.iSuggest.setStyleName("gwt-SuggestBox");
            }
        }
        if (fireEvents) {
            CourseSelectionEvent.fire((HasHandlers)this, value);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public void setHint(String hint) {
        if (this.iSuggest.getText().equals(this.iHint)) {
            this.iSuggest.setText(hint);
            if (!hint.isEmpty()) {
                this.iSuggest.setStyleName("unitime-TextBoxHint");
            }
        }
        this.iHint = hint;
    }

    @Override
    public String getHint() {
        return this.iHint;
    }

    public boolean isEnabled() {
        return this.iSuggest.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.iSuggest.setEnabled(true);
            this.iFinderButton.setEnabled(true);
            this.iFinderButton.setTabIndex(0);
        } else {
            this.iSuggest.setEnabled(false);
            this.iFinderButton.setEnabled(false);
            this.iFinderButton.setTabIndex(-1);
            if (this.iSaved) {
                this.iFinderButton.setFace(RESOURCES.search_picker_Assigned());
            }
        }
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
        if (!this.isEnabled()) {
            this.iFinderButton.setFace(saved ? RESOURCES.search_picker_Assigned() : RESOURCES.search_picker_Disabled());
        }
        this.iFinderButton.setTitle(saved ? MESSAGES.saved(this.iSuggest.getValue()) : this.iFinderButton.getAltText());
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    @Override
    public void setSuggestions(DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public void setFreeTimes(FreeTimeParser parser) {
        this.iFreeTimeParser = parser;
        this.iFreeTimeParser.setValidCourseNames(this.iValidCourseNames);
    }

    @Override
    public FreeTimeParser getFreeTimes() {
        return this.iFreeTimeParser;
    }

    public boolean isAllowFreeTime() {
        return this.iFreeTimeParser != null;
    }

    @Override
    public void setCourseFinderFactory(CourseFinderFactory factory) {
        this.iCourseFinderFactory = factory;
    }

    @Override
    public CourseFinder getCourseFinder() {
        if (this.iCourseFinder == null) {
            this.iCourseFinder = this.iCourseFinderFactory.createCourseFinder();
            this.iCourseFinder.addSelectionHandler((SelectionHandler)new SelectionHandler<CourseRequestInterface.RequestedCourse>(){

                public void onSelection(SelectionEvent<CourseRequestInterface.RequestedCourse> event) {
                    CourseSelectionSuggestBox.this.setValue((CourseRequestInterface.RequestedCourse)event.getSelectedItem(), true);
                }
            });
            if (this.iCourseFinder instanceof HasCloseHandlers) {
                ((HasCloseHandlers)this.iCourseFinder).addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                CourseSelectionSuggestBox.this.iSuggest.setFocus(true);
                            }
                        });
                    }
                });
            }
        }
        return this.iCourseFinder;
    }

    @Override
    public void setLabel(String title, String finderTitle) {
        this.iSuggest.setAriaLabel(title);
        this.iFinderButton.setAltText(finderTitle);
    }

    @Override
    public void hideSuggestionList() {
        this.iSuggest.hideSuggestionList();
    }

    @Override
    public void showSuggestionList() {
        this.iSuggest.showSuggestionList();
    }

    @Override
    public void setWidth(String width) {
        this.iSuggest.setWidth(width);
    }

    @Override
    public void setError(String error) {
        if (error == null || error.isEmpty()) {
            this.iError.setText("");
            this.iError.setVisible(false);
        } else {
            this.iError.setText(error);
            this.iError.setVisible(true);
            this.iSuggest.setStatus(error);
        }
    }

    @Override
    public String getError() {
        return this.iError.isVisible() ? this.iError.getText() : null;
    }

    public void setAccessKey(char a) {
        this.iSuggest.setAccessKey(a);
    }

    public int getTabIndex() {
        return this.iSuggest.getTabIndex();
    }

    public void setFocus(boolean focused) {
        this.iSuggest.setFocus(focused);
        if (focused) {
            this.iSuggest.getValueBox().selectAll();
        }
    }

    public void setTabIndex(int index) {
        this.iSuggest.setTabIndex(index);
    }

    @Override
    public HandlerRegistration addCourseSelectionHandler(CourseSelectionHandler handler) {
        return this.addHandler(handler, CourseSelectionEvent.getType());
    }

    @Override
    public void addValidator(Validator<CourseSelection> validator) {
        this.iValidators.add(validator);
    }

    @Override
    public String validate() {
        block5: {
            if (this.getValue().isEmpty()) {
                this.setError(null);
                return null;
            }
            if (this.iFreeTimeParser != null) {
                try {
                    this.iFreeTimeParser.parseFreeTime(this.iSuggest.getValue());
                    this.setError(null);
                    return null;
                }
                catch (IllegalArgumentException e) {
                    if (!this.iSuggest.getValue().toLowerCase().startsWith(CONSTANTS.freePrefix().toLowerCase())) break block5;
                    this.setError(MESSAGES.invalidFreeTime());
                    return e.getMessage();
                }
            }
        }
        for (Validator<CourseSelection> validator : this.iValidators) {
            String message = validator.validate(this);
            if (message == null) continue;
            this.setError(message);
            return message;
        }
        this.setError(null);
        return null;
    }

    public static class SimpleSuggestion
    implements SuggestOracle.Suggestion,
    AriaSuggestBox.HasStatus {
        private String iDisplay;
        private String iReplace;
        private String iStatus;
        private CourseRequestInterface.RequestedCourse iSuggestion = null;

        public SimpleSuggestion(Throwable error) {
            this.iDisplay = "<font color='red'>" + error.getMessage() + "</font>";
            this.iReplace = "";
            this.iStatus = error.getMessage();
        }

        public SimpleSuggestion(List<CourseRequestInterface.FreeTime> freeTimes) {
            this.iSuggestion = new CourseRequestInterface.RequestedCourse();
            this.iSuggestion.setFreeTime(freeTimes);
            this.iReplace = this.iDisplay = this.iSuggestion.toString(CONSTANTS);
            this.iStatus = ARIA.courseFinderSelectedFreeTime(this.iSuggestion.toAriaString(CONSTANTS));
        }

        public SimpleSuggestion(ClassAssignmentInterface.CourseAssignment suggestion, boolean showCourseTitle) {
            this.iDisplay = suggestion.hasTitle() ? MESSAGES.courseNameWithTitle(suggestion.getSubject(), suggestion.getCourseNbr(), suggestion.getTitle()) : MESSAGES.courseName(suggestion.getSubject(), suggestion.getCourseNbr());
            this.iReplace = suggestion.hasUniqueName() && !showCourseTitle ? MESSAGES.courseName(suggestion.getSubject(), suggestion.getCourseNbr()) : this.iDisplay;
            this.iStatus = MESSAGES.courseName(suggestion.getSubject(), suggestion.getCourseNbr());
            if (suggestion.hasTitle()) {
                this.iStatus = this.iStatus + " " + suggestion.getTitle();
            }
            this.iSuggestion = new CourseRequestInterface.RequestedCourse();
            this.iSuggestion.setCourseId(suggestion.getCourseId());
            this.iSuggestion.setCourseName(this.iReplace);
            this.iSuggestion.setCourseTitle(suggestion.getTitle());
            this.iSuggestion.setParentCourseId(suggestion.getParentCourseId());
        }

        public SimpleSuggestion(CourseRequestInterface.RequestedCourse course) {
            if (course.isCourse()) {
                this.iDisplay = course.getCourseName();
                this.iReplace = course.getCourseName();
                this.iStatus = course.getCourseName();
            } else if (course.isFreeTime()) {
                this.iReplace = this.iDisplay = course.toString(CONSTANTS);
                this.iStatus = ARIA.courseFinderSelectedFreeTime(course.toAriaString(CONSTANTS));
            }
            this.iSuggestion = course;
        }

        public String getDisplayString() {
            return this.iDisplay;
        }

        public String getReplacementString() {
            return this.iReplace;
        }

        @Override
        public String getStatusString() {
            return this.iStatus;
        }

        public boolean hasRequestedCourse() {
            return this.iSuggestion != null;
        }

        public CourseRequestInterface.RequestedCourse getRequestedCourse() {
            return this.iSuggestion;
        }
    }

    public class SuggestCallback
    implements AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> {
        private SuggestOracle.Request iRequest;
        private SuggestOracle.Callback iCallback;

        public SuggestCallback(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            this.iRequest = request;
            this.iCallback = callback;
        }

        public void onFailure(final Throwable caught) {
            CourseSelectionSuggestBox.this.iValidCourseNames.clear();
            final ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
            if (CourseSelectionSuggestBox.this.iFreeTimeParser != null) {
                CourseSelectionSuggestBox.this.iFreeTimeParser.getData(this.iRequest.getQuery(), new AsyncCallback<List<CourseRequestInterface.FreeTime>>(){

                    public void onFailure(Throwable e) {
                        if (SuggestCallback.this.iRequest.getQuery().toLowerCase().startsWith(CONSTANTS.freePrefix().toLowerCase())) {
                            suggestions.add(new SimpleSuggestion(e));
                        } else {
                            suggestions.add(new SimpleSuggestion(caught));
                        }
                    }

                    public void onSuccess(List<CourseRequestInterface.FreeTime> freeTimes) {
                        suggestions.add(new SimpleSuggestion(freeTimes));
                    }
                });
            } else {
                suggestions.add(new SimpleSuggestion(caught));
            }
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
        }

        public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
            ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
            CourseSelectionSuggestBox.this.iValidCourseNames.clear();
            for (ClassAssignmentInterface.CourseAssignment course : result) {
                SimpleSuggestion suggestion = new SimpleSuggestion(course, CourseSelectionSuggestBox.this.iShowCourses);
                suggestions.add(suggestion);
                CourseSelectionSuggestBox.this.iValidCourseNames.put(suggestion.getReplacementString().toLowerCase(), suggestion.getRequestedCourse());
            }
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
        }
    }
}

