/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.rooms.PeriodPreferencesWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class PeriodPreferencesHint {
    private static PeriodPreferencesWidget sSharing;
    private static Long sLastLocationId;
    private static boolean sShowHint;
    private static GwtRpcServiceAsync RPC;

    public static PeriodPreferencesWidget content(RoomInterface.PeriodPreferenceModel model) {
        if (sSharing == null) {
            sSharing = new PeriodPreferencesWidget(false);
        }
        sSharing.setModel(model);
        return sSharing;
    }

    public static void _showPeriodPreferencesHint(JavaScriptObject source, String locationId, String examTypeId) {
        PeriodPreferencesHint.showHint((Element)source.cast(), PeriodPreferencesHint.toLong(locationId), PeriodPreferencesHint.toLong(examTypeId));
    }

    public static void _showExamPeriodPreferencesHint(JavaScriptObject source, String examId, String periodId) {
        PeriodPreferencesHint.showHintForExam((Element)source.cast(), PeriodPreferencesHint.toLong(examId), PeriodPreferencesHint.toLong(periodId));
    }

    public static void showHint(final Element relativeObject, final Long locationId, Long examTypeId) {
        sLastLocationId = locationId;
        sShowHint = true;
        RPC.execute(RoomInterface.PeriodPreferenceRequest.load(locationId, examTypeId), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(RoomInterface.PeriodPreferenceModel result) {
                if (locationId.equals(sLastLocationId) && sShowHint && result != null && !result.getPeriods().isEmpty()) {
                    GwtHint.showHint(relativeObject, (Widget)PeriodPreferencesHint.content(result));
                }
            }
        });
    }

    public static void showHintForExam(final Element relativeObject, final Long examId, final Long periodId) {
        sLastLocationId = examId;
        sShowHint = true;
        RPC.execute(RoomInterface.PeriodPreferenceRequest.loadForExam(examId, null), new AsyncCallback<RoomInterface.PeriodPreferenceModel>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(RoomInterface.PeriodPreferenceModel result) {
                if (examId.equals(sLastLocationId) && sShowHint && result != null) {
                    if (periodId != null) {
                        result.setAssignedPeriodId(periodId);
                    }
                    GwtHint.showHint(relativeObject, (Widget)PeriodPreferencesHint.content(result));
                }
            }
        });
    }

    public static void hideHint() {
        sShowHint = false;
        GwtHint.hideHint();
    }

    public static native void createTriggers();

    private static Long toLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        sLastLocationId = null;
        sShowHint = false;
        RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    }
}

