/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;

public class UniTimeNavigation {
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static CourseMessages MSG = (CourseMessages)GWT.create(CourseMessages.class);
    private static UniTimeNavigation sInstance;
    private RootPanel iRootPanel = null;
    private P iNavigation = null;

    public static UniTimeNavigation getInstance() {
        if (sInstance == null) {
            sInstance = new UniTimeNavigation();
        }
        return sInstance;
    }

    public void insert(RootPanel panel) {
        this.iRootPanel = panel;
    }

    public void refresh() {
        if (this.iRootPanel == null) {
            return;
        }
        RPC.execute(new NavigationRequest(), new AsyncCallback<GwtRpcResponseList<NavigationItem>>(){

            public void onFailure(Throwable e) {
            }

            public void onSuccess(GwtRpcResponseList<NavigationItem> items) {
                if (UniTimeNavigation.this.iNavigation == null) {
                    UniTimeNavigation.this.iNavigation = new P("unitime-Navigation");
                    UniTimeNavigation.this.iRootPanel.clear();
                    UniTimeNavigation.this.iRootPanel.getElement().setInnerText(null);
                    UniTimeNavigation.this.iRootPanel.add((Widget)UniTimeNavigation.this.iNavigation);
                } else {
                    UniTimeNavigation.this.iNavigation.clear();
                }
                if (items.size() > 1) {
                    final NavigationItem backItem = (NavigationItem)items.get(items.size() - 2);
                    Button back = new Button(MSG.navigationBackButton(), new ClickHandler(){

                        public void onClick(ClickEvent evt) {
                            ToolBox.open(GWT.getHostPageBaseURL() + backItem.getUrl());
                        }
                    });
                    back.addStyleName("btn");
                    back.setTitle(MSG.navigationBackTitle(back.getText()));
                    UniTimeNavigation.this.iNavigation.add((Widget)back);
                    boolean first = true;
                    for (NavigationItem item : items) {
                        Anchor a = new Anchor(item.getTitle(), item.getUrl());
                        a.addStyleName("item");
                        if (first) {
                            a.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
                            first = false;
                        } else {
                            P next = new P((Element)DOM.createSpan(), new String[0]);
                            next.setHTML(" &rarr; ");
                            UniTimeNavigation.this.iNavigation.add((Widget)next);
                        }
                        UniTimeNavigation.this.iNavigation.add((Widget)a);
                    }
                }
            }
        });
    }

    public static class NavigationRequest
    implements GwtRpcRequest<GwtRpcResponseList<NavigationItem>> {
    }

    public static class NavigationItem
    implements GwtRpcResponse {
        String iUrl;
        String iTitle;

        public NavigationItem() {
        }

        public NavigationItem(String url, String title) {
            this.iUrl = url;
            this.iTitle = title;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String toString() {
            return this.getTitle() + " (" + this.getUrl() + ")";
        }

        public int hashCode() {
            return this.getUrl().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof NavigationItem)) {
                return false;
            }
            return this.getUrl().equals(((NavigationItem)o).getUrl());
        }
    }
}

