/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.PageFilter;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;

public class DistributionsPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private PageFilter iFilter = new PageFilter();
    private OfferingsInterface.DistributionsFilterResponse iConfig;

    public DistributionsPage() {
        this.iFilter.getHeader().setCollapsible("1".equals(ToolBox.getSessionCookie("Distributions.Filter")));
        this.iFilter.getHeader().addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ToolBox.setSessionCookie("Distributions.Filter", (Boolean)event.getValue() != false ? "1" : "0");
            }
        });
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iFilter.getFooter().addButton("search", COURSE.actionSearchDistributionPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String token = DistributionsPage.this.iFilter.getQuery();
                if (!History.getToken().equals(token)) {
                    History.newItem((String)token, (boolean)false);
                }
                DistributionsPage.this.search(null);
            }
        });
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().getButton("search").setAccessKey(COURSE.accessSearchDistributionPreferences().charAt(0));
        this.iFilter.getFooter().getButton("search").setTitle(COURSE.titleSearchDistributionPreferences(COURSE.accessSearchDistributionPreferences()));
        this.iFilter.setSubmitCommand(new Command(){

            public void execute() {
                if (DistributionsPage.this.iFilter.getFooter().isEnabled("search").booleanValue()) {
                    DistributionsPage.this.iFilter.getFooter().getButton("search").click();
                }
            }
        });
        this.iFilter.getFooter().addButton("exportCsv", COURSE.actionExportCsv(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DistributionsPage.this.export("distributions.csv");
            }
        });
        this.iFilter.getFooter().getButton("exportCsv").setAccessKey(COURSE.accessExportCsv().charAt(0));
        this.iFilter.getFooter().getButton("exportCsv").setTitle(COURSE.titleExportCsv(COURSE.accessExportCsv()));
        this.iFilter.getFooter().setEnabled("exportCsv", false);
        this.iFilter.getFooter().addButton("exportXls", COURSE.actionExportXls(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DistributionsPage.this.export("distributions.xls");
            }
        });
        this.iFilter.getFooter().getButton("exportXls").setAccessKey(COURSE.accessExportXls().charAt(0));
        this.iFilter.getFooter().getButton("exportXls").setTitle(COURSE.titleExportXls(COURSE.accessExportXls()));
        this.iFilter.getFooter().setEnabled("exportXls", false);
        this.iFilter.getFooter().addButton("exportPdf", COURSE.actionExportPdf(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DistributionsPage.this.export("distributions.pdf");
            }
        });
        this.iFilter.getFooter().getButton("exportPdf").setAccessKey(COURSE.accessExportPdf().charAt(0));
        this.iFilter.getFooter().getButton("exportPdf").setTitle(COURSE.titleExportPdf(COURSE.accessExportPdf()));
        this.iFilter.getFooter().setEnabled("exportPdf", false);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-DistributionsPage");
        this.initWidget((Widget)this.iRootPanel);
        this.init();
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String token = (String)event.getValue();
                if (((String)event.getValue()).startsWith("A") || ((String)event.getValue()).equals("back")) {
                    token = "";
                }
                DistributionsPage.this.iFilter.setQuery(token, true);
                if (DistributionsPage.this.iPanel.getRowCount() > 1) {
                    DistributionsPage.this.search(null);
                }
            }
        });
    }

    protected void init() {
        RPC.execute(new OfferingsInterface.DistributionsFilterRequest(), new AsyncCallback<OfferingsInterface.DistributionsFilterResponse>(){

            public void onFailure(Throwable caught) {
                DistributionsPage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(OfferingsInterface.DistributionsFilterResponse result) {
                DistributionsPage.this.iConfig = result;
                for (FilterInterface.FilterParameterInterface p : result.getParameters()) {
                    String v = Window.Location.getParameter((String)p.getName());
                    if (v == null) continue;
                    p.setValue(v);
                }
                DistributionsPage.this.iFilter.getFooter().clearMessage();
                DistributionsPage.this.iFilter.setValue(result);
                String token = History.getToken();
                if (token != null && !token.startsWith("A") && !token.equals("back")) {
                    DistributionsPage.this.iFilter.setQuery(token, true);
                }
                DistributionsPage.this.iFilter.getFooter().setEnabled("search", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportCsv", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportXls", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportPdf", true);
                boolean autoSearch = false;
                if (!DistributionsPage.this.iFilter.getValue().getParameterValue("subjectArea", "").isEmpty()) {
                    autoSearch = true;
                } else if (DistributionsPage.this.iConfig.getMaxSubjectsToSearchAutomatically() != null) {
                    ListBox list = (ListBox)DistributionsPage.this.iFilter.getFilterWidget("subjectArea");
                    if (list.getItemCount() <= DistributionsPage.this.iConfig.getMaxSubjectsToSearchAutomatically()) {
                        autoSearch = true;
                        for (int i = 0; i < list.getItemCount(); ++i) {
                            list.setItemSelected(i, true);
                        }
                    }
                    DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)list);
                }
                if (autoSearch) {
                    DistributionsPage.this.search(null);
                }
            }
        });
    }

    protected void search(final AsyncCallback<Boolean> callback) {
        OfferingsInterface.DistributionsRequest request = new OfferingsInterface.DistributionsRequest();
        request.setBackId(Window.Location.getParameter((String)"backId"));
        request.setBackType(Window.Location.getParameter((String)"backType"));
        request.setFilter(this.iFilter.getValue());
        this.iFilter.getFooter().clearMessage();
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        this.iFilter.getFooter().showLoading();
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().setEnabled("exportCsv", false);
        this.iFilter.getFooter().setEnabled("exportXls", false);
        this.iFilter.getFooter().setEnabled("exportPdf", false);
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<OfferingsInterface.DistributionsResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                DistributionsPage.this.iFilter.getFooter().setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                DistributionsPage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(OfferingsInterface.DistributionsResponse result) {
                LoadingWidget.hideLoading();
                DistributionsPage.this.iFilter.getFooter().clearMessage();
                if (result.hasTables()) {
                    for (final TableInterface table : result.getTables()) {
                        UniTimeHeaderPanel header = new UniTimeHeaderPanel(table.getName());
                        if (DistributionsPage.this.iConfig.isCanAdd()) {
                            header.addButton("add-distribution", COURSE.actionAddDistributionPreference(), new ClickHandler(){

                                public void onClick(ClickEvent e) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + "distributionAdd?subjectId=" + table.getId());
                                }
                            });
                            header.getButton("add-distribution").setAccessKey(COURSE.accessAddDistributionPreference().charAt(0));
                            header.getButton("add-distribution").setTitle(COURSE.titleAddDistributionPreference(COURSE.accessAddDistributionPreference()));
                        }
                        if (table.hasAnchor()) {
                            Anchor a = new Anchor();
                            a.setName(table.getAnchor());
                            a.getElement().setId(table.getAnchor());
                            header.insertLeft((Widget)a, false);
                        }
                        if (table.getLinks() != null) {
                            for (final TableInterface.LinkInteface link : table.getLinks()) {
                                Anchor a = new Anchor(link.getText());
                                if (link.getHref().startsWith("#")) {
                                    a.addClickHandler(new ClickHandler(){

                                        public void onClick(ClickEvent e) {
                                            e.preventDefault();
                                            Element el = Document.get().getElementById(link.getHref().substring(1));
                                            if (el != null) {
                                                ToolBox.scrollToElement(el);
                                                History.newItem((String)link.getHref().substring(1), (boolean)false);
                                            }
                                        }
                                    });
                                } else {
                                    a.setHref(link.getHref());
                                }
                                header.insertRight((Widget)a, false);
                            }
                        }
                        DistributionsPage.this.iPanel.addHeaderRow((Widget)header);
                        P p = new P(DistributionsPage.this.iConfig.isSticky() ? "unitime-StickyTable" : "unitime-ScrollTable");
                        p.getElement().getStyle().clearPosition();
                        p.getElement().getStyle().clearOverflow();
                        p.add((Widget)new TableWidget(table));
                        DistributionsPage.this.iPanel.addRow((Widget)p);
                    }
                }
                DistributionsPage.this.iFilter.getFooter().setEnabled("search", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportCsv", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportXls", true);
                DistributionsPage.this.iFilter.getFooter().setEnabled("exportPdf", true);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Element e;
                        String token = Window.Location.getHash();
                        if (token != null && (token.startsWith("#A") || token.equals("#back")) && (e = Document.get().getElementById(token.substring(1))) != null) {
                            ToolBox.scrollToElement(e);
                        }
                        if ((e = Document.get().getElementById("back")) != null) {
                            ToolBox.scrollToElement(e);
                        }
                    }
                });
                if (DistributionsPage.this.iConfig.isCanAdd()) {
                    UniTimeHeaderPanel footer = new UniTimeHeaderPanel("");
                    footer.addButton("add-distribution", COURSE.actionAddDistributionPreference(), new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            ToolBox.open(GWT.getHostPageBaseURL() + "distributionPrefs.action?op=" + URL.encodeQueryString((String)COURSE.actionAddDistributionPreference()));
                        }
                    });
                    footer.getButton("add-distribution").setAccessKey(COURSE.accessAddDistributionPreference().charAt(0));
                    footer.getButton("add-distribution").setTitle(COURSE.titleAddDistributionPreference(COURSE.accessAddDistributionPreference()));
                    DistributionsPage.this.iPanel.addBottomRow((Widget)footer);
                }
                if (callback != null) {
                    callback.onSuccess((Object)result.hasTables());
                }
            }
        });
    }

    protected void export(String format) {
        ToolBox.open(GWT.getHostPageBaseURL() + "export?output=" + format + "&sid=" + this.iConfig.getSessionId() + this.iFilter.getFullQuery());
    }
}

