/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class CourseCatalogPage
extends HTML {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);

    public CourseCatalogPage() {
        this.addStyleName("unitime-CourseCatalogPage");
        this.removeStyleName("unitime-NotPrintableBottomLine");
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        RPC.execute(new CatalogRequest(Window.Location.getParameter((String)"term"), Window.Location.getParameter((String)"subjectCode"), Window.Location.getParameter((String)"courseNumber")), new AsyncCallback<CatalogResponse>(){

            public void onSuccess(CatalogResponse response) {
                LoadingWidget.getInstance().hide();
                CourseCatalogPage.this.setHTML(response.getContent());
                NodeList scripts = CourseCatalogPage.this.getElement().getElementsByTagName("script");
                if (scripts != null) {
                    for (int i = 0; i < scripts.getLength(); ++i) {
                        ToolBox.eval(((Element)scripts.getItem(i)).getInnerHTML());
                    }
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                CourseCatalogPage.this.setHTML(MESSAGES.failedLoadData(caught.getMessage()));
                CourseCatalogPage.this.addStyleName("unitime-ErrorMessage");
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
            }
        });
    }

    public static class CatalogRequest
    implements GwtRpcRequest<CatalogResponse> {
        private String iTerm;
        private String iSubject;
        private String iCourseNbr;

        public CatalogRequest() {
        }

        public CatalogRequest(String term, String subject, String courseNbr) {
            this.iTerm = term;
            this.iSubject = subject;
            this.iCourseNbr = courseNbr;
        }

        public String getTerm() {
            return this.iTerm;
        }

        public void setTerm(String term) {
            this.iTerm = term;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourseNbr() {
            return this.iCourseNbr;
        }

        public void setCourseNbr(String courseNbr) {
            this.iCourseNbr = courseNbr;
        }

        @Override
        public String toString() {
            return this.getSubject() + " " + this.getCourseNbr() + " (" + this.getTerm() + ")";
        }
    }

    public static class CatalogResponse
    implements GwtRpcResponse {
        private String iContent;

        public boolean hasContent() {
            return this.iContent != null && !this.iContent.isEmpty();
        }

        public String getContent() {
            return this.iContent;
        }

        public void setContent(String pageLabel) {
            this.iContent = pageLabel;
        }
    }
}

