/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

public class InstructorSurveyInterface
implements IsSerializable {
    public static boolean equalsString(String o1, String o2) {
        return (o1 == null ? "" : o1).equals(o2 == null ? "" : o2);
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static class ListCurricula
    implements GwtRpcRequest<GwtRpcResponseList<CurriculumInterface>> {
        private Long iSessionId;
        private String iCourse;
        private Long iCourseId;

        public ListCurricula() {
        }

        public ListCurricula(Long sessionId, String course, Long courseId) {
            this.iSessionId = sessionId;
            this.iCourse = course;
            this.iCourseId = courseId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }
    }

    public static class ListAcademicClassifications
    implements GwtRpcRequest<GwtRpcResponseList<CurriculumInterface.AcademicClassificationInterface>> {
        private Long iSessionId;

        public ListAcademicClassifications() {
        }

        public ListAcademicClassifications(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }
    }

    public static class ListClasses
    implements GwtRpcRequest<GwtRpcResponseList<ClassAssignmentInterface.ClassAssignment>> {
        private Long iSessionId;
        private String iCourse;
        private Long iCourseId;

        public ListClasses() {
        }

        public ListClasses(Long sessionId, String course, Long courseId) {
            this.iSessionId = sessionId;
            this.iCourse = course;
            this.iCourseId = courseId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }
    }

    public static class RetrieveCourseDetail
    implements GwtRpcRequest<CourseDetail> {
        private Long iSessionId;
        private String iCourse;
        private Long iCourseId;

        public RetrieveCourseDetail() {
        }

        public RetrieveCourseDetail(Long sessionId, String course, Long courseId) {
            this.iSessionId = sessionId;
            this.iCourse = course;
            this.iCourseId = courseId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }
    }

    public static class CourseDetail
    implements GwtRpcResponse {
        private String iDetail;

        public CourseDetail() {
        }

        public CourseDetail(String detail) {
            this.iDetail = detail;
        }

        public String getDetail() {
            return this.iDetail;
        }

        public void setDetail(String detail) {
            this.iDetail = detail;
        }
    }

    public static class ListCourseOfferings
    implements GwtRpcRequest<GwtRpcResponseList<ClassAssignmentInterface.CourseAssignment>> {
        private Long iSessionId;
        private String iQuery;
        private Integer iLimit;

        public ListCourseOfferings() {
        }

        public ListCourseOfferings(Long sessionId, String query, Integer limit) {
            this.iSessionId = sessionId;
            this.iQuery = query;
            this.iLimit = limit;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }

        public Integer getLimit() {
            return this.iLimit;
        }

        public void setLimit(Integer limit) {
            this.iLimit = limit;
        }
    }

    public static enum Problem {
        NOT_APPLIED,
        LEVEL_CHANGED,
        NOT_IN_SURVEY,
        DIFFERENT_DEPT;

    }

    public static enum CourseColumn {
        COURSE,
        CUSTOM;

    }

    public static class Course
    extends CurriculumInterface.CourseInterface {
        private static final long serialVersionUID = -6299843281001361412L;
        private Long iId;
        private String iCourseTitle;
        private Map<Long, String> iCustoms;

        public Course() {
        }

        public Course(Course course) {
            super(course);
            this.iId = course.iId;
            this.iCourseTitle = course.iCourseTitle;
            if (course.iCustoms != null) {
                this.iCustoms = new HashMap<Long, String>(course.iCustoms);
            }
        }

        public boolean isEmpty() {
            return !this.hasCourseName() && !this.hasCustomFields();
        }

        public Long getReqId() {
            return this.iId;
        }

        public void setReqId(Long id) {
            this.iId = id;
        }

        public boolean hasCourseTitle() {
            return this.iCourseTitle != null && !this.iCourseTitle.isEmpty();
        }

        public String getCourseTitle() {
            return this.iCourseTitle;
        }

        public void setCourseTitle(String courseTitle) {
            this.iCourseTitle = courseTitle;
        }

        public boolean hasCustomField(CustomField f) {
            String val = this.getCustomField(f);
            return val != null && !val.isEmpty();
        }

        public String getCustomField(CustomField f) {
            if (this.iCustoms == null) {
                return null;
            }
            return this.iCustoms.get(f.getId());
        }

        public String getCustomField(Long id) {
            if (this.iCustoms == null) {
                return null;
            }
            return this.iCustoms.get(id);
        }

        public void setCustomField(CustomField f, String value) {
            if (this.iCustoms == null) {
                this.iCustoms = new HashMap<Long, String>();
            }
            if (value != null && !value.isEmpty()) {
                this.iCustoms.put(f.getId(), value);
            } else {
                this.iCustoms.remove(f.getId());
            }
        }

        public void setCustomField(long customFieldId, String value) {
            if (this.iCustoms == null) {
                this.iCustoms = new HashMap<Long, String>();
            }
            if (value != null && !value.isEmpty()) {
                this.iCustoms.put(customFieldId, value);
            } else {
                this.iCustoms.remove(customFieldId);
            }
        }

        public boolean hasCustomFields() {
            return this.iCustoms != null && !this.iCustoms.isEmpty();
        }

        public void clearCustomFields() {
            this.iCustoms = null;
        }

        @Override
        public boolean equals(Object o) {
            int otherCustom;
            if (o == null || !(o instanceof Course)) {
                return false;
            }
            Course course = (Course)o;
            if (!InstructorSurveyInterface.equals(this.getId(), course.getId())) {
                return false;
            }
            if (!InstructorSurveyInterface.equalsString(this.getCourseName(), course.getCourseName())) {
                return false;
            }
            int custom = this.iCustoms == null ? 0 : this.iCustoms.size();
            int n = otherCustom = course.iCustoms == null ? 0 : course.iCustoms.size();
            if (custom != otherCustom) {
                return false;
            }
            if (custom > 0) {
                for (Map.Entry<Long, String> e : this.iCustoms.entrySet()) {
                    if (InstructorSurveyInterface.equals(e.getValue(), course.iCustoms.get(e.getKey()))) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "{ id : " + this.getId() + ", name : " + (String)(this.getCourseName() == null ? "null" : "'" + this.getCourseName() + "'") + ", customs: " + String.valueOf(this.iCustoms) + "}";
        }
    }

    public static class CustomField
    implements IsSerializable {
        private Long iId;
        private String iName;
        private int iLength;

        public CustomField() {
        }

        public CustomField(Long id, String name, int length) {
            this.iId = id;
            this.iName = name;
            this.iLength = length;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CustomField)) {
                return false;
            }
            return this.getId().equals(((CustomField)o).getId());
        }

        public String toString() {
            return "{ id : " + this.iId + ", name : " + (String)(this.iName == null ? "null" : "'" + this.iName + "'") + ", length: " + this.iLength + "}";
        }
    }

    public static class InstructorTimePreferencesModel
    extends InstructorAvailabilityWidget.InstructorAvailabilityModel {
        private Problem iProblem = Problem.NOT_APPLIED;
        private String iInstructorPattern;

        public InstructorTimePreferencesModel() {
        }

        public InstructorTimePreferencesModel(InstructorTimePreferencesModel model) {
            super(model);
            this.iProblem = model.iProblem;
            this.iInstructorPattern = model.iInstructorPattern;
        }

        @Override
        public boolean hasNote() {
            return false;
        }

        public Problem getProblem() {
            return this.iProblem;
        }

        public void setProblem(Problem problem) {
            this.iProblem = problem;
        }

        public String getInstructorPattern() {
            return this.iInstructorPattern;
        }

        public void setInstructorPattern(String pattern) {
            this.iInstructorPattern = pattern;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof InstructorTimePreferencesModel)) {
                return false;
            }
            InstructorTimePreferencesModel p = (InstructorTimePreferencesModel)o;
            return (this.isEmpty() && p.isEmpty() || InstructorSurveyInterface.equals(this.getPattern(), p.getPattern())) && InstructorSurveyInterface.equalsString(this.getNote(), p.getNote());
        }

        @Override
        public String toString() {
            return "{ pattern : " + (String)(this.isEmpty() ? "null" : "'" + this.getPattern() + "'") + ", note : " + (String)(this.getNote() == null ? "null" : "'" + this.getNote() + "'") + "}";
        }
    }

    public static class InstructorSurveyCopyRequest
    implements GwtRpcRequest<InstructorSurveyData> {
        private InstructorSurveyData iData;
        private Long iPreferencesSessionId;
        private Long iCoursesSessionId;

        public InstructorSurveyCopyRequest() {
        }

        public InstructorSurveyCopyRequest(InstructorSurveyData data, Long preferencesSessionId, Long coursesSessionId) {
            this.iData = data;
            this.iPreferencesSessionId = preferencesSessionId;
            this.iCoursesSessionId = coursesSessionId;
        }

        public InstructorSurveyData getData() {
            return this.iData;
        }

        public void setData(InstructorSurveyData data) {
            this.iData = data;
        }

        public Long getPreferencesSessionId() {
            return this.iPreferencesSessionId;
        }

        public void setPreferencesSessionId(Long sessionId) {
            this.iPreferencesSessionId = sessionId;
        }

        public Long getCoursesSessionId() {
            return this.iCoursesSessionId;
        }

        public void setCoursesSessionId(Long sessionId) {
            this.iCoursesSessionId = sessionId;
        }
    }

    public static class InstructorSurveySaveRequest
    implements GwtRpcRequest<InstructorSurveyData> {
        private InstructorSurveyData iData;
        private Long iInstructorId;
        private boolean iSubmit = false;
        private boolean iUnsubmit = false;
        private boolean iChanged = true;

        public InstructorSurveySaveRequest() {
        }

        public InstructorSurveySaveRequest(InstructorSurveyData data, boolean submit) {
            this.iData = data;
            this.iSubmit = submit;
        }

        public InstructorSurveyData getData() {
            return this.iData;
        }

        public void setData(InstructorSurveyData data) {
            this.iData = data;
        }

        public boolean isSubmit() {
            return this.iSubmit;
        }

        public void setSubmit(boolean submit) {
            this.iSubmit = submit;
        }

        public boolean isUnsubmit() {
            return this.iUnsubmit;
        }

        public void setUnsubmit(boolean unsubmit) {
            this.iUnsubmit = unsubmit;
        }

        public boolean isChanged() {
            return this.iChanged;
        }

        public void setChanged(boolean changed) {
            this.iChanged = changed;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }
    }

    public static class InstructorSurveyDeleteRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private Long iInstructorId;

        public InstructorSurveyDeleteRequest() {
        }

        public InstructorSurveyDeleteRequest(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }
    }

    public static class InstructorSurveyApplyRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private Long iInstructorId;

        public InstructorSurveyApplyRequest() {
        }

        public InstructorSurveyApplyRequest(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }
    }

    public static class InstructorRequirementsRequest
    implements GwtRpcRequest<InstructorRequirementData> {
        private Long iOfferingId;

        public InstructorRequirementsRequest() {
        }

        public InstructorRequirementsRequest(Long offeringId) {
            this.iOfferingId = offeringId;
        }

        public Long getOfferingId() {
            return this.iOfferingId;
        }

        public void setOfferingId(Long offeringId) {
            this.iOfferingId = offeringId;
        }
    }

    public static class InstructorSurveyRequest
    implements GwtRpcRequest<InstructorSurveyData> {
        private String iExternalId;
        private Long iInstructorId;
        private String iSession;

        public InstructorSurveyRequest() {
        }

        public InstructorSurveyRequest(String externalId, String session) {
            this.iExternalId = externalId;
            this.iSession = session;
        }

        public InstructorSurveyRequest(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public String getSession() {
            return this.iSession;
        }

        public boolean hasSession() {
            return this.iSession != null && !this.iSession.isEmpty();
        }

        public void setSession(String session) {
            this.iSession = session;
        }
    }

    public static class PrefLevel
    implements IsSerializable {
        private Long iId;
        private String iLabel;
        private String iTitle;
        private String iColor;
        private String iCode;

        public PrefLevel() {
        }

        public PrefLevel(Long id, String code, String label, String title, String color) {
            this.iId = id;
            this.iCode = code;
            this.iLabel = label;
            this.iTitle = title;
            this.iColor = color;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public boolean isHard() {
            return "R".equals(this.iCode) || "P".equals(this.iCode);
        }

        public String toString() {
            return "{ id : " + this.iId + ", label : " + (String)(this.iLabel == null ? "null" : "'" + this.iLabel + "'") + "}";
        }
    }

    public static class CourseRequirement
    extends Course
    implements IsSerializable {
        private static final long serialVersionUID = -5015960311677295275L;
        private String iExternalId;
        private Long iInstructorId;
        private String iInstructorName;
        private String iNote;
        private String iTime;
        private String iRoom;
        private String iDist;
        private String iTimeHtml;
        private String iRoomHtml;
        private String iDistHtml;

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public String getInstructorName() {
            return this.iInstructorName;
        }

        public void setInstructorName(String instructorName) {
            this.iInstructorName = instructorName;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasTime() {
            return this.iTime != null && !this.iTime.isEmpty();
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public boolean hasRoom() {
            return this.iRoom != null && !this.iRoom.isEmpty();
        }

        public String getRoom() {
            return this.iRoom;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public void addRoom(String room) {
            this.iRoom = this.iRoom == null ? room : this.iRoom + "\n" + room;
        }

        public boolean hasDist() {
            return this.iDist != null && !this.iDist.isEmpty();
        }

        public String getDist() {
            return this.iDist;
        }

        public void setDist(String dist) {
            this.iDist = dist;
        }

        public void addDist(String dist) {
            this.iDist = this.iDist == null ? dist : this.iDist + "\n" + dist;
        }

        public boolean hasTimeHtml() {
            return this.iTimeHtml != null && !this.iTimeHtml.isEmpty();
        }

        public String getTimeHtml() {
            return this.iTimeHtml;
        }

        public void setTimeHtml(String time) {
            this.iTimeHtml = time;
        }

        public boolean hasRoomHtml() {
            return this.iRoomHtml != null && !this.iRoomHtml.isEmpty();
        }

        public String getRoomHtml() {
            return this.iRoomHtml;
        }

        public void setRoomHtml(String room) {
            this.iRoomHtml = room;
        }

        public void addRoomHtml(String room) {
            this.iRoomHtml = this.iRoomHtml == null ? room : this.iRoomHtml + "\n" + room;
        }

        public boolean hasDistHtml() {
            return this.iDistHtml != null && !this.iDistHtml.isEmpty();
        }

        public String getDistHtml() {
            return this.iDistHtml;
        }

        public void setDistHtml(String dist) {
            this.iDistHtml = dist;
        }

        public void addDistHtml(String dist) {
            this.iDistHtml = this.iDistHtml == null ? dist : this.iDistHtml + "\n" + dist;
        }
    }

    public static class InstructorRequirementData
    implements GwtRpcResponse {
        private List<CustomField> iCustomFields;
        private List<CourseRequirement> iInstructorRequirements;
        private boolean iCrossList = false;
        private boolean iAdmin = false;

        public List<CustomField> getCustomFields() {
            return this.iCustomFields;
        }

        public boolean hasCustomFields() {
            return this.iCustomFields != null && !this.iCustomFields.isEmpty();
        }

        public void addCustomField(CustomField f) {
            if (this.iCustomFields == null) {
                this.iCustomFields = new ArrayList<CustomField>();
            }
            this.iCustomFields.add(f);
        }

        public CustomField getCustomField(Long id) {
            if (this.iCustomFields == null) {
                return null;
            }
            for (CustomField cf : this.iCustomFields) {
                if (!cf.getId().equals(id)) continue;
                return cf;
            }
            return null;
        }

        public boolean hasInstructorRequirements() {
            return this.iInstructorRequirements != null && !this.iInstructorRequirements.isEmpty();
        }

        public List<CourseRequirement> getInstructorRequirements() {
            return this.iInstructorRequirements;
        }

        public void addInstructorRequirement(CourseRequirement instructorRequirement) {
            if (this.iInstructorRequirements == null) {
                this.iInstructorRequirements = new ArrayList<CourseRequirement>();
            }
            this.iInstructorRequirements.add(instructorRequirement);
        }

        public boolean isCrossList() {
            return this.iCrossList;
        }

        public void setCrossList(boolean crossList) {
            this.iCrossList = crossList;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }
    }

    public static class InstructorDepartment
    implements IsSerializable {
        private Long iId;
        private String iLabel;
        private String iDeptCode;
        private IdLabel iPosition;

        public InstructorDepartment() {
        }

        public InstructorDepartment(Long id, String deptCode, String label, IdLabel position) {
            this.iId = id;
            this.iDeptCode = deptCode;
            this.iLabel = label;
            this.iPosition = position;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getDeptCode() {
            return this.iDeptCode;
        }

        public void setDeptCode(String deptCode) {
            this.iDeptCode = deptCode;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean hasPosition() {
            return this.iPosition != null;
        }

        public IdLabel getPosition() {
            return this.iPosition;
        }

        public void setPosition(IdLabel position) {
            this.iPosition = position;
        }

        public String toString() {
            return "{ id : " + this.iId + ", label : " + (String)(this.iLabel == null ? "null" : "'" + this.iLabel + "'") + ", dept : " + (String)(this.iDeptCode == null ? "null" : "'" + this.iDeptCode + "'") + "}";
        }
    }

    public static class IdLabel
    implements IsSerializable,
    Comparable<IdLabel> {
        private Long iId;
        private String iLabel;
        private String iDescription;
        private Set<Long> iAllowedPrefs = null;

        public IdLabel() {
        }

        public IdLabel(Long id, String label, String description) {
            this.iId = id;
            this.iLabel = label;
            this.iDescription = description;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassAssignmentInterface.IdValue)) {
                return false;
            }
            return this.getId().equals(((ClassAssignmentInterface.IdValue)o).getId());
        }

        @Override
        public int compareTo(IdLabel other) {
            return this.getLabel().compareTo(other.getLabel());
        }

        public boolean hasAllowedPrefs() {
            return this.iAllowedPrefs != null;
        }

        public void addAllowedPref(Long id) {
            if (this.iAllowedPrefs == null) {
                this.iAllowedPrefs = new HashSet<Long>();
            }
            this.iAllowedPrefs.add(id);
        }

        public boolean isAllowedPref(Long id) {
            if (id == null || this.iAllowedPrefs == null) {
                return true;
            }
            return this.iAllowedPrefs.contains(id);
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public String getDescription() {
            return this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String toString() {
            return "{ id : " + this.iId + ", label : " + (String)(this.iLabel == null ? "null" : "'" + this.iLabel + "'") + "}";
        }
    }

    public static class Preferences
    implements IsSerializable,
    Comparable<Preferences> {
        private Long iId;
        private String iType;
        private TreeSet<IdLabel> iItems;
        private List<Selection> iSelections;

        public Preferences() {
        }

        public Preferences(Long id, String type) {
            this.iId = id;
            this.iType = type;
        }

        public Preferences(Preferences p) {
            this.iId = p.iId;
            this.iType = p.iType;
            if (p.iItems != null) {
                this.iItems = new TreeSet<IdLabel>((SortedSet<IdLabel>)p.iItems);
            }
            if (p.iSelections != null) {
                this.iSelections = new ArrayList<Selection>(p.iSelections);
            }
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean hasItems() {
            return this.iItems != null && !this.iItems.isEmpty();
        }

        public Set<IdLabel> getItems() {
            return this.iItems;
        }

        public IdLabel getItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            for (IdLabel item : this.iItems) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addItem(Long id, String label, String description) {
            IdLabel item;
            if (this.iItems == null) {
                this.iItems = new TreeSet();
            }
            if (!this.iItems.contains(item = new IdLabel(id, label, description))) {
                this.iItems.add(item);
                return item;
            }
            return null;
        }

        public IdLabel removeItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iItems.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        @Override
        public int compareTo(Preferences other) {
            return this.getType().compareTo(other.getType());
        }

        public boolean hasSelections() {
            return this.iSelections != null && !this.iSelections.isEmpty();
        }

        public void clearSelections() {
            if (this.iSelections != null) {
                this.iSelections.clear();
            }
        }

        public boolean isEmpty() {
            if (this.iSelections != null) {
                for (Selection s : this.iSelections) {
                    if (s.getLevel() == null) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasSelections(boolean showDifferences) {
            if (showDifferences) {
                return this.hasSelections();
            }
            return !this.isEmpty();
        }

        public List<Selection> getSelections() {
            return this.iSelections;
        }

        public void addSelection(Selection selection) {
            if (this.iSelections == null) {
                this.iSelections = new ArrayList<Selection>();
            }
            if (this.getItem(selection.getItem()) != null) {
                this.iSelections.add(selection);
            }
        }

        public void addInstructorSelection(Selection selection) {
            Selection original = this.getSelection(selection.getItem());
            if (original == null) {
                selection.setProblem(Problem.NOT_IN_SURVEY);
                selection.setInstructorLevel(selection.getLevel());
                selection.setLevel(null);
                this.addSelection(selection);
            } else if (original.getLevel().equals(selection.getLevel())) {
                original.setProblem(null);
            } else {
                original.setProblem(Problem.LEVEL_CHANGED);
                original.setInstructorLevel(selection.getLevel());
            }
        }

        public Selection getSelection(Long item) {
            if (this.iSelections == null) {
                return null;
            }
            for (Selection selection : this.iSelections) {
                if (!item.equals(selection.getItem())) continue;
                return selection;
            }
            return null;
        }

        public boolean equals(Object obj) {
            int originalSelections;
            if (obj == null || !(obj instanceof Preferences)) {
                return false;
            }
            Preferences original = (Preferences)obj;
            if (!InstructorSurveyInterface.equals(this.iId, original.iId)) {
                return false;
            }
            int selections = this.iSelections == null ? 0 : this.iSelections.size();
            int n = originalSelections = original.iSelections == null ? 0 : original.iSelections.size();
            if (selections != originalSelections) {
                return false;
            }
            if (selections > 0) {
                block0: for (Selection s : this.iSelections) {
                    for (Selection o : original.iSelections) {
                        if (!s.equals(o)) continue;
                        continue block0;
                    }
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "{ id : " + this.iId + ", type : " + (String)(this.iType == null ? "null" : "'" + this.iType + "'") + ", selections: " + String.valueOf(this.iSelections) + "}";
        }
    }

    public static class Selection
    implements IsSerializable {
        private Long iItem;
        private Long iLevel;
        private Long iInstructorLevel;
        private String iNote;
        private Problem iProblem = Problem.NOT_APPLIED;

        public Selection() {
        }

        public Selection(Long item, Long level, String note) {
            this.iItem = item;
            this.iLevel = level;
            this.iNote = note;
        }

        public Long getItem() {
            return this.iItem;
        }

        public void setItem(Long item) {
            this.iItem = item;
        }

        public Long getLevel() {
            return this.iLevel;
        }

        public void setLevel(Long level) {
            this.iLevel = level;
        }

        public Long getInstructorLevel() {
            return this.iInstructorLevel;
        }

        public void setInstructorLevel(Long level) {
            this.iInstructorLevel = level;
        }

        public String getNote() {
            return this.iNote;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public Problem getProblem() {
            return this.iProblem;
        }

        public void setProblem(Problem problem) {
            this.iProblem = problem;
        }

        public Selection withProblem(Problem problem) {
            this.iProblem = problem;
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Selection)) {
                return false;
            }
            Selection s = (Selection)o;
            return InstructorSurveyInterface.equals(this.iItem, s.iItem) && InstructorSurveyInterface.equals(this.iLevel, s.iLevel) && InstructorSurveyInterface.equalsString(this.iNote, s.iNote);
        }

        public String toString() {
            return "{ item : " + this.iItem + ", level : " + this.iLevel + ", note : " + (String)(this.iNote == null ? "null" : "'" + this.iNote + "'") + "}";
        }
    }

    public static class InstructorSurveyData
    implements GwtRpcResponse {
        private Long iId;
        private Long iSessionId;
        private String iExternalId;
        private String iFormattedName;
        private String iEmail;
        private String iNote;
        private String iChangedBy;
        private String iAppliedDept;
        private Date iSubmitted;
        private Date iApplied;
        private Date iChanged;
        private List<InstructorDepartment> iDepartments;
        private InstructorTimePreferencesModel iTimePrefs;
        private List<Preferences> iRoomPrefs;
        private Preferences iDistPrefs;
        private List<PrefLevel> iPrefLevels;
        private List<Course> iCourses;
        private List<CustomField> iCustomFields;
        private boolean iEditable = true;
        private boolean iCanApply = true;
        private boolean iAdmin = true;
        private boolean iCanDelete = true;
        private List<AcademicSessionProvider.AcademicSessionInfo> iSessions = null;
        private List<AcademicSessionProvider.AcademicSessionInfo> iSessionsWithPreferences = null;
        private List<AcademicSessionProvider.AcademicSessionInfo> iSessionsWithCourses = null;
        private String iPopupMessage;
        private boolean iPopupWarning;

        public InstructorSurveyData() {
        }

        public InstructorSurveyData(InstructorSurveyData data) {
            this.iId = data.iId;
            this.iSessionId = data.iSessionId;
            this.iExternalId = data.iExternalId;
            this.iFormattedName = data.iFormattedName;
            this.iEmail = data.iEmail;
            this.iNote = data.iNote;
            this.iChangedBy = data.iChangedBy;
            this.iAppliedDept = data.iAppliedDept;
            this.iSubmitted = data.iSubmitted;
            this.iApplied = data.iApplied;
            this.iChanged = data.iChanged;
            if (data.iDepartments != null) {
                this.iDepartments = new ArrayList<InstructorDepartment>(data.iDepartments);
            }
            if (data.iTimePrefs != null) {
                this.iTimePrefs = new InstructorTimePreferencesModel(data.iTimePrefs);
            }
            if (data.iRoomPrefs != null) {
                for (Preferences p : data.iRoomPrefs) {
                    this.addRoomPreference(new Preferences(p));
                }
            }
            if (data.iDistPrefs != null) {
                this.iDistPrefs = new Preferences(data.iDistPrefs);
            }
            if (data.iPrefLevels != null) {
                this.iPrefLevels = new ArrayList<PrefLevel>(data.iPrefLevels);
            }
            if (data.iCourses != null) {
                for (Course course : data.iCourses) {
                    this.addCourse(new Course(course));
                }
            }
            if (data.iCustomFields != null) {
                this.iCustomFields = new ArrayList<CustomField>(data.iCustomFields);
            }
            this.iEditable = data.iEditable;
            this.iCanApply = data.iCanApply;
            this.iCanDelete = data.iCanDelete;
            this.iAdmin = data.iAdmin;
            if (data.iSessions != null) {
                this.iSessions = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>(data.iSessions);
            }
            if (data.iSessionsWithPreferences != null) {
                this.iSessionsWithPreferences = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>(data.iSessionsWithPreferences);
            }
            if (data.iSessionsWithCourses != null) {
                this.iSessionsWithCourses = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>(data.iSessionsWithCourses);
            }
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getFormattedName() {
            return this.iFormattedName;
        }

        public void setFormattedName(String name) {
            this.iFormattedName = name;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isCanApply() {
            return this.iCanApply;
        }

        public void setCanApply(boolean canApply) {
            this.iCanApply = canApply;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }

        public boolean hasEmail() {
            return this.iEmail != null && !this.iEmail.isEmpty();
        }

        public String getEmail() {
            return this.iEmail;
        }

        public void setEmail(String email) {
            this.iEmail = email;
        }

        public Date getSubmitted() {
            return this.iSubmitted;
        }

        public void setSubmitted(Date submitted) {
            this.iSubmitted = submitted;
        }

        public String getAppliedDeptCode() {
            return this.iAppliedDept;
        }

        public void setAppliedDeptCode(String deptCode) {
            this.iAppliedDept = deptCode;
        }

        public Date getApplied() {
            return this.iApplied;
        }

        public void setApplied(Date applied) {
            this.iApplied = applied;
        }

        public String getChangedBy() {
            return this.iChangedBy;
        }

        public void setChangedBy(String changedBy) {
            this.iChangedBy = changedBy;
        }

        public Date getChanged() {
            return this.iChanged;
        }

        public void setChanged(Date changed) {
            this.iChanged = changed;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasDepartments() {
            return this.iDepartments != null && !this.iDepartments.isEmpty();
        }

        public boolean hasDepartment(Long id) {
            if (this.iDepartments == null || id == null) {
                return false;
            }
            for (InstructorDepartment d : this.iDepartments) {
                if (!d.getId().equals(id)) continue;
                return true;
            }
            return false;
        }

        public List<InstructorDepartment> getDepartments() {
            return this.iDepartments;
        }

        public void addDepartment(InstructorDepartment dept) {
            if (this.iDepartments == null) {
                this.iDepartments = new ArrayList<InstructorDepartment>();
            }
            this.iDepartments.add(dept);
        }

        public InstructorTimePreferencesModel getTimePrefs() {
            return this.iTimePrefs;
        }

        public void setTimePrefs(InstructorTimePreferencesModel timePrefs) {
            this.iTimePrefs = timePrefs;
        }

        public boolean hasRoomPreferences() {
            return this.iRoomPrefs != null && !this.iRoomPrefs.isEmpty();
        }

        public List<Preferences> getRoomPreferences() {
            return this.iRoomPrefs;
        }

        public void addRoomPreference(Preferences pref) {
            if (this.iRoomPrefs == null) {
                this.iRoomPrefs = new ArrayList<Preferences>();
            }
            this.iRoomPrefs.add(pref);
        }

        public Preferences getRoomPreference(Long id) {
            if (this.iRoomPrefs == null) {
                return null;
            }
            for (Preferences p : this.iRoomPrefs) {
                if (!id.equals(p.getId())) continue;
                return p;
            }
            return null;
        }

        public boolean hasDistributionPreferences() {
            return this.iDistPrefs != null && this.iDistPrefs.hasItems();
        }

        public Preferences getDistributionPreferences() {
            return this.iDistPrefs;
        }

        public void setDistributionPreferences(Preferences distPrefs) {
            this.iDistPrefs = distPrefs;
        }

        public void addPrefLevel(PrefLevel prefLevel) {
            if (this.iPrefLevels == null) {
                this.iPrefLevels = new ArrayList<PrefLevel>();
            }
            this.iPrefLevels.add(prefLevel);
        }

        public List<PrefLevel> getPrefLevels() {
            return this.iPrefLevels;
        }

        public PrefLevel getPrefLevel(Long id) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getId().equals(id)) continue;
                return level;
            }
            return null;
        }

        public PrefLevel getPrefLevel(String code) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getCode().equals(code)) continue;
                return level;
            }
            return null;
        }

        public boolean hasCourses() {
            return this.iCourses != null && !this.iCourses.isEmpty();
        }

        public List<Course> getCourses() {
            return this.iCourses;
        }

        public void addCourse(Course course) {
            if (this.iCourses == null) {
                this.iCourses = new ArrayList<Course>();
            }
            this.iCourses.add(course);
        }

        public void setCourses(List<Course> courses) {
            this.iCourses = courses;
        }

        public void clearCourses() {
            if (this.iCourses != null) {
                this.iCourses.clear();
            }
        }

        public List<CustomField> getCustomFields() {
            return this.iCustomFields;
        }

        public boolean hasCustomFields() {
            return this.iCustomFields != null && !this.iCustomFields.isEmpty();
        }

        public void addCustomField(CustomField f) {
            if (this.iCustomFields == null) {
                this.iCustomFields = new ArrayList<CustomField>();
            }
            this.iCustomFields.add(f);
        }

        public CustomField getCustomField(Long id) {
            if (this.iCustomFields == null) {
                return null;
            }
            for (CustomField cf : this.iCustomFields) {
                if (!cf.getId().equals(id)) continue;
                return cf;
            }
            return null;
        }

        public boolean hasSessions() {
            return this.iSessions != null && !this.iSessions.isEmpty();
        }

        public List<AcademicSessionProvider.AcademicSessionInfo> getSessions() {
            return this.iSessions;
        }

        public void addSession(AcademicSessionProvider.AcademicSessionInfo session) {
            if (this.iSessions == null) {
                this.iSessions = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
            }
            this.iSessions.add(session);
        }

        public boolean hasSessionsWithPreferences() {
            return this.iSessionsWithPreferences != null && !this.iSessionsWithPreferences.isEmpty();
        }

        public List<AcademicSessionProvider.AcademicSessionInfo> getSessionsWithPreferences() {
            return this.iSessionsWithPreferences;
        }

        public void addSessionWithPreferences(AcademicSessionProvider.AcademicSessionInfo session) {
            if (this.iSessionsWithPreferences == null) {
                this.iSessionsWithPreferences = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
            }
            this.iSessionsWithPreferences.add(session);
        }

        public boolean hasSessionsWithCourses() {
            return this.iSessionsWithCourses != null && !this.iSessionsWithCourses.isEmpty();
        }

        public List<AcademicSessionProvider.AcademicSessionInfo> getSessionsWithCourses() {
            return this.iSessionsWithCourses;
        }

        public void addSessionWithCourses(AcademicSessionProvider.AcademicSessionInfo session) {
            if (this.iSessionsWithCourses == null) {
                this.iSessionsWithCourses = new ArrayList<AcademicSessionProvider.AcademicSessionInfo>();
            }
            this.iSessionsWithCourses.add(session);
        }

        /*
         * WARNING - void declaration
         */
        public boolean isChanged(InstructorSurveyData data) {
            void var3_8;
            if (!InstructorSurveyInterface.equalsString(this.iExternalId, data.iExternalId)) {
                return true;
            }
            if (!InstructorSurveyInterface.equals(this.iSessionId, data.iSessionId)) {
                return true;
            }
            if (!InstructorSurveyInterface.equalsString(this.iEmail, data.iEmail)) {
                return true;
            }
            if (!InstructorSurveyInterface.equalsString(this.iNote, data.iNote)) {
                return true;
            }
            if (!InstructorSurveyInterface.equals(this.iTimePrefs, data.iTimePrefs)) {
                return true;
            }
            if (!InstructorSurveyInterface.equals(this.iDistPrefs, data.iDistPrefs)) {
                return true;
            }
            if (this.iRoomPrefs != null) {
                for (Preferences preferences : this.iRoomPrefs) {
                    if (InstructorSurveyInterface.equals(preferences, data.getRoomPreference(preferences.getId()))) continue;
                    return true;
                }
            }
            int courses = 0;
            if (this.iCourses != null) {
                block1: for (Course course : this.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    ++courses;
                    if (data.iCourses != null) {
                        for (Course o : data.iCourses) {
                            if (!course.equals(o)) continue;
                            continue block1;
                        }
                    }
                    return true;
                }
            }
            boolean bl = false;
            if (data.iCourses != null) {
                for (Course course : data.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    ++var3_8;
                }
            }
            return courses != var3_8;
        }

        /*
         * WARNING - void declaration
         */
        public String checkChanges(InstructorSurveyData data) {
            void var3_8;
            if (!InstructorSurveyInterface.equalsString(this.iExternalId, data.iExternalId)) {
                return "external id " + this.iExternalId + "\n vs " + data.iExternalId;
            }
            if (!InstructorSurveyInterface.equals(this.iSessionId, data.iSessionId)) {
                return "session id " + this.iSessionId + "\n vs " + data.iSessionId;
            }
            if (!InstructorSurveyInterface.equalsString(this.iEmail, data.iEmail)) {
                return "email " + this.iEmail + "\n vs " + data.iEmail;
            }
            if (!InstructorSurveyInterface.equalsString(this.iNote, data.iNote)) {
                return "note " + this.iNote + "\n vs " + data.iNote;
            }
            if (!InstructorSurveyInterface.equals(this.iTimePrefs, data.iTimePrefs)) {
                return "time " + String.valueOf(this.iTimePrefs) + "\n vs " + String.valueOf(data.iTimePrefs);
            }
            if (!InstructorSurveyInterface.equals(this.iDistPrefs, data.iDistPrefs)) {
                return this.iDistPrefs != null ? this.iDistPrefs.getType() : "dist " + String.valueOf(this.iDistPrefs) + "\n vs " + String.valueOf(data.iDistPrefs);
            }
            if (this.iRoomPrefs != null) {
                for (Preferences preferences : this.iRoomPrefs) {
                    if (InstructorSurveyInterface.equals(preferences, data.getRoomPreference(preferences.getId()))) continue;
                    return preferences.getType() + " " + String.valueOf(preferences) + "\n vs " + String.valueOf(data.getRoomPreference(preferences.getId()));
                }
            }
            int courses = 0;
            if (this.iCourses != null) {
                block1: for (Course course : this.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    ++courses;
                    if (data.iCourses != null) {
                        for (Course o : data.iCourses) {
                            if (!course.equals(o)) continue;
                            continue block1;
                        }
                    }
                    return "course " + String.valueOf(course);
                }
            }
            boolean bl = false;
            if (data.iCourses != null) {
                for (Course course : data.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    ++var3_8;
                }
            }
            if (courses != var3_8) {
                return "@#courses " + courses + "/" + String.valueOf(this.iCourses) + "\n vs " + (int)var3_8 + "/" + String.valueOf(data.iCourses);
            }
            return "NO CHANGE";
        }

        public boolean hasPopupMessage() {
            return this.iPopupMessage != null && !this.iPopupMessage.isEmpty();
        }

        public String getPopupMessage() {
            return this.iPopupMessage;
        }

        public void setPopupMessage(String popupMessage) {
            this.iPopupMessage = popupMessage;
        }

        public boolean isPopupWarning() {
            return this.iPopupWarning;
        }

        public void setPopupWarning(boolean popupWarning) {
            this.iPopupWarning = popupWarning;
        }

        public boolean isEmpty() {
            if (this.iCourses != null) {
                for (Course course : this.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    return false;
                }
            }
            if (this.iRoomPrefs != null) {
                for (Preferences p : this.iRoomPrefs) {
                    if (p.isEmpty()) continue;
                    return false;
                }
            }
            if (this.iTimePrefs != null && !this.iTimePrefs.isEmpty()) {
                return false;
            }
            return this.iDistPrefs == null || this.iDistPrefs.isEmpty();
        }

        public String toString() {
            String ret = "{ id : '" + this.iExternalId + "',\n  session : " + this.iSessionId + ",\n  email : " + (String)(this.iEmail == null ? "null" : "'" + this.iEmail + "'") + ",\n  note : " + (String)(this.iNote == null ? "null" : "'" + this.iNote + "'") + ",\n  time : " + String.valueOf(this.iTimePrefs) + ",\n  dist : " + String.valueOf(this.iDistPrefs);
            if (this.iRoomPrefs == null) {
                ret = ret + ",\n  room : null";
            } else {
                ret = ret + ",\n  room : [";
                for (Preferences p : this.iRoomPrefs) {
                    ret = ret + ",\n    " + String.valueOf(p);
                }
                ret = ret + "\n  ]";
            }
            if (this.iCourses == null) {
                ret = ret + ",\n  courses : null";
            } else {
                ret = ret + ",\n  courses : [";
                for (Course course : this.iCourses) {
                    if (!course.hasCustomFields()) continue;
                    ret = ret + ",\n    " + String.valueOf(course);
                }
                ret = ret + "\n  ]";
            }
            return ret + "\n}";
        }
    }
}

